package com.liecoder.framework.model

/**
 * 日期格式模式枚举，定义了多种日期和时间的显示格式。
 *
 * 此枚举类提供了一系列的日期时间格式选项，便于在应用程序中以统一的方式格式化日期和时间。
 * 每个枚举值都对应一个特定的日期时间格式字符串，这些字符串遵循 Java 的日期时间格式化规则。
 *
 * @author lieco(liecoder@163.com)
 * @date 2024/8/24
 * @version 1.0
 */
enum class DateFormatPattern(val pattern: String) {

    /**
     * 年月日格式，使用中文表述，例如 "2024年08月24日"。
     */
    YEAR_MONTH_DAY("yyyy年MM月dd日"),

    /**
     * 年月日格式，使用斜杠分隔，例如 "2024/08/24"。
     */
    YEAR_MONTH_DAY_SLASH("yyyy/MM/dd"),

    /**
     * 年月日格式，使用短横线分隔，例如 "2024-08-24"。
     */
    YEAR_MONTH_DAY_DASH("yyyy-MM-dd"),

    /**
     * 完整日期时间格式，使用中文表述，例如 "2024年08月24日 15:20:30"。
     */
    FULL_DATE_TIME("yyyy年MM月dd日 HH:mm:ss"),

    /**
     * 完整日期时间格式，使用斜杠分隔，例如 "2024/08/24 15:20:30"。
     */
    FULL_DATE_TIME_SLASH("yyyy/MM/dd HH:mm:ss"),

    /**
     * 完整日期时间格式，使用短横线分隔，例如 "2024-08-24 15:20:30"。
     */
    FULL_DATE_TIME_DASH("yyyy-MM-dd HH:mm:ss"),

    /**
     * 仅时间格式，例如 "15:20:30"。
     */
    TIME_ONLY("HH:mm:ss"),

    /**
     * 分和秒格式，例如 "20:30"。
     */
    MINUTE_SECOND("mm:ss"),

    /**
     * 小时和分钟格式，例如 "15:20"。
     */
    HOURS_MINUTES("HH:mm"),

    /**
     * 月和日格式，使用短横线分隔，例如 "08-24"。
     */
    MONTH_DAY("MM-dd"),

    /**
     * 仅年格式，例如 "2024"。
     */
    YEAR_ONLY("yyyy"),

    /**
     * 年月日时分格式，使用短横线分隔，例如 "2024-08-24 15:20"。
     */
    DATE_TIME("yyyy-MM-dd HH:mm"),

    /**
     * 简化的年月日格式，使用短横线分隔，例如 "24-08-24 15:20"。
     */
    YEAR_MONTH_DAY_SHORT("yy-MM-dd HH:mm"),

    /**
     * 简化的年月日格式，不包含时间，使用短横线分隔，例如 "24-08-24"。
     */
    YEAR_MONTH_DAY_SHORT_DASH("yy-MM-dd"),

    /**
     * 紧凑的日期时间格式，例如 "20240824 15:20:30"。
     */
    DATE_TIME_COMPACT("yyyyMMdd HH:mm:ss"),

    /**
     * 使用点分隔的日期时间格式，例如 "2024-08-24 15.mm.ss"。
     */
    DATE_TIME_DOT("yyyy-MM-dd HH.mm.ss"),

    /**
     * 仅月格式，例如 "08"。
     */
    MONTH_ONLY("MM"),

    /**
     * 仅日格式，例如 "24"。
     */
    DAY_ONLY("dd"),

    /**
     * 紧凑的日期格式，不包含时间，例如 "20240824"。
     */
    DATE_COMPACT("yyyyMMdd")
}
