package com.liecoder.framework.model

import android.Manifest

enum class Permission(
        val permissionType: String,
        val permissionName: String
) {
    READ_EXTERNAL_STORAGE(
            permissionType = Manifest.permission.READ_EXTERNAL_STORAGE,
            permissionName = "读取手机存储"
    ),
    WRITE_EXTERNAL_STORAGE(
            permissionType = Manifest.permission.WRITE_EXTERNAL_STORAGE,
            permissionName = "写入手机存储"
    ),
    CAMERA(
            permissionType = Manifest.permission.CAMERA,
            permissionName = "相机"
    ),
    RECORD_AUDIO(
            permissionType = Manifest.permission.RECORD_AUDIO,
            permissionName = "录音"
    ),
    ACCESS_FINE_LOCATION(
            permissionType = Manifest.permission.ACCESS_FINE_LOCATION,
            permissionName = "定位"
    ),
    ACCESS_COARSE_LOCATION(
            permissionType = Manifest.permission.ACCESS_COARSE_LOCATION,
            permissionName = "定位"
    ),
    READ_PHONE_STATE(
            permissionType = Manifest.permission.READ_PHONE_STATE,
            permissionName = "读取手机状态"
    ),
    READ_CONTACTS(
            permissionType = Manifest.permission.READ_CONTACTS,
            permissionName = "读取联系人"
    ),
    WRITE_CONTACTS(
            permissionType = Manifest.permission.WRITE_CONTACTS,
            permissionName = "写入联系人"
    ),
    GET_ACCOUNTS(
            permissionType = Manifest.permission.GET_ACCOUNTS,
            permissionName = "获取账户"
    ),
    ACCESS_NETWORK_STATE(
            permissionType = Manifest.permission.ACCESS_NETWORK_STATE,
            permissionName = "获取网络状态"
    ),
    ACCESS_WIFI_STATE(
            permissionType = Manifest.permission.ACCESS_WIFI_STATE,
            permissionName = "获取wifi状态"
    ),
    CHANGE_WIFI_STATE(
            permissionType = Manifest.permission.CHANGE_WIFI_STATE,
            permissionName = "改变wifi状态"
    ),
    CHANGE_NETWORK_STATE(
            permissionType = Manifest.permission.CHANGE_NETWORK_STATE,
            permissionName = "改变网络状态"
    ),
    BLUETOOTH(
            permissionType = Manifest.permission.BLUETOOTH,
            permissionName = "蓝牙"
    ),
    BLUETOOTH_ADMIN(
            permissionType = Manifest.permission.BLUETOOTH_ADMIN,
            permissionName = "蓝牙管理"
    ),
    INTERNET(
            permissionType = Manifest.permission.INTERNET,
            permissionName = "互联网"
    ),
    NFC(
            permissionType = Manifest.permission.NFC,
            permissionName = "NFC"
    ),
    VIBRATE(
            permissionType = Manifest.permission.VIBRATE,
            permissionName = "振动"
    ),
    READ_CALENDAR(
            Manifest.permission.READ_CALENDAR,
            "读取日历"
    ),
    WRITE_CALENDAR(
            permissionType = Manifest.permission.WRITE_CALENDAR,
            permissionName = "写入日历"
    ),
    READ_CALL_LOG(
            permissionType = Manifest.permission.READ_CALL_LOG,
            permissionName = "读取通话记录"
    ),
    WRITE_CALL_LOG(
            permissionType = Manifest.permission.WRITE_CALL_LOG,
            permissionName = "写入通话记录"
    ),
    USE_SIP(
            permissionType = Manifest.permission.USE_SIP,
            permissionName = "使用SIP"
    ),
    PROCESS_OUTGOING_CALLS(
            permissionType = Manifest.permission.PROCESS_OUTGOING_CALLS,
            permissionName = "处理外呼"
    ),
    BODY_SENSORS(
            permissionType = Manifest.permission.BODY_SENSORS,
            permissionName = "身体传感器"
    ),
    SEND_SMS(
            permissionType = Manifest.permission.SEND_SMS,
            permissionName = "发送短信"
    ),
    RECEIVE_SMS(
            permissionType = Manifest.permission.RECEIVE_SMS,
            permissionName = "接收短信"
    ),
    READ_SMS(
            permissionType = Manifest.permission.READ_SMS,
            permissionName = "读取短信"
    ),
    RECEIVE_WAP_PUSH(
            permissionType = Manifest.permission.RECEIVE_WAP_PUSH,
            permissionName = "接收WAP推送"
    ),
    RECEIVE_MMS(
            permissionType = Manifest.permission.RECEIVE_MMS,
            permissionName = "接收彩信"
    )

}