package com.liecoder.framework.service

import android.app.Activity
import com.liecoder.framework.model.AppStatus

/**
 * 应用程序状态服务接口，用于监听和响应应用程序状态的变化。
 *
 * 实现此接口的类将能够接收到应用程序状态变化的通知，例如从后台变为前台或从前台变为后台。
 * 这可以用于执行状态变化相关的逻辑，如更新用户界面、管理资源或处理后台任务。
 */
interface IAppStatusService {

    /**
     * 应用程序状态变化时的回调方法。
     *
     * 当应用程序的状态发生变化时，如从前台变为后台或相反，此方法将被调用。实现此接口的类可以在此方法中执行状态变化时需要进行的任何操作。
     *
     * @param appStatus 应用程序的新状态，可以是 [AppStatus.Background] 或 [AppStatus.Foreground]。
     * @param activity 触发状态变化的 Activity 实例。如果状态变化与特定的 Activity 相关，此参数将提供该 Activity 的引用。
     */
    fun onAppStatusChanged(appStatus: AppStatus, activity: Activity)
}