/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.net.InetSocketAddress;
import java.util.HashMap;

public class StorageAddressMap {
    protected boolean without_port;
    protected HashMap<String, InetSocketAddress> storages;

    public StorageAddressMap(boolean without_port) {
        this.without_port = without_port;
        this.storages = new HashMap();
    }

    protected String getKey(String ipAddr, int port) {
        return ipAddr + "@" + port;
    }

    public void puts(String srcIpAddr, String destIpAddr, int port) {
        this.storages.put(this.getKey(srcIpAddr, port), new InetSocketAddress(destIpAddr, port));
        this.storages.put(this.getKey(destIpAddr, port), new InetSocketAddress(srcIpAddr, port));
    }

    public void puts(String srcIpAddr, String destIpAddr) {
        this.storages.put(srcIpAddr, new InetSocketAddress(destIpAddr, 0));
        this.storages.put(destIpAddr, new InetSocketAddress(srcIpAddr, 0));
    }

    public InetSocketAddress get(String ipAddr, int port) {
        if (this.without_port) {
            InetSocketAddress sockAddr = this.storages.get(ipAddr);
            if (sockAddr == null) {
                return null;
            }
            return new InetSocketAddress(sockAddr.getAddress(), port);
        }
        return this.storages.get(this.getKey(ipAddr, port));
    }

    public InetSocketAddress get(InetSocketAddress sockAddr) {
        return this.get(sockAddr.getAddress().getHostAddress(), sockAddr.getPort());
    }
}

