/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import org.csource.common.MyException;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdfs.pool.Connection;

public class StorageServer
extends TrackerServer {
    protected int store_path_index = 0;
    protected static Hashtable<String, InetSocketAddress> sockAddressCache = new Hashtable();

    public StorageServer(String ip_addr, int port, int store_path) throws IOException {
        super(new InetSocketAddress(ip_addr, port));
        this.store_path_index = store_path;
    }

    public StorageServer(String ip_addr, int port, byte store_path) throws IOException {
        super(new InetSocketAddress(ip_addr, port));
        this.store_path_index = store_path < 0 ? 256 + store_path : (int)store_path;
    }

    public int getStorePathIndex() {
        return this.store_path_index;
    }

    @Override
    public Connection getConnection() throws MyException, IOException {
        MyException myException = null;
        IOException ioException = null;
        if (!ClientGlobal.g_multi_storage_ips) {
            return super.getConnection();
        }
        if (ClientGlobal.g_connect_first_by == 0) {
            try {
                Connection connection = super.getConnection();
                if (connection != null) {
                    return connection;
                }
            }
            catch (MyException ex1) {
                myException = ex1;
            }
            catch (IOException ex2) {
                ioException = ex2;
            }
            InetSocketAddress sockAddr = ClientGlobal.g_storages_address_map.get(this.inetSockAddr);
            if (sockAddr != null) {
                return super.getConnection(sockAddr);
            }
            if (myException != null) {
                throw myException;
            }
            if (ioException != null) {
                throw ioException;
            }
        } else {
            Connection connection;
            String key = this.inetSockAddr.getAddress().getHostAddress() + "@" + this.inetSockAddr.getPort();
            InetSocketAddress sockAddr = sockAddressCache.get(key);
            try {
                if (sockAddr == null) {
                    sockAddr = this.inetSockAddr;
                    connection = super.getConnection(sockAddr);
                    if (connection != null) {
                        sockAddressCache.put(key, sockAddr);
                        return connection;
                    }
                } else {
                    connection = super.getConnection(sockAddr);
                    if (connection != null) {
                        return connection;
                    }
                }
            }
            catch (MyException ex1) {
                myException = ex1;
            }
            catch (IOException ex2) {
                ioException = ex2;
            }
            sockAddr = ClientGlobal.g_storages_address_map.get(sockAddr);
            if (sockAddr == null) {
                if (myException != null) {
                    throw myException;
                }
                if (ioException != null) {
                    throw ioException;
                }
                return null;
            }
            connection = super.getConnection(sockAddr);
            if (connection != null) {
                sockAddressCache.put(key, sockAddr);
                return connection;
            }
        }
        return null;
    }
}

