/*
 * Decompiled with CFR 0.152.
 */
package io.github.magicpluginteam.gui;

import io.github.magicpluginteam.gui.GuiFrame;
import io.github.magicpluginteam.gui.GuiList;
import io.github.magicpluginteam.gui.GuiRegion;
import io.github.magicpluginteam.gui.GuiSlot;
import io.github.magicpluginteam.gui.GuiWindow;
import io.github.magicpluginteam.gui.utils.Function2;
import io.github.magicpluginteam.gui.utils.Function3;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class GuiFrameImpl
implements GuiWindow,
GuiFrame {
    private final ArrayList<GuiRegion> slots = new ArrayList();
    private final Inventory inv;
    public Consumer<InventoryOpenEvent> onOpen;
    public Consumer<InventoryCloseEvent> onClose;
    public Function3<Integer, Integer, InventoryClickEvent> onClick;
    public Consumer<InventoryClickEvent> onClickBottom;
    public Consumer<InventoryClickEvent> onClickOutside;

    public Inventory getInventory() {
        return this.inv;
    }

    public GuiFrameImpl(int lines, String title) {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(lines * 9), (String)title);
    }

    private void assertItemSlot(int x, int y) {
        int lines = this.inv.getSize() / 9;
        if (0 > x || x >= 9 || 0 > y || y >= lines) {
            throw new AssertionError((Object)("require 0 <= x <= 8 0 <= y < " + lines));
        }
    }

    @Override
    public void openInventory(Player player) {
        player.openInventory(this.getInventory());
    }

    @Override
    public void slot(int x, int y, Consumer<InventoryClickEvent> onClick) {
        this.assertItemSlot(x, y);
        GuiSlot guiSlot = new GuiSlot(x, y, onClick);
        this.slots.add(guiSlot);
    }

    @Override
    public void slot(int x, int y, ItemStack itemStack, Consumer<InventoryClickEvent> onClick) {
        this.assertItemSlot(x, y);
        GuiSlot guiSlot = new GuiSlot(x, y, onClick);
        this.item(x, y, itemStack);
        this.slots.add(guiSlot);
    }

    @Override
    public <T> void list(int x, int y, int width, int height, Supplier<List<T>> items, Function<T, ItemStack> transform, Function2<GuiList<T>, GuiFrame> init) {
        GuiList<T> guiList = new GuiList<T>(x, y, width, height, items, transform, this);
        init.invoke(guiList, this);
        this.slots.add(guiList);
        guiList.update();
    }

    @Override
    public void item(int x, int y, ItemStack itemStack) {
        this.assertItemSlot(x, y);
        this.inv.setItem(x + y * 9, itemStack);
    }

    @Override
    public ItemStack item(int x, int y) {
        this.assertItemSlot(x, y);
        return this.inv.getItem(x + y * 9);
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        if (this.onOpen == null) {
            return;
        }
        this.onOpen.accept(event);
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        if (this.onClose == null) {
            return;
        }
        this.onClose.accept(event);
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        event.setCancelled(true);
        int slot = event.getSlot();
        int x = slot % 9;
        int y = slot / 9;
        if (this.onClick != null) {
            this.onClick.invoke(x, y, event);
        }
        this.slots.stream().filter(s -> s.x == x && s.y == y).forEach(s -> s.onClick(x, y, event));
    }

    @Override
    public void onClickBottom(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.onClickBottom == null) {
            return;
        }
        this.onClickBottom.accept(event);
    }

    @Override
    public void onClickOutside(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.onClickOutside == null) {
            return;
        }
        this.onClickOutside.accept(event);
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void onPickupItem(EntityPickupItemEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void onDropItem(PlayerDropItemEvent event) {
        event.setCancelled(true);
    }
}

