/*
 * Decompiled with CFR 0.152.
 */
package io.github.magicpluginteam.gui;

import io.github.magicpluginteam.gui.GuiRegion;
import io.github.magicpluginteam.gui.GuiWindow;
import io.github.magicpluginteam.gui.utils.Function4;
import io.github.magicpluginteam.gui.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GuiList<T>
extends GuiRegion {
    private final GuiWindow guiWindow;
    public int width;
    public int height;
    private int index = 0;
    private final Supplier<List<T>> items;
    private final Function<T, ItemStack> transform;
    public Function4<Integer, Integer, Pair<ItemStack, T>, InventoryClickEvent> onClick;
    public List<Pair<ItemStack, T>> display;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int input) {
        this.index = input;
        this.update();
    }

    public void update() {
        List<T> list = this.items.get();
        this.display = new ArrayList<Pair<ItemStack, T>>();
        int size = list.size();
        AtomicInteger index = new AtomicInteger(this.index);
        IntStream.range(this.y, this.y + this.height).forEach(y -> IntStream.range(this.x, this.x + this.width).forEach(x -> {
            int i = x + y * 9;
            ItemStack item = null;
            int ind = index.getAndAdd(1);
            ind = ind < 0 ? size - Math.abs(ind) % size : (ind %= size);
            if (ind < (x * y < size ? size : size + this.index)) {
                Object context = list.get(ind % size);
                item = this.transform.apply(context);
                this.display.add(new Pair(item, context));
            }
            this.guiWindow.getInventory().setItem(i, item);
        }));
    }

    public GuiList(int x, int y, int width, int height, Supplier<List<T>> items, Function<T, ItemStack> transform, GuiWindow guiWindow) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.items = items;
        this.transform = transform;
        this.guiWindow = guiWindow;
    }

    @Override
    public void onClick(int x, int y, InventoryClickEvent event) {
        this.onClick.invoke(x, y, this.display.get(x + y * 9), event);
        this.update();
    }

    public void onClick(Function4<Integer, Integer, Pair<ItemStack, T>, InventoryClickEvent> onClick) {
        this.onClick = onClick;
    }
}

