/*
 * Decompiled with CFR 0.152.
 */
package io.github.magicpluginteam.gui;

import io.github.magicpluginteam.gui.GuiWindow;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class GuiSupport
implements Listener {
    private static final HashMap<Plugin, GuiSupport> guiSupportMap = new HashMap();

    public static void addSupport(Plugin plugin) {
        if (!plugin.isEnabled()) {
            throw new AssertionError((Object)"plugin is not enabled");
        }
        GuiSupport guiSupport = new GuiSupport();
        plugin.getServer().getPluginManager().registerEvents((Listener)guiSupport, plugin);
        guiSupportMap.put(plugin, guiSupport);
    }

    @EventHandler
    private void onPluginDisable(PluginDisableEvent event) {
        Plugin plugin = event.getPlugin();
        if (guiSupportMap.remove(plugin) != this) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.getOpenInventory().getTopInventory().getHolder() instanceof GuiWindow) {
                player.closeInventory();
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onOpen(InventoryOpenEvent event) {
        GuiWindow window = this.window(event.getInventory());
        if (window == null) {
            return;
        }
        window.onOpen(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClose(InventoryCloseEvent event) {
        GuiWindow window = this.window(event.getInventory());
        if (window == null) {
            return;
        }
        window.onClose(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        GuiWindow window = this.window(inventory);
        if (window == null) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0) {
            window.onClickOutside(event);
        } else if (slot < inventory.getSize()) {
            window.onClick(event);
        } else {
            window.onClickBottom(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrag(InventoryDragEvent event) {
        GuiWindow window = this.window(event.getInventory());
        if (window == null) {
            return;
        }
        window.onDrag(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPickup(EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        GuiWindow window = this.window(player.getOpenInventory().getTopInventory());
        if (window == null) {
            return;
        }
        window.onPickupItem(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        GuiWindow window = this.window(player.getOpenInventory().getTopInventory());
        if (window == null) {
            return;
        }
        window.onDropItem(event);
    }

    public GuiWindow window(Inventory inventory) {
        GuiWindow window;
        InventoryHolder inventoryHolder = inventory.getHolder();
        return inventoryHolder instanceof GuiWindow ? (window = (GuiWindow)inventoryHolder) : null;
    }
}

