/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AlpacaRequestBuilder {
    private static final String VERSION = "v1";
    public static final String URL_SEPARATOR = "/";
    public final Map<String, String> urlParameters = new LinkedHashMap<String, String>();
    public final Map<String, String> bodyProperties = new LinkedHashMap<String, String>();
    private String baseUrl;
    private List<String> appendedEndpoints = new ArrayList<String>();
    private boolean defaultEndpoint = true;

    public AlpacaRequestBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void appendURLParameter(String parameterKey, String parameterValue) {
        this.urlParameters.put(parameterKey, parameterValue);
    }

    public void appendBodyProperty(String parameterKey, String parameterValue) {
        this.bodyProperties.put(parameterKey, parameterValue);
    }

    public boolean isDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(boolean defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public String getBodyAsJSON() {
        JsonObject jsonBody = new JsonObject();
        for (Map.Entry<String, String> entry : this.bodyProperties.entrySet()) {
            jsonBody.addProperty(entry.getKey(), entry.getValue());
        }
        return jsonBody.toString();
    }

    public void appendEndpoint(String endpoint) {
        this.appendedEndpoints.add(endpoint);
    }

    public abstract String getEndpoint();

    public String getURL() {
        StringBuilder builder = new StringBuilder(this.baseUrl);
        builder.append(URL_SEPARATOR);
        builder.append(VERSION);
        if (this.defaultEndpoint) {
            builder.append(URL_SEPARATOR);
            builder.append(this.getEndpoint());
        }
        for (String string : this.appendedEndpoints) {
            builder.append(URL_SEPARATOR);
            builder.append(string);
        }
        if (!this.urlParameters.isEmpty()) {
            builder.append('?');
            for (Map.Entry entry : this.urlParameters.entrySet()) {
                builder.append(((String)entry.getKey()).trim());
                builder.append('=');
                builder.append(((String)entry.getValue()).trim());
                builder.append('&');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

