/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca;

import com.google.gson.reflect.TypeToken;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import io.github.mainstringargs.alpaca.domain.Account;
import io.github.mainstringargs.alpaca.domain.Asset;
import io.github.mainstringargs.alpaca.domain.Bar;
import io.github.mainstringargs.alpaca.domain.Calendar;
import io.github.mainstringargs.alpaca.domain.Clock;
import io.github.mainstringargs.alpaca.domain.Order;
import io.github.mainstringargs.alpaca.domain.Position;
import io.github.mainstringargs.alpaca.enums.AssetStatus;
import io.github.mainstringargs.alpaca.enums.BarsTimeFrame;
import io.github.mainstringargs.alpaca.enums.Direction;
import io.github.mainstringargs.alpaca.enums.OrderSide;
import io.github.mainstringargs.alpaca.enums.OrderStatus;
import io.github.mainstringargs.alpaca.enums.OrderTimeInForce;
import io.github.mainstringargs.alpaca.enums.OrderType;
import io.github.mainstringargs.alpaca.properties.AlpacaProperties;
import io.github.mainstringargs.alpaca.rest.AlpacaRequest;
import io.github.mainstringargs.alpaca.rest.accounts.GetAccountRequestBuilder;
import io.github.mainstringargs.alpaca.rest.assets.GetAssetBySymbolRequestBuilder;
import io.github.mainstringargs.alpaca.rest.assets.GetAssetsRequestBuilder;
import io.github.mainstringargs.alpaca.rest.bars.GetBarsRequestBuilder;
import io.github.mainstringargs.alpaca.rest.calendar.GetCalendarRequestBuilder;
import io.github.mainstringargs.alpaca.rest.clock.GetClockRequestBuilder;
import io.github.mainstringargs.alpaca.rest.exceptions.AlpacaAPIException;
import io.github.mainstringargs.alpaca.rest.orders.DeleteOrderRequestBuilder;
import io.github.mainstringargs.alpaca.rest.orders.GetListOfOrdersRequestBuilder;
import io.github.mainstringargs.alpaca.rest.orders.GetOrderByClientIdRequestBuilder;
import io.github.mainstringargs.alpaca.rest.orders.GetOrderRequestBuilder;
import io.github.mainstringargs.alpaca.rest.orders.PostOrderRequestBuilder;
import io.github.mainstringargs.alpaca.rest.positions.GetOpenPositionBySymbolRequestBuilder;
import io.github.mainstringargs.alpaca.rest.positions.GetOpenPositionsRequestBuilder;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaAPI {
    private String keyId;
    private String secret;
    private String baseAccountUrl;
    private AlpacaRequest alpacaRequest;
    private String baseDataUrl;
    private static Logger LOGGER = LogManager.getLogger(AlpacaAPI.class);

    public AlpacaAPI() {
        this.keyId = AlpacaProperties.KEY_ID_VALUE;
        this.secret = AlpacaProperties.SECRET_VALUE;
        this.baseAccountUrl = AlpacaProperties.BASE_ACCOUNT_URL_VALUE;
        this.baseDataUrl = AlpacaProperties.BASE_DATA_URL_VALUE;
        LOGGER.info("AlpacaAPI is using the following properties: \nkeyId: " + this.keyId + "\nsecret: " + this.secret + "\nbaseAccountUrl: " + this.baseAccountUrl + "\nbaseDataUrl: " + this.baseDataUrl);
        this.alpacaRequest = new AlpacaRequest(this.keyId, this.secret);
    }

    public AlpacaAPI(String keyId, String secret, String baseAccountUrl, String baseDataUrl) {
        this.keyId = keyId;
        this.secret = secret;
        this.baseAccountUrl = baseAccountUrl;
        this.baseDataUrl = baseDataUrl;
        LOGGER.info("AlpacaAPI is using the following properties: \nkeyId: " + keyId + "\nsecret: " + secret + "\nbaseAccountUrl: " + baseAccountUrl + "\nbaseDataUrl: " + baseDataUrl);
        this.alpacaRequest = new AlpacaRequest(keyId, secret);
    }

    public AlpacaAPI(String keyId, String secret, String baseAccountUrl) {
        this.keyId = keyId;
        this.secret = secret;
        this.baseAccountUrl = baseAccountUrl;
        this.baseDataUrl = AlpacaProperties.BASE_DATA_URL_VALUE;
        LOGGER.info("AlpacaAPI is using the following properties: \nkeyId: " + keyId + "\nsecret: " + secret + "\nbaseAccountUrl: " + baseAccountUrl + "\nbaseDataUrl: " + this.baseDataUrl);
        this.alpacaRequest = new AlpacaRequest(keyId, secret);
    }

    public Account getAccount() throws AlpacaAPIException {
        GetAccountRequestBuilder urlBuilder = new GetAccountRequestBuilder(this.baseAccountUrl);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Account account = (Account)this.alpacaRequest.getResponseObject(response, (Type)((Object)Account.class));
        return account;
    }

    public List<Order> getOrders() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Order>>(){}.getType();
        GetListOfOrdersRequestBuilder urlBuilder = new GetListOfOrdersRequestBuilder(this.baseAccountUrl);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List orders = (List)this.alpacaRequest.getResponseObject(response, listType);
        return orders;
    }

    public List<Order> getOrders(OrderStatus status, Integer limit, LocalDateTime after, LocalDateTime until, Direction direction) throws AlpacaAPIException {
        Type listType = new TypeToken<List<Order>>(){}.getType();
        GetListOfOrdersRequestBuilder urlBuilder = new GetListOfOrdersRequestBuilder(this.baseAccountUrl);
        urlBuilder.status(status).limit(limit).after(after).until(until).direction(direction);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List orders = (List)this.alpacaRequest.getResponseObject(response, listType);
        return orders;
    }

    public Order requestNewOrder(String symbol, Integer quantity, OrderSide side, OrderType type, OrderTimeInForce timeInForce, Double limitPrice, Double stopPrice, String clientOrderId) throws AlpacaAPIException {
        Type objectType = new TypeToken<Order>(){}.getType();
        PostOrderRequestBuilder urlBuilder = new PostOrderRequestBuilder(this.baseAccountUrl);
        urlBuilder.symbol(symbol).quantity(quantity).side(side).type(type).timeInForce(timeInForce).limitPrice(limitPrice).stopPrice(stopPrice).clientOrderId(clientOrderId);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokePost(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Order order = (Order)this.alpacaRequest.getResponseObject(response, objectType);
        return order;
    }

    public Order getOrder(String orderId) throws AlpacaAPIException {
        Type objectType = new TypeToken<Order>(){}.getType();
        GetOrderRequestBuilder urlBuilder = new GetOrderRequestBuilder(this.baseAccountUrl);
        urlBuilder.orderId(orderId);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Order order = (Order)this.alpacaRequest.getResponseObject(response, objectType);
        return order;
    }

    public Order getOrderByClientId(String clientOrderId) throws AlpacaAPIException {
        Type objectType = new TypeToken<Order>(){}.getType();
        GetOrderByClientIdRequestBuilder urlBuilder = new GetOrderByClientIdRequestBuilder(this.baseAccountUrl);
        urlBuilder.ordersByClientOrderId(clientOrderId);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Order order = (Order)this.alpacaRequest.getResponseObject(response, objectType);
        return order;
    }

    public boolean cancelOrder(String orderId) throws AlpacaAPIException {
        DeleteOrderRequestBuilder urlBuilder = new DeleteOrderRequestBuilder(this.baseAccountUrl);
        urlBuilder.orderId(orderId);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            throw new AlpacaAPIException(response);
        }
        return response.getStatus() == 200 || response.getStatus() == 204;
    }

    public List<Position> getOpenPositions() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Position>>(){}.getType();
        GetOpenPositionsRequestBuilder urlBuilder = new GetOpenPositionsRequestBuilder(this.baseAccountUrl);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List positions = (List)this.alpacaRequest.getResponseObject(response, listType);
        return positions;
    }

    public Position getOpenPositionBySymbol(String symbol) throws AlpacaAPIException {
        Type listType = new TypeToken<Position>(){}.getType();
        GetOpenPositionBySymbolRequestBuilder urlBuilder = new GetOpenPositionBySymbolRequestBuilder(this.baseAccountUrl);
        urlBuilder.symbol(symbol);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Position position = (Position)this.alpacaRequest.getResponseObject(response, listType);
        return position;
    }

    public List<Asset> getAssets() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Asset>>(){}.getType();
        GetAssetsRequestBuilder urlBuilder = new GetAssetsRequestBuilder(this.baseAccountUrl);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List assets = (List)this.alpacaRequest.getResponseObject(response, listType);
        return assets;
    }

    public List<Asset> getAssets(AssetStatus assetStatus, String assetClass) throws AlpacaAPIException {
        Type listType = new TypeToken<List<Asset>>(){}.getType();
        GetAssetsRequestBuilder urlBuilder = new GetAssetsRequestBuilder(this.baseAccountUrl);
        urlBuilder.status(assetStatus).assetClass(assetClass);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List assets = (List)this.alpacaRequest.getResponseObject(response, listType);
        return assets;
    }

    public Asset getAssetBySymbol(String symbol) throws AlpacaAPIException {
        Type listType = new TypeToken<Asset>(){}.getType();
        GetAssetBySymbolRequestBuilder urlBuilder = new GetAssetBySymbolRequestBuilder(this.baseAccountUrl);
        urlBuilder.symbol(symbol);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Asset asset = (Asset)this.alpacaRequest.getResponseObject(response, listType);
        return asset;
    }

    public List<Calendar> getCalendar() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Calendar>>(){}.getType();
        GetCalendarRequestBuilder urlBuilder = new GetCalendarRequestBuilder(this.baseAccountUrl);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List calendar = (List)this.alpacaRequest.getResponseObject(response, listType);
        return calendar;
    }

    public List<Calendar> getCalendar(LocalDate start, LocalDate end) throws AlpacaAPIException {
        Type listType = new TypeToken<List<Calendar>>(){}.getType();
        GetCalendarRequestBuilder urlBuilder = new GetCalendarRequestBuilder(this.baseAccountUrl);
        urlBuilder.start(start).end(end);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List calendar = (List)this.alpacaRequest.getResponseObject(response, listType);
        return calendar;
    }

    public Clock getClock() throws AlpacaAPIException {
        GetClockRequestBuilder urlBuilder = new GetClockRequestBuilder(this.baseAccountUrl);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Clock clock = (Clock)this.alpacaRequest.getResponseObject(response, (Type)((Object)Clock.class));
        return clock;
    }

    public Map<String, List<Bar>> getBars(BarsTimeFrame timeframe, String[] symbols, Integer limit, LocalDateTime start, LocalDateTime end, LocalDateTime after, LocalDateTime until) throws AlpacaAPIException {
        GetBarsRequestBuilder urlBuilder = new GetBarsRequestBuilder(this.baseDataUrl);
        urlBuilder.timeframe(timeframe).symbols(symbols).limit(limit).start(start).end(end).after(after).until(until);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Type mapType = new TypeToken<Map<String, List<Bar>>>(){}.getType();
        Map bars = (Map)this.alpacaRequest.getResponseObject(response, mapType);
        return bars;
    }

    public List<Bar> getBars(BarsTimeFrame timeframe, String symbol, Integer limit, LocalDateTime start, LocalDateTime end, LocalDateTime after, LocalDateTime until) throws AlpacaAPIException {
        GetBarsRequestBuilder urlBuilder = new GetBarsRequestBuilder(this.baseDataUrl);
        urlBuilder.timeframe(timeframe).symbols(symbol).limit(limit).start(start).end(end).after(after).until(until);
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Type mapType = new TypeToken<Map<String, List<Bar>>>(){}.getType();
        Map bars = (Map)this.alpacaRequest.getResponseObject(response, mapType);
        return (List)bars.get(symbol);
    }
}

