/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca;

import io.github.mainstringargs.alpaca.AlpacaAPI;
import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.domain.Account;
import io.github.mainstringargs.alpaca.domain.Bar;
import io.github.mainstringargs.alpaca.domain.Clock;
import io.github.mainstringargs.alpaca.domain.Order;
import io.github.mainstringargs.alpaca.enums.BarsTimeFrame;
import io.github.mainstringargs.alpaca.enums.OrderSide;
import io.github.mainstringargs.alpaca.enums.OrderTimeInForce;
import io.github.mainstringargs.alpaca.enums.OrderType;
import io.github.mainstringargs.alpaca.rest.exceptions.AlpacaAPIException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.UUID;

public class Example {
    public static void main(String[] args) {
        AlpacaAPI alpacaApi = new AlpacaAPI();
        try {
            Account alpacaAccount = alpacaApi.getAccount();
            System.out.println("\n\nAccount Information:");
            System.out.println("\tCreated At: " + Utilities.fromDateTimeString(alpacaAccount.getCreatedAt()) + "\n\tBuying Power: " + alpacaAccount.getBuyingPower() + "\n\tPortfolio Value: " + alpacaAccount.getPortfolioValue());
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        try {
            Clock alpacaClock = alpacaApi.getClock();
            System.out.println("\n\nClock:");
            System.out.println("\tCurrent Time: " + Utilities.fromDateTimeString(alpacaClock.getTimestamp()) + "\n\tIs Open: " + alpacaClock.isIsOpen() + "\n\tMarket Next Open Time: " + Utilities.fromDateTimeString(alpacaClock.getNextOpen()) + "\n\tMark Next Close Time: " + Utilities.fromDateTimeString(alpacaClock.getNextClose()));
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        Order limitOrder = null;
        String orderClientId = UUID.randomUUID().toString();
        try {
            limitOrder = alpacaApi.requestNewOrder("AMZN", 1, OrderSide.BUY, OrderType.LIMIT, OrderTimeInForce.DAY, 100.0, null, orderClientId);
            System.out.println("\n\nLimit Order Response:");
            System.out.println("\tSymbol: " + limitOrder.getSymbol() + "\n\tClient Order Id: " + limitOrder.getClientOrderId() + "\n\tQty: " + limitOrder.getQty() + "\n\tType: " + limitOrder.getType() + "\n\tLimit Price: $" + limitOrder.getLimitPrice() + "\n\tCreated At: " + Utilities.fromDateTimeString(limitOrder.getCreatedAt()));
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        try {
            Order limitOrderById = alpacaApi.getOrder(limitOrder.getId());
            System.out.println("\n\nLimit Order By Id Response:");
            System.out.println("\tSymbol: " + limitOrderById.getSymbol() + "\n\tClient Order Id: " + limitOrderById.getClientOrderId() + "\n\tQty: " + limitOrderById.getQty() + "\n\tType: " + limitOrderById.getType() + "\n\tLimit Price: $" + limitOrderById.getLimitPrice() + "\n\tCreated At: " + Utilities.fromDateTimeString(limitOrderById.getCreatedAt()));
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        try {
            Order limitOrderByClientId = alpacaApi.getOrderByClientId(limitOrder.getClientOrderId());
            System.out.println("\n\nLimit Order By Id Response:");
            System.out.println("\tSymbol: " + limitOrderByClientId.getSymbol() + "\n\tClient Order Id: " + limitOrderByClientId.getClientOrderId() + "\n\tQty: " + limitOrderByClientId.getQty() + "\n\tType: " + limitOrderByClientId.getType() + "\n\tLimit Price: $" + limitOrderByClientId.getLimitPrice() + "\n\tCreated At: " + Utilities.fromDateTimeString(limitOrderByClientId.getCreatedAt()));
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        try {
            boolean orderCanceled = alpacaApi.cancelOrder(limitOrder.getId());
            System.out.println("\n\nCancel order response:");
            System.out.println("\tCancelled: " + orderCanceled);
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        try {
            List<Bar> bars = alpacaApi.getBars(BarsTimeFrame.ONE_DAY, "AMZN", (Integer)10, LocalDateTime.of(2019, 2, 13, 10, 30), LocalDateTime.of(2019, 2, 14, 10, 30), null, null);
            System.out.println("\n\nBars response:");
            for (Bar bar : bars) {
                System.out.println("\t==========");
                System.out.println("\tUnix Time " + LocalDateTime.ofInstant(Instant.ofEpochMilli(bar.getT() * 1000L), ZoneId.of("UTC")));
                System.out.println("\tOpen: $" + bar.getO());
                System.out.println("\tHigh: $" + bar.getH());
                System.out.println("\tLow: $" + bar.getL());
                System.out.println("\tClose: $" + bar.getC());
                System.out.println("\tVolume: " + bar.getV());
            }
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
    }
}

