
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Account implements Serializable
{

    @SerializedName("id")
    @Expose
    private String id;
    @SerializedName("status")
    @Expose
    private String status;
    @SerializedName("currency")
    @Expose
    private String currency;
    @SerializedName("buying_power")
    @Expose
    private String buyingPower;
    @SerializedName("cash")
    @Expose
    private String cash;
    @SerializedName("cash_withdrawable")
    @Expose
    private String cashWithdrawable;
    @SerializedName("portfolio_value")
    @Expose
    private String portfolioValue;
    @SerializedName("pattern_day_trader")
    @Expose
    private boolean patternDayTrader;
    @SerializedName("trading_blocked")
    @Expose
    private boolean tradingBlocked;
    @SerializedName("transfers_blocked")
    @Expose
    private boolean transfersBlocked;
    @SerializedName("account_blocked")
    @Expose
    private boolean accountBlocked;
    @SerializedName("created_at")
    @Expose
    private String createdAt;
    private final static long serialVersionUID = -3939859111852885921L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Account() {
    }

    /**
     * 
     * @param patternDayTrader
     * @param createdAt
     * @param cashWithdrawable
     * @param buyingPower
     * @param tradingBlocked
     * @param transfersBlocked
     * @param currency
     * @param id
     * @param accountBlocked
     * @param cash
     * @param portfolioValue
     * @param status
     */
    public Account(String id, String status, String currency, String buyingPower, String cash, String cashWithdrawable, String portfolioValue, boolean patternDayTrader, boolean tradingBlocked, boolean transfersBlocked, boolean accountBlocked, String createdAt) {
        super();
        this.id = id;
        this.status = status;
        this.currency = currency;
        this.buyingPower = buyingPower;
        this.cash = cash;
        this.cashWithdrawable = cashWithdrawable;
        this.portfolioValue = portfolioValue;
        this.patternDayTrader = patternDayTrader;
        this.tradingBlocked = tradingBlocked;
        this.transfersBlocked = transfersBlocked;
        this.accountBlocked = accountBlocked;
        this.createdAt = createdAt;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getBuyingPower() {
        return buyingPower;
    }

    public void setBuyingPower(String buyingPower) {
        this.buyingPower = buyingPower;
    }

    public String getCash() {
        return cash;
    }

    public void setCash(String cash) {
        this.cash = cash;
    }

    public String getCashWithdrawable() {
        return cashWithdrawable;
    }

    public void setCashWithdrawable(String cashWithdrawable) {
        this.cashWithdrawable = cashWithdrawable;
    }

    public String getPortfolioValue() {
        return portfolioValue;
    }

    public void setPortfolioValue(String portfolioValue) {
        this.portfolioValue = portfolioValue;
    }

    public boolean isPatternDayTrader() {
        return patternDayTrader;
    }

    public void setPatternDayTrader(boolean patternDayTrader) {
        this.patternDayTrader = patternDayTrader;
    }

    public boolean isTradingBlocked() {
        return tradingBlocked;
    }

    public void setTradingBlocked(boolean tradingBlocked) {
        this.tradingBlocked = tradingBlocked;
    }

    public boolean isTransfersBlocked() {
        return transfersBlocked;
    }

    public void setTransfersBlocked(boolean transfersBlocked) {
        this.transfersBlocked = transfersBlocked;
    }

    public boolean isAccountBlocked() {
        return accountBlocked;
    }

    public void setAccountBlocked(boolean accountBlocked) {
        this.accountBlocked = accountBlocked;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("status", status).append("currency", currency).append("buyingPower", buyingPower).append("cash", cash).append("cashWithdrawable", cashWithdrawable).append("portfolioValue", portfolioValue).append("patternDayTrader", patternDayTrader).append("tradingBlocked", tradingBlocked).append("transfersBlocked", transfersBlocked).append("accountBlocked", accountBlocked).append("createdAt", createdAt).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(tradingBlocked).append(portfolioValue).append(patternDayTrader).append(createdAt).append(cashWithdrawable).append(buyingPower).append(transfersBlocked).append(currency).append(id).append(accountBlocked).append(cash).append(status).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Account) == false) {
            return false;
        }
        Account rhs = ((Account) other);
        return new EqualsBuilder().append(tradingBlocked, rhs.tradingBlocked).append(portfolioValue, rhs.portfolioValue).append(patternDayTrader, rhs.patternDayTrader).append(createdAt, rhs.createdAt).append(cashWithdrawable, rhs.cashWithdrawable).append(buyingPower, rhs.buyingPower).append(transfersBlocked, rhs.transfersBlocked).append(currency, rhs.currency).append(id, rhs.id).append(accountBlocked, rhs.accountBlocked).append(cash, rhs.cash).append(status, rhs.status).isEquals();
    }

}
