
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Asset implements Serializable
{

    @SerializedName("id")
    @Expose
    private String id;
    @SerializedName("asset_class")
    @Expose
    private String assetClass;
    @SerializedName("exchange")
    @Expose
    private String exchange;
    @SerializedName("symbol")
    @Expose
    private String symbol;
    @SerializedName("status")
    @Expose
    private String status;
    @SerializedName("tradable")
    @Expose
    private boolean tradable;
    private final static long serialVersionUID = 2301956115288843701L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Asset() {
    }

    /**
     * 
     * @param symbol
     * @param tradable
     * @param exchange
     * @param id
     * @param assetClass
     * @param status
     */
    public Asset(String id, String assetClass, String exchange, String symbol, String status, boolean tradable) {
        super();
        this.id = id;
        this.assetClass = assetClass;
        this.exchange = exchange;
        this.symbol = symbol;
        this.status = status;
        this.tradable = tradable;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAssetClass() {
        return assetClass;
    }

    public void setAssetClass(String assetClass) {
        this.assetClass = assetClass;
    }

    public String getExchange() {
        return exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isTradable() {
        return tradable;
    }

    public void setTradable(boolean tradable) {
        this.tradable = tradable;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("assetClass", assetClass).append("exchange", exchange).append("symbol", symbol).append("status", status).append("tradable", tradable).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(symbol).append(tradable).append(exchange).append(id).append(assetClass).append(status).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Asset) == false) {
            return false;
        }
        Asset rhs = ((Asset) other);
        return new EqualsBuilder().append(symbol, rhs.symbol).append(tradable, rhs.tradable).append(exchange, rhs.exchange).append(id, rhs.id).append(assetClass, rhs.assetClass).append(status, rhs.status).isEquals();
    }

}
