
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Bar implements Serializable
{

    @SerializedName("t")
    @Expose
    private long t;
    @SerializedName("o")
    @Expose
    private float o;
    @SerializedName("h")
    @Expose
    private float h;
    @SerializedName("l")
    @Expose
    private float l;
    @SerializedName("c")
    @Expose
    private float c;
    @SerializedName("v")
    @Expose
    private long v;
    private final static long serialVersionUID = -6431612489351908318L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Bar() {
    }

    /**
     * 
     * @param c
     * @param t
     * @param v
     * @param h
     * @param l
     * @param o
     */
    public Bar(long t, float o, float h, float l, float c, long v) {
        super();
        this.t = t;
        this.o = o;
        this.h = h;
        this.l = l;
        this.c = c;
        this.v = v;
    }

    public long getT() {
        return t;
    }

    public void setT(long t) {
        this.t = t;
    }

    public float getO() {
        return o;
    }

    public void setO(float o) {
        this.o = o;
    }

    public float getH() {
        return h;
    }

    public void setH(float h) {
        this.h = h;
    }

    public float getL() {
        return l;
    }

    public void setL(float l) {
        this.l = l;
    }

    public float getC() {
        return c;
    }

    public void setC(float c) {
        this.c = c;
    }

    public long getV() {
        return v;
    }

    public void setV(long v) {
        this.v = v;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("t", t).append("o", o).append("h", h).append("l", l).append("c", c).append("v", v).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(c).append(t).append(v).append(h).append(l).append(o).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Bar) == false) {
            return false;
        }
        Bar rhs = ((Bar) other);
        return new EqualsBuilder().append(c, rhs.c).append(t, rhs.t).append(v, rhs.v).append(h, rhs.h).append(l, rhs.l).append(o, rhs.o).isEquals();
    }

}
