
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Calendar implements Serializable
{

    @SerializedName("close")
    @Expose
    private String close;
    @SerializedName("date")
    @Expose
    private String date;
    @SerializedName("open")
    @Expose
    private String open;
    private final static long serialVersionUID = 6757421208495004078L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Calendar() {
    }

    /**
     * 
     * @param date
     * @param close
     * @param open
     */
    public Calendar(String close, String date, String open) {
        super();
        this.close = close;
        this.date = date;
        this.open = open;
    }

    public String getClose() {
        return close;
    }

    public void setClose(String close) {
        this.close = close;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getOpen() {
        return open;
    }

    public void setOpen(String open) {
        this.open = open;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("close", close).append("date", date).append("open", open).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(date).append(close).append(open).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Calendar) == false) {
            return false;
        }
        Calendar rhs = ((Calendar) other);
        return new EqualsBuilder().append(date, rhs.date).append(close, rhs.close).append(open, rhs.open).isEquals();
    }

}
