
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Clock implements Serializable
{

    @SerializedName("timestamp")
    @Expose
    private String timestamp;
    @SerializedName("is_open")
    @Expose
    private boolean isOpen;
    @SerializedName("next_open")
    @Expose
    private String nextOpen;
    @SerializedName("next_close")
    @Expose
    private String nextClose;
    private final static long serialVersionUID = -6807579119706498355L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Clock() {
    }

    /**
     * 
     * @param isOpen
     * @param nextOpen
     * @param nextClose
     * @param timestamp
     */
    public Clock(String timestamp, boolean isOpen, String nextOpen, String nextClose) {
        super();
        this.timestamp = timestamp;
        this.isOpen = isOpen;
        this.nextOpen = nextOpen;
        this.nextClose = nextClose;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isIsOpen() {
        return isOpen;
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public String getNextOpen() {
        return nextOpen;
    }

    public void setNextOpen(String nextOpen) {
        this.nextOpen = nextOpen;
    }

    public String getNextClose() {
        return nextClose;
    }

    public void setNextClose(String nextClose) {
        this.nextClose = nextClose;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("timestamp", timestamp).append("isOpen", isOpen).append("nextOpen", nextOpen).append("nextClose", nextClose).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(nextOpen).append(nextClose).append(isOpen).append(timestamp).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Clock) == false) {
            return false;
        }
        Clock rhs = ((Clock) other);
        return new EqualsBuilder().append(nextOpen, rhs.nextOpen).append(nextClose, rhs.nextClose).append(isOpen, rhs.isOpen).append(timestamp, rhs.timestamp).isEquals();
    }

}
