
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Data implements Serializable
{

    @SerializedName("key_id")
    @Expose
    private String keyId;
    @SerializedName("secret_key")
    @Expose
    private String secretKey;
    private final static long serialVersionUID = 3873672150862118423L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Data() {
    }

    /**
     * 
     * @param secretKey
     * @param keyId
     */
    public Data(String keyId, String secretKey) {
        super();
        this.keyId = keyId;
        this.secretKey = secretKey;
    }

    public String getKeyId() {
        return keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("keyId", keyId).append("secretKey", secretKey).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(secretKey).append(keyId).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Data) == false) {
            return false;
        }
        Data rhs = ((Data) other);
        return new EqualsBuilder().append(secretKey, rhs.secretKey).append(keyId, rhs.keyId).isEquals();
    }

}
