
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Data_ implements Serializable
{

    @SerializedName("status")
    @Expose
    private String status;
    @SerializedName("action")
    @Expose
    private String action;
    private final static long serialVersionUID = -5207018623301413791L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Data_() {
    }

    /**
     * 
     * @param action
     * @param status
     */
    public Data_(String status, String action) {
        super();
        this.status = status;
        this.action = action;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("status", status).append("action", action).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(action).append(status).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Data_) == false) {
            return false;
        }
        Data_ rhs = ((Data_) other);
        return new EqualsBuilder().append(action, rhs.action).append(status, rhs.status).isEquals();
    }

}
