
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Order implements Serializable
{

    @SerializedName("id")
    @Expose
    private String id;
    @SerializedName("client_order_id")
    @Expose
    private String clientOrderId;
    @SerializedName("created_at")
    @Expose
    private String createdAt;
    @SerializedName("updated_at")
    @Expose
    private String updatedAt;
    @SerializedName("submitted_at")
    @Expose
    private String submittedAt;
    @SerializedName("filled_at")
    @Expose
    private String filledAt;
    @SerializedName("expired_at")
    @Expose
    private String expiredAt;
    @SerializedName("canceled_at")
    @Expose
    private String canceledAt;
    @SerializedName("failed_at")
    @Expose
    private String failedAt;
    @SerializedName("asset_id")
    @Expose
    private String assetId;
    @SerializedName("symbol")
    @Expose
    private String symbol;
    @SerializedName("exchange")
    @Expose
    private String exchange;
    @SerializedName("asset_class")
    @Expose
    private String assetClass;
    @SerializedName("qty")
    @Expose
    private String qty;
    @SerializedName("filled_qty")
    @Expose
    private String filledQty;
    @SerializedName("type")
    @Expose
    private String type;
    @SerializedName("side")
    @Expose
    private String side;
    @SerializedName("time_in_force")
    @Expose
    private String timeInForce;
    @SerializedName("limit_price")
    @Expose
    private String limitPrice;
    @SerializedName("stop_price")
    @Expose
    private String stopPrice;
    @SerializedName("filled_avg_price")
    @Expose
    private String filledAvgPrice;
    @SerializedName("status")
    @Expose
    private String status;
    private final static long serialVersionUID = -1919481492364914137L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Order() {
    }

    /**
     * 
     * @param symbol
     * @param side
     * @param limitPrice
     * @param clientOrderId
     * @param filledAt
     * @param assetClass
     * @param type
     * @param filledAvgPrice
     * @param createdAt
     * @param expiredAt
     * @param failedAt
     * @param stopPrice
     * @param canceledAt
     * @param assetId
     * @param qty
     * @param exchange
     * @param id
     * @param submittedAt
     * @param filledQty
     * @param timeInForce
     * @param updatedAt
     * @param status
     */
    public Order(String id, String clientOrderId, String createdAt, String updatedAt, String submittedAt, String filledAt, String expiredAt, String canceledAt, String failedAt, String assetId, String symbol, String exchange, String assetClass, String qty, String filledQty, String type, String side, String timeInForce, String limitPrice, String stopPrice, String filledAvgPrice, String status) {
        super();
        this.id = id;
        this.clientOrderId = clientOrderId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.submittedAt = submittedAt;
        this.filledAt = filledAt;
        this.expiredAt = expiredAt;
        this.canceledAt = canceledAt;
        this.failedAt = failedAt;
        this.assetId = assetId;
        this.symbol = symbol;
        this.exchange = exchange;
        this.assetClass = assetClass;
        this.qty = qty;
        this.filledQty = filledQty;
        this.type = type;
        this.side = side;
        this.timeInForce = timeInForce;
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
        this.filledAvgPrice = filledAvgPrice;
        this.status = status;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClientOrderId() {
        return clientOrderId;
    }

    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getSubmittedAt() {
        return submittedAt;
    }

    public void setSubmittedAt(String submittedAt) {
        this.submittedAt = submittedAt;
    }

    public String getFilledAt() {
        return filledAt;
    }

    public void setFilledAt(String filledAt) {
        this.filledAt = filledAt;
    }

    public String getExpiredAt() {
        return expiredAt;
    }

    public void setExpiredAt(String expiredAt) {
        this.expiredAt = expiredAt;
    }

    public String getCanceledAt() {
        return canceledAt;
    }

    public void setCanceledAt(String canceledAt) {
        this.canceledAt = canceledAt;
    }

    public String getFailedAt() {
        return failedAt;
    }

    public void setFailedAt(String failedAt) {
        this.failedAt = failedAt;
    }

    public String getAssetId() {
        return assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getExchange() {
        return exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getAssetClass() {
        return assetClass;
    }

    public void setAssetClass(String assetClass) {
        this.assetClass = assetClass;
    }

    public String getQty() {
        return qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public String getFilledQty() {
        return filledQty;
    }

    public void setFilledQty(String filledQty) {
        this.filledQty = filledQty;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSide() {
        return side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public String getTimeInForce() {
        return timeInForce;
    }

    public void setTimeInForce(String timeInForce) {
        this.timeInForce = timeInForce;
    }

    public String getLimitPrice() {
        return limitPrice;
    }

    public void setLimitPrice(String limitPrice) {
        this.limitPrice = limitPrice;
    }

    public String getStopPrice() {
        return stopPrice;
    }

    public void setStopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
    }

    public String getFilledAvgPrice() {
        return filledAvgPrice;
    }

    public void setFilledAvgPrice(String filledAvgPrice) {
        this.filledAvgPrice = filledAvgPrice;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("clientOrderId", clientOrderId).append("createdAt", createdAt).append("updatedAt", updatedAt).append("submittedAt", submittedAt).append("filledAt", filledAt).append("expiredAt", expiredAt).append("canceledAt", canceledAt).append("failedAt", failedAt).append("assetId", assetId).append("symbol", symbol).append("exchange", exchange).append("assetClass", assetClass).append("qty", qty).append("filledQty", filledQty).append("type", type).append("side", side).append("timeInForce", timeInForce).append("limitPrice", limitPrice).append("stopPrice", stopPrice).append("filledAvgPrice", filledAvgPrice).append("status", status).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(symbol).append(side).append(limitPrice).append(clientOrderId).append(filledAt).append(assetClass).append(type).append(filledAvgPrice).append(createdAt).append(expiredAt).append(failedAt).append(stopPrice).append(canceledAt).append(assetId).append(qty).append(exchange).append(id).append(submittedAt).append(filledQty).append(timeInForce).append(updatedAt).append(status).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Order) == false) {
            return false;
        }
        Order rhs = ((Order) other);
        return new EqualsBuilder().append(symbol, rhs.symbol).append(side, rhs.side).append(limitPrice, rhs.limitPrice).append(clientOrderId, rhs.clientOrderId).append(filledAt, rhs.filledAt).append(assetClass, rhs.assetClass).append(type, rhs.type).append(filledAvgPrice, rhs.filledAvgPrice).append(createdAt, rhs.createdAt).append(expiredAt, rhs.expiredAt).append(failedAt, rhs.failedAt).append(stopPrice, rhs.stopPrice).append(canceledAt, rhs.canceledAt).append(assetId, rhs.assetId).append(qty, rhs.qty).append(exchange, rhs.exchange).append(id, rhs.id).append(submittedAt, rhs.submittedAt).append(filledQty, rhs.filledQty).append(timeInForce, rhs.timeInForce).append(updatedAt, rhs.updatedAt).append(status, rhs.status).isEquals();
    }

}
