
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Position implements Serializable
{

    @SerializedName("asset_id")
    @Expose
    private String assetId;
    @SerializedName("symbol")
    @Expose
    private String symbol;
    @SerializedName("exchange")
    @Expose
    private String exchange;
    @SerializedName("asset_class")
    @Expose
    private String assetClass;
    @SerializedName("avg_entry_price")
    @Expose
    private String avgEntryPrice;
    @SerializedName("qty")
    @Expose
    private String qty;
    @SerializedName("side")
    @Expose
    private String side;
    @SerializedName("market_value")
    @Expose
    private String marketValue;
    @SerializedName("cost_basis")
    @Expose
    private String costBasis;
    @SerializedName("unrealized_pl")
    @Expose
    private String unrealizedPl;
    @SerializedName("unrealized_plpc")
    @Expose
    private String unrealizedPlpc;
    @SerializedName("unrealized_intraday_pl")
    @Expose
    private String unrealizedIntradayPl;
    @SerializedName("unrealized_intraday_plpc")
    @Expose
    private String unrealizedIntradayPlpc;
    @SerializedName("current_price")
    @Expose
    private String currentPrice;
    @SerializedName("lastday_price")
    @Expose
    private String lastdayPrice;
    @SerializedName("change_today")
    @Expose
    private String changeToday;
    private final static long serialVersionUID = 1908507559904889480L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Position() {
    }

    /**
     * 
     * @param symbol
     * @param lastdayPrice
     * @param side
     * @param marketValue
     * @param currentPrice
     * @param assetClass
     * @param avgEntryPrice
     * @param unrealizedIntradayPl
     * @param unrealizedPlpc
     * @param unrealizedPl
     * @param changeToday
     * @param assetId
     * @param qty
     * @param costBasis
     * @param exchange
     * @param unrealizedIntradayPlpc
     */
    public Position(String assetId, String symbol, String exchange, String assetClass, String avgEntryPrice, String qty, String side, String marketValue, String costBasis, String unrealizedPl, String unrealizedPlpc, String unrealizedIntradayPl, String unrealizedIntradayPlpc, String currentPrice, String lastdayPrice, String changeToday) {
        super();
        this.assetId = assetId;
        this.symbol = symbol;
        this.exchange = exchange;
        this.assetClass = assetClass;
        this.avgEntryPrice = avgEntryPrice;
        this.qty = qty;
        this.side = side;
        this.marketValue = marketValue;
        this.costBasis = costBasis;
        this.unrealizedPl = unrealizedPl;
        this.unrealizedPlpc = unrealizedPlpc;
        this.unrealizedIntradayPl = unrealizedIntradayPl;
        this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
        this.currentPrice = currentPrice;
        this.lastdayPrice = lastdayPrice;
        this.changeToday = changeToday;
    }

    public String getAssetId() {
        return assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getExchange() {
        return exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getAssetClass() {
        return assetClass;
    }

    public void setAssetClass(String assetClass) {
        this.assetClass = assetClass;
    }

    public String getAvgEntryPrice() {
        return avgEntryPrice;
    }

    public void setAvgEntryPrice(String avgEntryPrice) {
        this.avgEntryPrice = avgEntryPrice;
    }

    public String getQty() {
        return qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public String getSide() {
        return side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public String getMarketValue() {
        return marketValue;
    }

    public void setMarketValue(String marketValue) {
        this.marketValue = marketValue;
    }

    public String getCostBasis() {
        return costBasis;
    }

    public void setCostBasis(String costBasis) {
        this.costBasis = costBasis;
    }

    public String getUnrealizedPl() {
        return unrealizedPl;
    }

    public void setUnrealizedPl(String unrealizedPl) {
        this.unrealizedPl = unrealizedPl;
    }

    public String getUnrealizedPlpc() {
        return unrealizedPlpc;
    }

    public void setUnrealizedPlpc(String unrealizedPlpc) {
        this.unrealizedPlpc = unrealizedPlpc;
    }

    public String getUnrealizedIntradayPl() {
        return unrealizedIntradayPl;
    }

    public void setUnrealizedIntradayPl(String unrealizedIntradayPl) {
        this.unrealizedIntradayPl = unrealizedIntradayPl;
    }

    public String getUnrealizedIntradayPlpc() {
        return unrealizedIntradayPlpc;
    }

    public void setUnrealizedIntradayPlpc(String unrealizedIntradayPlpc) {
        this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
    }

    public String getCurrentPrice() {
        return currentPrice;
    }

    public void setCurrentPrice(String currentPrice) {
        this.currentPrice = currentPrice;
    }

    public String getLastdayPrice() {
        return lastdayPrice;
    }

    public void setLastdayPrice(String lastdayPrice) {
        this.lastdayPrice = lastdayPrice;
    }

    public String getChangeToday() {
        return changeToday;
    }

    public void setChangeToday(String changeToday) {
        this.changeToday = changeToday;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("assetId", assetId).append("symbol", symbol).append("exchange", exchange).append("assetClass", assetClass).append("avgEntryPrice", avgEntryPrice).append("qty", qty).append("side", side).append("marketValue", marketValue).append("costBasis", costBasis).append("unrealizedPl", unrealizedPl).append("unrealizedPlpc", unrealizedPlpc).append("unrealizedIntradayPl", unrealizedIntradayPl).append("unrealizedIntradayPlpc", unrealizedIntradayPlpc).append("currentPrice", currentPrice).append("lastdayPrice", lastdayPrice).append("changeToday", changeToday).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(symbol).append(lastdayPrice).append(side).append(marketValue).append(currentPrice).append(assetClass).append(avgEntryPrice).append(unrealizedIntradayPl).append(unrealizedPlpc).append(unrealizedPl).append(changeToday).append(assetId).append(qty).append(costBasis).append(exchange).append(unrealizedIntradayPlpc).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Position) == false) {
            return false;
        }
        Position rhs = ((Position) other);
        return new EqualsBuilder().append(symbol, rhs.symbol).append(lastdayPrice, rhs.lastdayPrice).append(side, rhs.side).append(marketValue, rhs.marketValue).append(currentPrice, rhs.currentPrice).append(assetClass, rhs.assetClass).append(avgEntryPrice, rhs.avgEntryPrice).append(unrealizedIntradayPl, rhs.unrealizedIntradayPl).append(unrealizedPlpc, rhs.unrealizedPlpc).append(unrealizedPl, rhs.unrealizedPl).append(changeToday, rhs.changeToday).append(assetId, rhs.assetId).append(qty, rhs.qty).append(costBasis, rhs.costBasis).append(exchange, rhs.exchange).append(unrealizedIntradayPlpc, rhs.unrealizedIntradayPlpc).isEquals();
    }

}
