
package io.github.mainstringargs.alpaca.domain;

import java.io.Serializable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class StreamAuthResponse implements Serializable
{

    @SerializedName("stream")
    @Expose
    private String stream;
    @SerializedName("data")
    @Expose
    private Data_ data;
    private final static long serialVersionUID = -4203854704895709856L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StreamAuthResponse() {
    }

    /**
     * 
     * @param data
     * @param stream
     */
    public StreamAuthResponse(String stream, Data_ data) {
        super();
        this.stream = stream;
        this.data = data;
    }

    public String getStream() {
        return stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public Data_ getData() {
        return data;
    }

    public void setData(Data_ data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("stream", stream).append("data", data).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(data).append(stream).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StreamAuthResponse) == false) {
            return false;
        }
        StreamAuthResponse rhs = ((StreamAuthResponse) other);
        return new EqualsBuilder().append(data, rhs.data).append(stream, rhs.stream).isEquals();
    }

}
