/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca;

import io.github.mainstringargs.alpaca.AlpacaAPI;
import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.domain.Account;
import io.github.mainstringargs.alpaca.domain.Order;
import io.github.mainstringargs.alpaca.enums.Direction;
import io.github.mainstringargs.alpaca.enums.OrderStatus;
import io.github.mainstringargs.alpaca.rest.exceptions.AlpacaAPIException;
import io.github.mainstringargs.polygon.PolygonAPI;
import io.github.mainstringargs.polygon.domain.meta.SymbolDetails;
import io.github.mainstringargs.polygon.rest.exceptions.PolygonAPIException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.LinkedHashSet;
import java.util.List;

public class AllOrders {
    public static void main(String[] args) {
        AlpacaAPI alpacaApi = new AlpacaAPI();
        try {
            Account alpacaAccount = alpacaApi.getAccount();
            System.out.println("\n\nAccount Information:");
            System.out.println("\tCreated At: " + Utilities.fromDateTimeString(alpacaAccount.getCreatedAt()) + "\n\tBuying Power: " + alpacaAccount.getBuyingPower() + "\n\tPortfolio Value: " + alpacaAccount.getPortfolioValue());
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
        try {
            LocalDateTime ldt = LocalDateTime.of(2019, 1, 1, 7, 1);
            LocalDateTime ldtTwo = LocalDateTime.of(2019, 1, 1, 8, 1);
            LinkedHashSet<Order> buyOrders = new LinkedHashSet<Order>();
            LinkedHashSet<Order> sellOrders = new LinkedHashSet<Order>();
            for (int i = 0; i < 125; ++i) {
                for (int j = 0; j < 120; ++j) {
                    ldt = ldt.plusMinutes(5L);
                    ldtTwo = ldtTwo.plusMinutes(5L);
                    ZonedDateTime zdt = ZonedDateTime.of(ldt, ZoneId.of("America/Chicago"));
                    ZonedDateTime zdtTwo = ZonedDateTime.of(ldtTwo, ZoneId.of("America/Chicago"));
                    List<Order> orders = alpacaApi.getOrders(OrderStatus.CLOSED, 500, zdt.toLocalDateTime(), zdtTwo.toLocalDateTime(), Direction.ASC);
                    for (Order order : orders) {
                        if (order.getSide().equalsIgnoreCase("buy") && Integer.parseInt(order.getFilledQty()) > 0) {
                            buyOrders.add(order);
                            continue;
                        }
                        if (!order.getSide().equalsIgnoreCase("sell") || Integer.parseInt(order.getFilledQty()) <= 0) continue;
                        sellOrders.add(order);
                    }
                    System.out.println(zdt + " " + orders.size() + " " + buyOrders.size() + " " + sellOrders.size());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (orders.size() <= 499) continue;
                    System.err.println(zdt + " " + orders.size());
                }
                ldt = ldt.minusHours(10L).plusDays(1L);
                ldtTwo = ldtTwo.minusHours(10L).plusDays(1L);
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter("buyOrders.out"));
                PolygonAPI polyApi = new PolygonAPI();
                for (Order buyOrder : buyOrders) {
                    try {
                        SymbolDetails deets = null;
                        try {
                            deets = polyApi.getSymbolDetails(buyOrder.getSymbol());
                        }
                        catch (PolygonAPIException e) {
                            e.printStackTrace();
                        }
                        String name = deets != null ? deets.getName() : "N/A";
                        String line = buyOrder.getFilledAt() + "," + buyOrder.getSymbol() + "," + name + "," + buyOrder.getExchange() + "," + buyOrder.getAssetClass() + "," + buyOrder.getAssetId() + "," + buyOrder.getFilledAvgPrice() + "," + buyOrder.getFilledQty() + "\n";
                        System.out.println(line);
                        writer.write(line);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double buyPrices = buyOrders.stream().mapToDouble(o -> Double.parseDouble(o.getFilledAvgPrice())).sum();
            double sellPrices = sellOrders.stream().mapToDouble(o -> Double.parseDouble(o.getFilledAvgPrice())).sum();
            System.out.println(buyPrices + " " + sellPrices);
            System.out.println(buyPrices - sellPrices);
            System.out.println("BuyOrders: " + buyOrders.size() + " SellOrders: " + sellOrders.size());
        }
        catch (AlpacaAPIException e) {
            e.printStackTrace();
        }
    }
}

