/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaProperties {
    private static LinkedHashSet<Properties> propertyFiles = new LinkedHashSet();
    private static Logger LOGGER = LogManager.getLogger(AlpacaProperties.class);
    private static final String KEY_ID_KEY = "key_id";
    private static final String SECRET_KEY = "secret";
    private static final String BASE_ACCOUNT_URL_KEY = "base_url";
    private static final String BASE_DATA_URL_KEY = "base_data_url";
    private static final String USER_AGENT_KEY = "user_agent";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36";
    private static final String DEFAULT_ACCOUNT_URL = "https://paper-api.alpaca.markets";
    private static final String DEFAULT_DATA_URL = "https://data.alpaca.markets";
    public static final String INVALID_VALUE = "<PLACEHOLDER>";
    public static final String KEY_ID_VALUE;
    public static final String SECRET_VALUE;
    public static final String BASE_ACCOUNT_URL_VALUE;
    public static String BASE_DATA_URL_VALUE;
    public static final String USER_AGENT_VALUE;

    public static String getProperty(String key, String defaultValue) {
        for (Properties prop : propertyFiles) {
            String propertyVal;
            if (!prop.containsKey(key) || (propertyVal = prop.getProperty(key)).equals(INVALID_VALUE) || propertyVal.trim().isEmpty()) continue;
            LOGGER.debug("Loading " + key + " " + propertyVal);
            return propertyVal.trim();
        }
        LOGGER.debug("Loading " + key + " " + defaultValue);
        return defaultValue.trim();
    }

    static {
        LinkedHashSet<URL> propertyUrls = new LinkedHashSet<URL>();
        String propertyFile = "alpaca.properties";
        URL url = AlpacaProperties.class.getResource("/" + propertyFile);
        propertyUrls.add(url);
        Enumeration<URL> urls = null;
        try {
            urls = ClassLoader.getSystemClassLoader().getResources(propertyFile);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        while (urls.hasMoreElements()) {
            propertyUrls.add(urls.nextElement());
        }
        for (URL propUrl : propertyUrls) {
            LOGGER.info("Found " + propertyFile + " File: " + propUrl);
            InputStream is = null;
            try {
                is = url.openStream();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Properties propFile = new Properties();
            try {
                propFile.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            propertyFiles.add(propFile);
        }
        KEY_ID_VALUE = AlpacaProperties.getProperty(KEY_ID_KEY, INVALID_VALUE);
        SECRET_VALUE = AlpacaProperties.getProperty(SECRET_KEY, INVALID_VALUE);
        BASE_ACCOUNT_URL_VALUE = AlpacaProperties.getProperty(BASE_ACCOUNT_URL_KEY, DEFAULT_ACCOUNT_URL);
        BASE_DATA_URL_VALUE = AlpacaProperties.getProperty(BASE_DATA_URL_KEY, DEFAULT_DATA_URL);
        USER_AGENT_VALUE = AlpacaProperties.getProperty(USER_AGENT_KEY, DEFAULT_USER_AGENT);
    }
}

