/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.nats.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mainstringargs.polygon.domain.StockAggregate;
import io.github.mainstringargs.polygon.enums.ChannelType;
import io.github.mainstringargs.polygon.nats.message.ChannelMessage;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class AggregateMessage
implements ChannelMessage {
    private String ticker;
    private ChannelType channelType;
    private StockAggregate stockAggregate;
    private LocalDateTime start;
    private LocalDateTime end;
    private static Gson gson;

    public AggregateMessage(ChannelType cType, String ticker, JsonObject jsonObject) {
        this.ticker = ticker;
        this.channelType = cType;
        JsonObject jsonQuote = jsonObject.getAsJsonObject();
        this.stockAggregate = (StockAggregate)gson.fromJson((JsonElement)jsonQuote, StockAggregate.class);
        this.start = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.stockAggregate.getS()), ZoneId.systemDefault());
        this.end = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.stockAggregate.getE()), ZoneId.systemDefault());
    }

    @Override
    public String getTicker() {
        return this.ticker;
    }

    @Override
    public ChannelType getChannelType() {
        return this.channelType;
    }

    public StockAggregate getStockAggregate() {
        return this.stockAggregate;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channelType == null ? 0 : this.channelType.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.stockAggregate == null ? 0 : this.stockAggregate.hashCode());
        result = 31 * result + (this.ticker == null ? 0 : this.ticker.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateMessage other = (AggregateMessage)obj;
        if (this.channelType != other.channelType) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        if (this.stockAggregate == null ? other.stockAggregate != null : !this.stockAggregate.equals(other.stockAggregate)) {
            return false;
        }
        return !(this.ticker == null ? other.ticker != null : !this.ticker.equals(other.ticker));
    }

    public String toString() {
        return "AggregateMessage [ticker=" + this.ticker + ", channelType=" + (Object)((Object)this.channelType) + ", stockAggregate=" + this.stockAggregate + ", start=" + this.start + ", end=" + this.end + "]";
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        gson = gsonBuilder.create();
    }
}

