/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.rest.exceptions;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;

public class PolygonAPIException
extends Exception {
    private static final long serialVersionUID = 1L;
    private transient HttpResponse<JsonNode> httpResponse;
    private int httpResponseCode = -1;
    private String httpResponseMessage;
    private int polygonResponseCode = -1;
    private String polygonResponseMessage;

    public PolygonAPIException(HttpResponse<JsonNode> httpResponse) {
        this.httpResponseCode = httpResponse.getStatus();
        this.httpResponseMessage = httpResponse.getStatusText();
        JsonNode jsonNode = (JsonNode)httpResponse.getBody();
        if (jsonNode != null) {
            if (jsonNode.getObject().has("code")) {
                this.polygonResponseCode = jsonNode.getObject().getInt("code");
            }
            this.polygonResponseMessage = jsonNode.getObject().has("message") ? jsonNode.getObject().getString("message") : jsonNode.getObject().toString();
        }
    }

    public HttpResponse<JsonNode> getHttpResponse() {
        return this.httpResponse;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public String getHttpResponseMessage() {
        return this.httpResponseMessage;
    }

    public int getPolygonResponseCode() {
        return this.polygonResponseCode;
    }

    public String getPolygonResponseMessage() {
        return this.polygonResponseMessage;
    }

    @Override
    public String getMessage() {
        String message = "Generic Polygon Exception";
        if (this.polygonResponseCode != -1) {
            message = this.polygonResponseCode + "";
            if (this.polygonResponseMessage != null && !this.polygonResponseMessage.isEmpty()) {
                message = message + ": " + this.polygonResponseMessage;
            }
        } else if (this.httpResponseMessage != null && !this.httpResponseMessage.isEmpty()) {
            message = this.httpResponseCode + ": " + this.httpResponseMessage;
        }
        return message;
    }
}

