/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AlpacaRequestBuilder {
    private static final String VERSION = "v1";
    public static final String URL_SEPARATOR = "/";
    public final Map<String, String> urlParameters = new LinkedHashMap<String, String>();
    public final Map<String, String> bodyProperties = new LinkedHashMap<String, String>();
    private String baseUrl;
    private List<String> appendedEndpoints = new ArrayList<String>();
    private boolean defaultEndpoint = true;
    private String endpoint;

    public AlpacaRequestBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public AlpacaRequestBuilder(String baseUrl, String endpoint) {
        this.baseUrl = baseUrl;
        this.endpoint = endpoint;
    }

    public void appendURLParameter(String parameterKey, String parameterValue) {
        if (parameterValue != null) {
            this.urlParameters.put(parameterKey, parameterValue);
        }
    }

    public void appendBodyProperty(String parameterKey, String parameterValue) {
        if (parameterValue != null) {
            this.bodyProperties.put(parameterKey, parameterValue);
        }
    }

    public boolean isDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(boolean defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public String getBodyAsJSON() {
        JsonObject jsonBody = new JsonObject();
        for (Map.Entry<String, String> entry : this.bodyProperties.entrySet()) {
            jsonBody.addProperty(entry.getKey(), entry.getValue());
        }
        return jsonBody.toString();
    }

    public void appendEndpoint(String endpoint) {
        if (endpoint != null) {
            this.appendedEndpoints.add(endpoint);
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getURL() {
        StringBuilder builder = new StringBuilder(this.baseUrl);
        builder.append(URL_SEPARATOR);
        builder.append(VERSION);
        if (this.defaultEndpoint) {
            builder.append(URL_SEPARATOR);
            builder.append(this.getEndpoint());
        }
        for (String string : this.appendedEndpoints) {
            builder.append(URL_SEPARATOR);
            builder.append(string);
        }
        if (!this.urlParameters.isEmpty()) {
            builder.append('?');
            for (Map.Entry entry : this.urlParameters.entrySet()) {
                builder.append(((String)entry.getKey()).trim());
                builder.append('=');
                builder.append(((String)entry.getValue()).trim());
                builder.append('&');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

