/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon;

import com.google.gson.reflect.TypeToken;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.polygon.domain.DailyOpenClose;
import io.github.mainstringargs.polygon.domain.Quote;
import io.github.mainstringargs.polygon.domain.Snapshot;
import io.github.mainstringargs.polygon.domain.Trade;
import io.github.mainstringargs.polygon.domain.aggregate.Aggregates;
import io.github.mainstringargs.polygon.domain.aggregate.Result;
import io.github.mainstringargs.polygon.domain.historic.quotes.Quotes;
import io.github.mainstringargs.polygon.domain.historic.trades.Trades;
import io.github.mainstringargs.polygon.domain.meta.Exchange;
import io.github.mainstringargs.polygon.domain.meta.SymbolAnalystRatings;
import io.github.mainstringargs.polygon.domain.meta.SymbolDetails;
import io.github.mainstringargs.polygon.domain.meta.SymbolDividend;
import io.github.mainstringargs.polygon.domain.meta.SymbolEarning;
import io.github.mainstringargs.polygon.domain.meta.SymbolEndpoints;
import io.github.mainstringargs.polygon.domain.meta.SymbolFinancial;
import io.github.mainstringargs.polygon.domain.meta.SymbolNews;
import io.github.mainstringargs.polygon.domain.reference.Locale;
import io.github.mainstringargs.polygon.domain.reference.Market;
import io.github.mainstringargs.polygon.domain.reference.Split;
import io.github.mainstringargs.polygon.domain.reference.Tickers;
import io.github.mainstringargs.polygon.domain.reference.TypesMapping;
import io.github.mainstringargs.polygon.enums.Sort;
import io.github.mainstringargs.polygon.enums.Timespan;
import io.github.mainstringargs.polygon.enums.Type;
import io.github.mainstringargs.polygon.nats.PolygonNatsClient;
import io.github.mainstringargs.polygon.nats.PolygonStreamListener;
import io.github.mainstringargs.polygon.properties.PolygonProperties;
import io.github.mainstringargs.polygon.rest.PolygonRequest;
import io.github.mainstringargs.polygon.rest.PolygonRequestBuilder;
import io.github.mainstringargs.polygon.rest.exceptions.PolygonAPIException;
import java.time.LocalDate;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class PolygonAPI {
    private static Logger LOGGER = LogManager.getLogger(PolygonAPI.class);
    private final PolygonNatsClient polygonNatsClient;
    private final PolygonRequest polygonRequest;
    private String baseDataUrl;

    public PolygonAPI() {
        this(PolygonProperties.KEY_ID_VALUE);
    }

    public PolygonAPI(String keyId) {
        this(PolygonProperties.KEY_ID_VALUE, PolygonProperties.POLYGON_NATS_SERVERS_VALUE);
    }

    public PolygonAPI(String keyId, String ... polygonNatsServers) {
        this.polygonRequest = new PolygonRequest(keyId);
        this.polygonNatsClient = new PolygonNatsClient(keyId, polygonNatsServers);
        this.baseDataUrl = PolygonProperties.BASE_DATA_URL_VALUE;
    }

    public SymbolEndpoints getSymbolEndpoints(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        SymbolEndpoints symbolEndpoints = (SymbolEndpoints)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)SymbolEndpoints.class));
        return symbolEndpoints;
    }

    public SymbolDetails getSymbolDetails(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("company");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        SymbolDetails symbolDetails = (SymbolDetails)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)SymbolDetails.class));
        return symbolDetails;
    }

    public SymbolAnalystRatings getSymbolAnalystRatings(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("analysts");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        SymbolAnalystRatings symbolDetails = (SymbolAnalystRatings)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)SymbolAnalystRatings.class));
        return symbolDetails;
    }

    public List<SymbolDividend> getSymbolDividends(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("dividends");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<SymbolDividend>>(){}.getType();
        List symbolDetails = (List)this.polygonRequest.getResponseObject(response, listType);
        return symbolDetails;
    }

    public List<SymbolEarning> getSymbolEarnings(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("earnings");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<SymbolEarning>>(){}.getType();
        List symbolDetails = (List)this.polygonRequest.getResponseObject(response, listType);
        return symbolDetails;
    }

    public List<SymbolFinancial> getSymbolFinancials(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("financials");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<SymbolFinancial>>(){}.getType();
        List symbolDetails = (List)this.polygonRequest.getResponseObject(response, listType);
        return symbolDetails;
    }

    public List<SymbolNews> getSymbolNews(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("news");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<SymbolNews>>(){}.getType();
        List symbolDetails = (List)this.polygonRequest.getResponseObject(response, listType);
        return symbolDetails;
    }

    public List<SymbolNews> getSymbolNews(String symbol, Integer perpage, Integer page) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "symbols");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint("news");
        if (perpage != null) {
            builder.appendURLParameter("perpage", String.valueOf(perpage));
        }
        if (page != null) {
            builder.appendURLParameter("page", String.valueOf(page));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<SymbolNews>>(){}.getType();
        List symbolDetails = (List)this.polygonRequest.getResponseObject(response, listType);
        return symbolDetails;
    }

    public Tickers getTickers(Sort sort, Type type, io.github.mainstringargs.polygon.enums.Market market, io.github.mainstringargs.polygon.enums.Locale locale, String search, Integer perpage, Integer page, Boolean active) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "reference", "tickers");
        builder.setVersion("v2");
        if (sort != null) {
            builder.appendURLParameter("sort", sort.getAPIName());
        }
        if (type != null) {
            builder.appendURLParameter("type", type.getAPIName());
        }
        if (market != null) {
            builder.appendURLParameter("market", market.getAPIName());
        }
        if (locale != null) {
            builder.appendURLParameter("locale", locale.getAPIName());
        }
        if (search != null) {
            builder.appendURLParameter("search", search);
        }
        if (perpage != null) {
            builder.appendURLParameter("perpage", String.valueOf(perpage));
        }
        if (page != null) {
            builder.appendURLParameter("page", String.valueOf(page));
        }
        if (active != null) {
            builder.appendURLParameter("active", String.valueOf(active));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Tickers symbolDetails = (Tickers)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Tickers.class));
        return symbolDetails;
    }

    public List<Market> getMarkets() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "reference", "markets");
        builder.setVersion("v2");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Market>>(){}.getType();
        List markets = (List)this.polygonRequest.getResponseObject(response, listType);
        return markets;
    }

    public List<Locale> getLocales() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "reference", "locales");
        builder.setVersion("v2");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Locale>>(){}.getType();
        List locales = (List)this.polygonRequest.getResponseObject(response, listType);
        return locales;
    }

    public TypesMapping getTypesMapping() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "reference", "types");
        builder.setVersion("v2");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        TypesMapping typesMapping = (TypesMapping)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)TypesMapping.class));
        return typesMapping;
    }

    public List<Split> getSplits(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "reference", "splits");
        builder.setVersion("v2");
        builder.appendEndpoint(symbol);
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Split>>(){}.getType();
        List splits = (List)this.polygonRequest.getResponseObject(response, listType);
        return splits;
    }

    public List<Exchange> getExchanges() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "meta", "exchanges");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Exchange>>(){}.getType();
        List exchanges = (List)this.polygonRequest.getResponseObject(response, listType);
        return exchanges;
    }

    public Trades getHistoricTrades(String symbol, LocalDate date, Integer offset, Integer limit) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "historic", "trades");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint(Utilities.toDateString(date));
        if (offset != null) {
            builder.appendURLParameter("offset", String.valueOf(offset));
        }
        if (limit != null) {
            builder.appendURLParameter("limit", String.valueOf(limit));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Trades tradesDetails = (Trades)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Trades.class));
        return tradesDetails;
    }

    public Quotes getHistoricQuotes(String symbol, LocalDate date, Integer offset, Integer limit) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "historic", "quotes");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint(Utilities.toDateString(date));
        if (offset != null) {
            builder.appendURLParameter("offset", String.valueOf(offset));
        }
        if (limit != null) {
            builder.appendURLParameter("limit", String.valueOf(limit));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Quotes quotesDetails = (Quotes)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Quotes.class));
        return quotesDetails;
    }

    public Trade getLastTrade(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "last", "stocks");
        builder.appendEndpoint(symbol);
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Trade stockTrade = (Trade)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Trade.class));
        return stockTrade;
    }

    public Quote getLastQuote(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "last_quote", "stocks");
        builder.appendEndpoint(symbol);
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Quote stockQuote = (Quote)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Quote.class));
        return stockQuote;
    }

    public DailyOpenClose getDailyOpenClose(String symbol, LocalDate date) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "open-close");
        builder.appendEndpoint(symbol);
        builder.appendEndpoint(Utilities.toDateString(date));
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        DailyOpenClose dailyOpenClose = (DailyOpenClose)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)DailyOpenClose.class));
        return dailyOpenClose;
    }

    public List<Snapshot> getSnapshotAllTickers() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "snapshot", "locale", "us", "markets", "stocks", "tickers");
        builder.setVersion("v2");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Snapshot>>(){}.getType();
        List snapshots = (List)this.polygonRequest.getResponseObject(response, listType);
        return snapshots;
    }

    public Snapshot getSnapshot(String symbol) throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "snapshot", "locale", "us", "markets", "stocks", "tickers");
        builder.setVersion("v2");
        builder.appendEndpoint(symbol);
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Snapshot snapshot = (Snapshot)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Snapshot.class));
        return snapshot;
    }

    public List<Snapshot> getSnapshotsGainers() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "snapshot", "locale", "us", "markets", "stocks", "gainers");
        builder.setVersion("v2");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Snapshot>>(){}.getType();
        List snapshots = (List)this.polygonRequest.getResponseObject(response, listType);
        return snapshots;
    }

    public List<Snapshot> getSnapshotsLosers() throws PolygonAPIException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "snapshot", "locale", "us", "markets", "stocks", "losers");
        builder.setVersion("v2");
        HttpResponse<JsonNode> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        java.lang.reflect.Type listType = new TypeToken<List<Snapshot>>(){}.getType();
        List snapshots = (List)this.polygonRequest.getResponseObject(response, listType);
        return snapshots;
    }

    public Aggregates getPreviousClose(String ticker, Boolean unadjusted) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "aggs", "ticker");
        builder.setVersion("v2");
        builder.appendEndpoint(ticker);
        builder.appendEndpoint("prev");
        if (unadjusted != null) {
            builder.appendURLParameter("unadjusted", unadjusted.toString());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Aggregates aggregates = (Aggregates)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Aggregates.class));
        if (aggregates.getResultsCount() == 1L) {
            aggregates.getResults().get(0).setTicker(ticker);
        }
        return aggregates;
    }

    public Aggregates getAggregates(String ticker, Integer multiplier, Timespan timeSpan, LocalDate fromDate, LocalDate toDate, Boolean unadjusted) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "aggs", "ticker");
        builder.setVersion("v2");
        builder.appendEndpoint(ticker);
        builder.appendEndpoint("range");
        builder.appendEndpoint(Integer.toString(multiplier != null ? multiplier : 1));
        builder.appendEndpoint(timeSpan.getAPIName());
        builder.appendEndpoint(Utilities.toDateString(fromDate));
        builder.appendEndpoint(Utilities.toDateString(toDate));
        if (unadjusted != null) {
            builder.appendURLParameter("unadjusted", unadjusted.toString());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Aggregates aggregates = (Aggregates)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Aggregates.class));
        if (aggregates.getResultsCount() != 0L) {
            List<Result> results = aggregates.getResults();
            for (Result result : results) {
                result.setTicker(ticker);
            }
        }
        return aggregates;
    }

    public Aggregates getGroupedDaily(io.github.mainstringargs.polygon.enums.Locale locale, io.github.mainstringargs.polygon.enums.Market market, LocalDate date, Boolean unadjusted) throws PolygonAPIException {
        HttpResponse<JsonNode> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseDataUrl, "aggs", "grouped", "locale");
        builder.setVersion("v2");
        builder.appendEndpoint(locale.getAPIName());
        builder.appendEndpoint("market");
        builder.appendEndpoint(market.getAPIName());
        builder.appendEndpoint(Utilities.toDateString(date));
        if (unadjusted != null) {
            builder.appendURLParameter("unadjusted", unadjusted.toString());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIException(response);
        }
        Aggregates aggregates = (Aggregates)this.polygonRequest.getResponseObject(response, (java.lang.reflect.Type)((Object)Aggregates.class));
        if (aggregates.getResultsCount() != 0L) {
            String tickerKey = "T";
            String resultsKey = "results";
            List<Result> results = aggregates.getResults();
            JsonNode responseJson = (JsonNode)response.getBody();
            JSONArray resultsArr = (JSONArray)responseJson.getObject().get("results");
            for (int i = 0; i < results.size(); ++i) {
                Result result = results.get(i);
                JSONObject jsonObj = (JSONObject)resultsArr.get(i);
                result.setTicker(jsonObj.get("T").toString());
            }
        }
        return aggregates;
    }

    public void addPolygonStreamListener(PolygonStreamListener streamListener) {
        this.polygonNatsClient.addListener(streamListener);
    }

    public void removePolygonStreamListener(PolygonStreamListener streamListener) {
        this.polygonNatsClient.removeListener(streamListener);
    }
}

