/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.rest;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PolygonRequestBuilder {
    private String version = "v1";
    public static final String URL_SEPARATOR = "/";
    public final Map<String, String> urlParameters = new LinkedHashMap<String, String>();
    public final Map<String, String> bodyProperties = new LinkedHashMap<String, String>();
    private String baseUrl;
    private List<String> appendedEndpoints = new ArrayList<String>();
    private boolean defaultEndpoint = true;
    private String endpoint;

    public PolygonRequestBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public PolygonRequestBuilder(String baseUrl, String endpoint) {
        this.baseUrl = baseUrl;
        this.endpoint = endpoint;
    }

    public PolygonRequestBuilder(String baseUrl, String endpoint, String ... appendedEndpoints) {
        this.baseUrl = baseUrl;
        this.endpoint = endpoint;
        for (String appendedEndpoint : appendedEndpoints) {
            this.appendEndpoint(appendedEndpoint);
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void appendURLParameter(String parameterKey, String parameterValue) {
        this.urlParameters.put(parameterKey, parameterValue);
    }

    public void appendBodyProperty(String parameterKey, String parameterValue) {
        this.bodyProperties.put(parameterKey, parameterValue);
    }

    public boolean isDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(boolean defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public String getBodyAsJSON() {
        JsonObject jsonBody = new JsonObject();
        for (Map.Entry<String, String> entry : this.bodyProperties.entrySet()) {
            jsonBody.addProperty(entry.getKey(), entry.getValue());
        }
        return jsonBody.toString();
    }

    public void appendEndpoint(String endpoint) {
        this.appendedEndpoints.add(endpoint);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getURL() {
        StringBuilder builder = new StringBuilder(this.baseUrl);
        builder.append(URL_SEPARATOR);
        builder.append(this.version);
        if (this.defaultEndpoint) {
            builder.append(URL_SEPARATOR);
            builder.append(this.getEndpoint());
        }
        for (String string : this.appendedEndpoints) {
            builder.append(URL_SEPARATOR);
            builder.append(string);
        }
        if (!this.urlParameters.isEmpty()) {
            builder.append('?');
            for (Map.Entry entry : this.urlParameters.entrySet()) {
                builder.append(((String)entry.getKey()).trim());
                builder.append('=');
                builder.append(((String)entry.getValue()).trim());
                builder.append('&');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

