/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca;

import com.google.gson.reflect.TypeToken;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.domain.Account;
import io.github.mainstringargs.alpaca.domain.Asset;
import io.github.mainstringargs.alpaca.domain.Bar;
import io.github.mainstringargs.alpaca.domain.Calendar;
import io.github.mainstringargs.alpaca.domain.Clock;
import io.github.mainstringargs.alpaca.domain.Order;
import io.github.mainstringargs.alpaca.domain.Position;
import io.github.mainstringargs.alpaca.enums.AssetStatus;
import io.github.mainstringargs.alpaca.enums.BarsTimeFrame;
import io.github.mainstringargs.alpaca.enums.Direction;
import io.github.mainstringargs.alpaca.enums.OrderSide;
import io.github.mainstringargs.alpaca.enums.OrderStatus;
import io.github.mainstringargs.alpaca.enums.OrderTimeInForce;
import io.github.mainstringargs.alpaca.enums.OrderType;
import io.github.mainstringargs.alpaca.properties.AlpacaProperties;
import io.github.mainstringargs.alpaca.rest.AlpacaRequest;
import io.github.mainstringargs.alpaca.rest.AlpacaRequestBuilder;
import io.github.mainstringargs.alpaca.rest.exceptions.AlpacaAPIException;
import io.github.mainstringargs.alpaca.websocket.AlpacaStreamListener;
import io.github.mainstringargs.alpaca.websocket.AlpacaWebsocketClient;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaAPI {
    private final String keyId;
    private final String secret;
    private final String baseAccountUrl;
    private final AlpacaRequest alpacaRequest;
    private final String baseDataUrl;
    private static Logger LOGGER = LogManager.getLogger(AlpacaAPI.class);
    private final AlpacaWebsocketClient alpacaWebSocketClient;

    public AlpacaAPI() {
        this.keyId = AlpacaProperties.KEY_ID_VALUE;
        this.secret = AlpacaProperties.SECRET_VALUE;
        this.baseAccountUrl = AlpacaProperties.BASE_ACCOUNT_URL_VALUE;
        this.baseDataUrl = AlpacaProperties.BASE_DATA_URL_VALUE;
        this.alpacaRequest = new AlpacaRequest(this.keyId, this.secret);
        this.alpacaWebSocketClient = new AlpacaWebsocketClient(this.keyId, this.secret, this.baseAccountUrl);
    }

    public AlpacaAPI(String keyId, String secret, String baseAccountUrl, String baseDataUrl) {
        this.keyId = keyId;
        this.secret = secret;
        this.baseAccountUrl = baseAccountUrl;
        this.baseDataUrl = baseDataUrl;
        this.alpacaRequest = new AlpacaRequest(keyId, secret);
        this.alpacaWebSocketClient = new AlpacaWebsocketClient(keyId, secret, baseAccountUrl);
    }

    public AlpacaAPI(String keyId, String secret, String baseAccountUrl) {
        this.keyId = keyId;
        this.secret = secret;
        this.baseAccountUrl = baseAccountUrl;
        this.baseDataUrl = AlpacaProperties.BASE_DATA_URL_VALUE;
        this.alpacaRequest = new AlpacaRequest(keyId, secret);
        this.alpacaWebSocketClient = new AlpacaWebsocketClient(keyId, secret, baseAccountUrl);
    }

    public Account getAccount() throws AlpacaAPIException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "account");
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Account account = (Account)this.alpacaRequest.getResponseObject(response, (Type)((Object)Account.class));
        return account;
    }

    public List<Order> getOrders() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Order>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "orders");
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List orders = (List)this.alpacaRequest.getResponseObject(response, listType);
        return orders;
    }

    public List<Order> getOrders(OrderStatus status, Integer limit, LocalDateTime after, LocalDateTime until, Direction direction) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type listType = new TypeToken<List<Order>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "orders");
        if (status != null) {
            urlBuilder.appendURLParameter("status", status.getAPIName());
        }
        if (limit != null) {
            urlBuilder.appendURLParameter("limit", limit.toString());
        }
        if (after != null) {
            urlBuilder.appendURLParameter("after", Utilities.toDateTimeString(after));
        }
        if (until != null) {
            urlBuilder.appendURLParameter("until", Utilities.toDateTimeString(until));
        }
        if (direction != null) {
            urlBuilder.appendURLParameter("direction", direction.getAPIName());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List orders = (List)this.alpacaRequest.getResponseObject(response, listType);
        return orders;
    }

    public Order requestNewOrder(String symbol, Integer quantity, OrderSide side, OrderType type, OrderTimeInForce timeInForce, Double limitPrice, Double stopPrice, String clientOrderId) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type objectType = new TypeToken<Order>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "orders");
        if (symbol != null) {
            urlBuilder.appendBodyProperty("symbol", symbol);
        }
        if (quantity != null) {
            urlBuilder.appendBodyProperty("qty", quantity.toString());
        }
        if (side != null) {
            urlBuilder.appendBodyProperty("side", side.getAPIName());
        }
        if (type != null) {
            urlBuilder.appendBodyProperty("type", type.getAPIName());
        }
        if (timeInForce != null) {
            urlBuilder.appendBodyProperty("time_in_force", timeInForce.getAPIName());
        }
        if (limitPrice != null) {
            urlBuilder.appendBodyProperty("limit_price", Utilities.toDecimalFormat(limitPrice));
        }
        if (stopPrice != null) {
            urlBuilder.appendBodyProperty("stop_price", Utilities.toDecimalFormat(stopPrice));
        }
        if (clientOrderId != null) {
            urlBuilder.appendBodyProperty("client_order_id", clientOrderId);
        }
        if ((response = this.alpacaRequest.invokePost(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Order order = (Order)this.alpacaRequest.getResponseObject(response, objectType);
        return order;
    }

    public Order getOrder(String orderId) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type objectType = new TypeToken<Order>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "orders");
        if (orderId != null) {
            urlBuilder.appendEndpoint(orderId);
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Order order = (Order)this.alpacaRequest.getResponseObject(response, objectType);
        return order;
    }

    public Order getOrderByClientId(String clientOrderId) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type objectType = new TypeToken<Order>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "orders:by_client_order_id");
        if (clientOrderId != null) {
            try {
                clientOrderId = URLEncoder.encode(clientOrderId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            urlBuilder.appendURLParameter("client_order_id", clientOrderId);
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Order order = (Order)this.alpacaRequest.getResponseObject(response, objectType);
        return order;
    }

    public boolean cancelOrder(String orderId) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "orders");
        if (orderId != null) {
            urlBuilder.appendEndpoint(orderId);
        }
        if ((response = this.alpacaRequest.invokeDelete(urlBuilder)).getStatus() != 200 && response.getStatus() != 204) {
            throw new AlpacaAPIException(response);
        }
        return response.getStatus() == 200 || response.getStatus() == 204;
    }

    public List<Position> getOpenPositions() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Position>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "positions");
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List positions = (List)this.alpacaRequest.getResponseObject(response, listType);
        return positions;
    }

    public Position getOpenPositionBySymbol(String symbol) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type listType = new TypeToken<Position>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "positions");
        if (symbol != null) {
            urlBuilder.appendEndpoint(symbol.trim());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Position position = (Position)this.alpacaRequest.getResponseObject(response, listType);
        return position;
    }

    public List<Asset> getAssets() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Asset>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "assets");
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List assets = (List)this.alpacaRequest.getResponseObject(response, listType);
        return assets;
    }

    public List<Asset> getAssets(AssetStatus assetStatus, String assetClass) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type listType = new TypeToken<List<Asset>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "assets");
        if (assetStatus != null) {
            urlBuilder.appendURLParameter("status", assetStatus.getAPIName());
        }
        if (assetClass != null) {
            urlBuilder.appendURLParameter("asset_class", assetClass.trim());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List assets = (List)this.alpacaRequest.getResponseObject(response, listType);
        return assets;
    }

    public Asset getAssetBySymbol(String symbol) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type listType = new TypeToken<Asset>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "assets");
        if (symbol != null) {
            urlBuilder.appendEndpoint(symbol.trim());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Asset asset = (Asset)this.alpacaRequest.getResponseObject(response, listType);
        return asset;
    }

    public List<Calendar> getCalendar() throws AlpacaAPIException {
        Type listType = new TypeToken<List<Calendar>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "calendar");
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List calendar = (List)this.alpacaRequest.getResponseObject(response, listType);
        return calendar;
    }

    public List<Calendar> getCalendar(LocalDate start, LocalDate end) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        Type listType = new TypeToken<List<Calendar>>(){}.getType();
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "calendar");
        if (start != null) {
            urlBuilder.appendURLParameter("start", Utilities.toDateString(start));
        }
        if (end != null) {
            urlBuilder.appendURLParameter("end", Utilities.toDateString(end));
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        List calendar = (List)this.alpacaRequest.getResponseObject(response, listType);
        return calendar;
    }

    public Clock getClock() throws AlpacaAPIException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAccountUrl, "clock");
        HttpResponse<JsonNode> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Clock clock = (Clock)this.alpacaRequest.getResponseObject(response, (Type)((Object)Clock.class));
        return clock;
    }

    public Map<String, List<Bar>> getBars(BarsTimeFrame timeframe, String[] symbols, Integer limit, LocalDateTime start, LocalDateTime end, LocalDateTime after, LocalDateTime until) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseDataUrl, "bars");
        if (timeframe != null) {
            urlBuilder.appendEndpoint(timeframe.getAPIName());
        }
        if (start != null) {
            urlBuilder.appendURLParameter("start", Utilities.toDateTimeString(start));
        }
        if (end != null) {
            urlBuilder.appendURLParameter("end", Utilities.toDateTimeString(end));
        }
        if (after != null) {
            urlBuilder.appendURLParameter("after", Utilities.toDateTimeString(after));
        }
        if (until != null) {
            urlBuilder.appendURLParameter("until", Utilities.toDateTimeString(until));
        }
        if (limit != null) {
            urlBuilder.appendURLParameter("limit", limit.toString());
        }
        if (symbols != null) {
            urlBuilder.appendURLParameter("symbols", String.join((CharSequence)",", symbols));
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Type mapType = new TypeToken<Map<String, List<Bar>>>(){}.getType();
        Map bars = (Map)this.alpacaRequest.getResponseObject(response, mapType);
        return bars;
    }

    public List<Bar> getBars(BarsTimeFrame timeframe, String symbol, Integer limit, LocalDateTime start, LocalDateTime end, LocalDateTime after, LocalDateTime until) throws AlpacaAPIException {
        HttpResponse<JsonNode> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseDataUrl, "bars");
        if (timeframe != null) {
            urlBuilder.appendEndpoint(timeframe.getAPIName());
        }
        if (start != null) {
            urlBuilder.appendURLParameter("start", Utilities.toDateTimeString(start));
        }
        if (end != null) {
            urlBuilder.appendURLParameter("end", Utilities.toDateTimeString(end));
        }
        if (after != null) {
            urlBuilder.appendURLParameter("after", Utilities.toDateTimeString(after));
        }
        if (until != null) {
            urlBuilder.appendURLParameter("until", Utilities.toDateTimeString(until));
        }
        if (limit != null) {
            urlBuilder.appendURLParameter("limit", limit.toString());
        }
        if (symbol != null) {
            urlBuilder.appendURLParameter("symbols", String.join((CharSequence)",", symbol));
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIException(response);
        }
        Type mapType = new TypeToken<Map<String, List<Bar>>>(){}.getType();
        Map bars = (Map)this.alpacaRequest.getResponseObject(response, mapType);
        return (List)bars.get(symbol);
    }

    public void addAlpacaStreamListener(AlpacaStreamListener streamListener) {
        this.alpacaWebSocketClient.addListener(streamListener);
    }

    public void removeAlpacaStreamListener(AlpacaStreamListener streamListener) {
        this.alpacaWebSocketClient.removeListener(streamListener);
    }
}

