/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.enums;

public enum OrderEvent {
    NEW("new"),
    FILL("fill", "filled"),
    PARTIALLY_FILLED("partially_filled", "partial_fill"),
    DONE_FOR_DAY("done_for_day"),
    CANCELED("canceled"),
    EXPIRED("expired"),
    PENDING_CANCEL("pending_cancel"),
    STOPPED("stopped"),
    REJECTED("rejected"),
    SUSPENDED("suspended"),
    PENDING_NEW("pending_new"),
    CALCULATED("calculated");

    private String mainApiName;
    private String[] apiNames;

    private OrderEvent(String ... apiNames) {
        this.mainApiName = apiNames[0];
        this.apiNames = apiNames;
    }

    public String getMainAPIName() {
        return this.mainApiName;
    }

    public String[] getApiNames() {
        return this.apiNames;
    }

    public static OrderEvent fromAPIName(String apiNameCheck) {
        for (OrderEvent event : OrderEvent.values()) {
            for (String apiName : event.getApiNames()) {
                if (!apiName.equals(apiNameCheck.trim())) continue;
                return event;
            }
        }
        return null;
    }
}

