/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon;

import com.google.common.collect.Sets;
import io.github.mainstringargs.polygon.PolygonAPI;
import io.github.mainstringargs.polygon.domain.DailyOpenClose;
import io.github.mainstringargs.polygon.domain.Quote;
import io.github.mainstringargs.polygon.domain.Snapshot;
import io.github.mainstringargs.polygon.domain.Trade;
import io.github.mainstringargs.polygon.domain.aggregate.Aggregates;
import io.github.mainstringargs.polygon.domain.aggregate.Result;
import io.github.mainstringargs.polygon.domain.historic.quotes.Quotes;
import io.github.mainstringargs.polygon.domain.historic.trades.Tick;
import io.github.mainstringargs.polygon.domain.historic.trades.Trades;
import io.github.mainstringargs.polygon.domain.meta.Exchange;
import io.github.mainstringargs.polygon.domain.meta.SymbolAnalystRatings;
import io.github.mainstringargs.polygon.domain.meta.SymbolDetails;
import io.github.mainstringargs.polygon.domain.meta.SymbolDividend;
import io.github.mainstringargs.polygon.domain.meta.SymbolEarning;
import io.github.mainstringargs.polygon.domain.meta.SymbolEndpoints;
import io.github.mainstringargs.polygon.domain.meta.SymbolFinancial;
import io.github.mainstringargs.polygon.domain.meta.SymbolNews;
import io.github.mainstringargs.polygon.domain.reference.Locale;
import io.github.mainstringargs.polygon.domain.reference.Market;
import io.github.mainstringargs.polygon.domain.reference.Split;
import io.github.mainstringargs.polygon.domain.reference.Ticker;
import io.github.mainstringargs.polygon.domain.reference.TypesMapping;
import io.github.mainstringargs.polygon.enums.ChannelType;
import io.github.mainstringargs.polygon.enums.Sort;
import io.github.mainstringargs.polygon.enums.Timespan;
import io.github.mainstringargs.polygon.nats.PolygonStreamListener;
import io.github.mainstringargs.polygon.nats.message.ChannelMessage;
import io.github.mainstringargs.polygon.rest.exceptions.PolygonAPIException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolygonExample {
    public static void main(String[] args) {
        Aggregates aggs;
        List<Snapshot> snapshots;
        PolygonAPI polygonAPI = new PolygonAPI();
        final String ticker = "MSFT";
        try {
            SymbolEndpoints symbolEndPoints = polygonAPI.getSymbolEndpoints(ticker);
            System.out.println("\n\n" + ticker + " Symbol Endpoints:");
            System.out.println("\t" + symbolEndPoints.getSymbol().getSymbol() + " " + symbolEndPoints.getSymbol().getName() + " " + symbolEndPoints.getSymbol().getType() + symbolEndPoints.getSymbol().getUrl() + " " + symbolEndPoints.getSymbol().getUpdated());
            System.out.println("\t" + symbolEndPoints.getEndpoints());
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            SymbolDetails symbolDetails = polygonAPI.getSymbolDetails(ticker);
            System.out.println("\n\n" + ticker + " Symbol Details:");
            System.out.println("\t" + symbolDetails);
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            SymbolAnalystRatings symbolAnalystRatings = polygonAPI.getSymbolAnalystRatings(ticker);
            System.out.println("\n\n" + ticker + " Symbol Analyst Ratings:");
            System.out.println("\t" + symbolAnalystRatings);
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<SymbolDividend> symbolDividends = polygonAPI.getSymbolDividends(ticker);
            System.out.println("\n\n" + ticker + " Symbol Dividends:");
            for (SymbolDividend symbolDividend : symbolDividends) {
                System.out.println("\t" + symbolDividend);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<SymbolEarning> symbolEarnings = polygonAPI.getSymbolEarnings(ticker);
            System.out.println("\n\n" + ticker + " Symbol Earnings:");
            for (SymbolEarning symbolEarning : symbolEarnings) {
                System.out.println("\t" + symbolEarning);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<SymbolFinancial> symbolFinancials = polygonAPI.getSymbolFinancials(ticker);
            System.out.println("\n\n" + ticker + " Symbol Financials:");
            for (SymbolFinancial symbolFinancial : symbolFinancials) {
                System.out.println("\t" + symbolFinancial);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<SymbolNews> symbolNews = polygonAPI.getSymbolNews(ticker);
            System.out.println("\n\n" + ticker + " Symbol News:");
            for (SymbolNews symbolNews2 : symbolNews) {
                System.out.println("\t" + symbolNews2);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<Ticker> tickers = polygonAPI.getTickers(Sort.TICKER_ASC, null, null, io.github.mainstringargs.polygon.enums.Locale.US, "Tech", null, null, null).getTickers();
            System.out.println("\n\nTech Search US Tickers");
            for (Ticker ticker2 : tickers) {
                System.out.println("\t" + ticker2);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<Market> markets = polygonAPI.getMarkets();
            System.out.println("\n\n Markets:");
            for (Market market : markets) {
                System.out.println("\t" + market);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<Locale> locales = polygonAPI.getLocales();
            System.out.println("\n\n Locales:");
            for (Locale locale : locales) {
                System.out.println("\t" + locale);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            TypesMapping typesMapping = polygonAPI.getTypesMapping();
            System.out.println("\n\ntypesMapping");
            System.out.println("\t" + typesMapping.getTypes());
            System.out.println("\t" + typesMapping.getIndexTypes());
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<Split> splits = polygonAPI.getSplits(ticker);
            System.out.println("\n\n" + ticker + " Split:");
            for (Split split : splits) {
                System.out.println("\t" + split);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            List<Exchange> exchanges = polygonAPI.getExchanges();
            System.out.println("\n\nexchanges");
            for (Exchange exchange : exchanges) {
                System.out.println("\t" + exchange);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            Trades trades = polygonAPI.getHistoricTrades(ticker, LocalDate.of(2019, 5, 7), null, null);
            System.out.println("\n\n" + ticker + " Trades on " + LocalDate.of(2019, 5, 7) + ": ");
            System.out.println("\tmap " + trades.getMap());
            System.out.println("\tticks");
            for (Tick tick : trades.getTicks()) {
                System.out.println("\t" + tick);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            Quotes quotes = polygonAPI.getHistoricQuotes(ticker, LocalDate.of(2019, 5, 7), null, null);
            System.out.println("\n\n" + ticker + " Quotes on " + LocalDate.of(2019, 5, 1) + ": ");
            System.out.println("\tmap " + quotes.getMap());
            System.out.println("\tticks");
            for (io.github.mainstringargs.polygon.domain.historic.quotes.Tick tick : quotes.getTicks()) {
                System.out.println("\t" + tick);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            Trade trade = polygonAPI.getLastTrade(ticker);
            System.out.println("\n\n" + ticker + " Last Trade: ");
            System.out.println("\t" + trade);
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            Quote quote = polygonAPI.getLastQuote(ticker);
            System.out.println("\n\n" + ticker + " Last Quote: ");
            System.out.println("\t" + quote);
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            DailyOpenClose dailyOpenClose = polygonAPI.getDailyOpenClose(ticker, LocalDate.of(2019, 5, 7));
            System.out.println("\n\n" + ticker + " DailyOpenClose on " + LocalDate.of(2019, 5, 1) + ": ");
            System.out.println("\t" + dailyOpenClose);
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            Snapshot snapshot = polygonAPI.getSnapshot(ticker);
            System.out.println("\n\n" + ticker + " Snapshot: ");
            System.out.println("\t" + snapshot);
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            snapshots = polygonAPI.getSnapshotAllTickers();
            System.out.println("\n\nsnapshots " + snapshots.size());
            for (Snapshot snapshot : snapshots) {
                System.out.println("\t" + snapshot);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            snapshots = polygonAPI.getSnapshotsGainers();
            System.out.println("\n\ngainers snapshots " + snapshots.size());
            for (Snapshot snapshot : snapshots) {
                System.out.println("\t" + snapshot);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            snapshots = polygonAPI.getSnapshotsLosers();
            System.out.println("\n\nlosers snapshots " + snapshots.size());
            for (Snapshot snapshot : snapshots) {
                System.out.println("\t" + snapshot);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            aggs = polygonAPI.getPreviousClose(ticker, false);
            System.out.println("\n\nprevious close aggregates " + aggs.getResultsCount());
            for (Result result : aggs.getResults()) {
                System.out.println("\t" + result);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            aggs = polygonAPI.getAggregates(ticker, null, Timespan.Hour, LocalDate.of(2019, 4, 23), LocalDate.of(2019, 4, 26), false);
            System.out.println("\n\nAggs over time " + aggs.getResultsCount());
            for (Result result : aggs.getResults()) {
                System.out.println("\t" + result);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        try {
            aggs = polygonAPI.getGroupedDaily(io.github.mainstringargs.polygon.enums.Locale.US, io.github.mainstringargs.polygon.enums.Market.STOCKS, LocalDate.of(2019, 4, 26), false);
            System.out.println("\n\nGrouped Daily " + aggs.getResultsCount());
            for (Result result : aggs.getResults()) {
                System.out.println("\t" + result);
            }
        }
        catch (PolygonAPIException e) {
            e.printStackTrace();
        }
        polygonAPI.addPolygonStreamListener(new PolygonStreamListener(){

            @Override
            public void streamUpdate(String ticker2, ChannelType channelType, ChannelMessage message) {
                System.out.println("===> streamUpdate " + ticker2 + " " + (Object)((Object)channelType) + " " + message);
            }

            @Override
            public Map<String, Set<ChannelType>> getStockChannelTypes() {
                HashMap<String, Set<ChannelType>> subscribedTypes = new HashMap<String, Set<ChannelType>>();
                subscribedTypes.put(ticker, Sets.newHashSet((Object[])ChannelType.values()));
                return subscribedTypes;
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

