/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.nats.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mainstringargs.polygon.domain.StockTrade;
import io.github.mainstringargs.polygon.enums.ChannelType;
import io.github.mainstringargs.polygon.nats.message.ChannelMessage;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class TradesMessage
implements ChannelMessage {
    private String ticker;
    private ChannelType channelType;
    private StockTrade stockTrade;
    private static Gson gson;
    private LocalDateTime timestamp;

    public TradesMessage(ChannelType cType, String ticker, JsonObject jsonObject) {
        this.ticker = ticker;
        this.channelType = cType;
        JsonObject jsonQuote = jsonObject.getAsJsonObject();
        this.stockTrade = (StockTrade)gson.fromJson((JsonElement)jsonQuote, StockTrade.class);
        this.timestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.stockTrade.getT()), ZoneId.systemDefault());
    }

    @Override
    public String getTicker() {
        return this.ticker;
    }

    @Override
    public ChannelType getChannelType() {
        return this.channelType;
    }

    public StockTrade getStockTrade() {
        return this.stockTrade;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channelType == null ? 0 : this.channelType.hashCode());
        result = 31 * result + (this.stockTrade == null ? 0 : this.stockTrade.hashCode());
        result = 31 * result + (this.ticker == null ? 0 : this.ticker.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TradesMessage other = (TradesMessage)obj;
        if (this.channelType != other.channelType) {
            return false;
        }
        if (this.stockTrade == null ? other.stockTrade != null : !this.stockTrade.equals(other.stockTrade)) {
            return false;
        }
        if (this.ticker == null ? other.ticker != null : !this.ticker.equals(other.ticker)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public String toString() {
        return "TradesMessage [ticker=" + this.ticker + ", channelType=" + (Object)((Object)this.channelType) + ", stockTrade=" + this.stockTrade + ", timestamp=" + this.timestamp + "]";
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        gson = gsonBuilder.create();
    }
}

