/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.mashape.unirest.http.HttpResponse;
import io.github.mainstringargs.alpaca.enums.ActivityType;
import io.github.mainstringargs.alpaca.enums.AssetStatus;
import io.github.mainstringargs.alpaca.enums.BarsTimeFrame;
import io.github.mainstringargs.alpaca.enums.Direction;
import io.github.mainstringargs.alpaca.enums.OrderClass;
import io.github.mainstringargs.alpaca.enums.OrderSide;
import io.github.mainstringargs.alpaca.enums.OrderStatus;
import io.github.mainstringargs.alpaca.enums.OrderTimeInForce;
import io.github.mainstringargs.alpaca.enums.OrderType;
import io.github.mainstringargs.alpaca.enums.PortfolioPeriodUnit;
import io.github.mainstringargs.alpaca.enums.PortfolioTimeFrame;
import io.github.mainstringargs.alpaca.properties.AlpacaProperties;
import io.github.mainstringargs.alpaca.rest.AlpacaRequest;
import io.github.mainstringargs.alpaca.rest.AlpacaRequestBuilder;
import io.github.mainstringargs.alpaca.rest.exception.AlpacaAPIRequestException;
import io.github.mainstringargs.alpaca.websocket.client.AlpacaWebsocketClient;
import io.github.mainstringargs.alpaca.websocket.listener.AlpacaStreamListener;
import io.github.mainstringargs.domain.alpaca.account.Account;
import io.github.mainstringargs.domain.alpaca.accountactivities.AccountActivity;
import io.github.mainstringargs.domain.alpaca.accountactivities.NonTradeActivity;
import io.github.mainstringargs.domain.alpaca.accountactivities.TradeActivity;
import io.github.mainstringargs.domain.alpaca.accountconfiguration.AccountConfiguration;
import io.github.mainstringargs.domain.alpaca.asset.Asset;
import io.github.mainstringargs.domain.alpaca.bar.Bar;
import io.github.mainstringargs.domain.alpaca.calendar.Calendar;
import io.github.mainstringargs.domain.alpaca.clock.Clock;
import io.github.mainstringargs.domain.alpaca.order.CancelledOrder;
import io.github.mainstringargs.domain.alpaca.order.Order;
import io.github.mainstringargs.domain.alpaca.portfoliohistory.PortfolioHistory;
import io.github.mainstringargs.domain.alpaca.position.ClosePositionOrder;
import io.github.mainstringargs.domain.alpaca.position.Position;
import io.github.mainstringargs.domain.alpaca.watchlist.Watchlist;
import io.github.mainstringargs.util.gson.GsonUtil;
import io.github.mainstringargs.util.time.TimeUtil;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaAPI {
    private static Logger LOGGER = LogManager.getLogger(AlpacaAPI.class);
    private final String apiVersion;
    private final String keyId;
    private final String baseAPIURL;
    private final AlpacaRequest alpacaRequest;
    private final String baseDataUrl;
    private final AlpacaWebsocketClient alpacaWebSocketClient;

    public AlpacaAPI() {
        this(AlpacaProperties.API_VERSION_VALUE, AlpacaProperties.KEY_ID_VALUE, AlpacaProperties.SECRET_VALUE, AlpacaProperties.BASE_API_URL_VALUE, AlpacaProperties.BASE_DATA_URL_VALUE);
        LOGGER.debug(AlpacaProperties.staticToString());
    }

    public AlpacaAPI(String apiVersion) {
        this(apiVersion, AlpacaProperties.KEY_ID_VALUE, AlpacaProperties.SECRET_VALUE, AlpacaProperties.BASE_API_URL_VALUE, AlpacaProperties.BASE_DATA_URL_VALUE);
    }

    public AlpacaAPI(String apiVersion, String keyId, String secret) {
        this(apiVersion, keyId, secret, AlpacaProperties.BASE_API_URL_VALUE, AlpacaProperties.BASE_DATA_URL_VALUE);
    }

    public AlpacaAPI(String apiVersion, String keyId, String secret, String baseAPIURL) {
        this(apiVersion, keyId, secret, baseAPIURL, AlpacaProperties.BASE_DATA_URL_VALUE);
    }

    public AlpacaAPI(String apiVersion, String keyId, String secret, String baseAPIURL, String baseDataUrl) {
        this.apiVersion = apiVersion;
        this.keyId = keyId;
        this.baseAPIURL = baseAPIURL;
        this.baseDataUrl = baseDataUrl;
        this.alpacaRequest = new AlpacaRequest(keyId, secret);
        this.alpacaWebSocketClient = new AlpacaWebsocketClient(keyId, secret, baseAPIURL);
        LOGGER.debug(this.toString());
    }

    public Account getAccount() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "account");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Account)this.alpacaRequest.getResponseObject(response, (Type)((Object)Account.class));
    }

    public ArrayList<AccountActivity> getAccountActivities(ZonedDateTime date, ZonedDateTime until, ZonedDateTime after, Direction direction, Integer pageSize, String pageToken, ActivityType ... activityTypes) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, "v2", "account", "activities");
        if (activityTypes != null) {
            if (activityTypes.length == 1) {
                urlBuilder.appendEndpoint(activityTypes[0].getAPIName());
            } else {
                urlBuilder.appendURLParameter("activity_types", Arrays.stream(activityTypes).map(ActivityType::getAPIName).collect(Collectors.joining(",")));
            }
        }
        if (date != null) {
            urlBuilder.appendURLParameter("date", date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (until != null) {
            urlBuilder.appendURLParameter("until", until.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (after != null) {
            urlBuilder.appendURLParameter("after", after.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (direction != null) {
            urlBuilder.appendURLParameter("direction", direction.getAPIName());
        }
        if (pageSize != null) {
            urlBuilder.appendURLParameter("page_size", pageSize.toString());
        }
        if (pageToken != null) {
            urlBuilder.appendURLParameter("page_token", pageToken);
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        JsonElement responseJsonElement = this.alpacaRequest.getResponseJSON(response);
        ArrayList<AccountActivity> accountActivities = new ArrayList<AccountActivity>();
        if (responseJsonElement instanceof JsonArray) {
            JsonArray responseJsonArray = (JsonArray)responseJsonElement;
            for (JsonElement arrayJsonElement : responseJsonArray) {
                if (arrayJsonElement instanceof JsonObject) {
                    JsonObject arrayJsonObject = (JsonObject)arrayJsonElement;
                    if (GsonUtil.doesGsonPOJOMatch(TradeActivity.class, arrayJsonObject)) {
                        accountActivities.add((AccountActivity)GsonUtil.GSON.fromJson((JsonElement)arrayJsonObject, TradeActivity.class));
                        continue;
                    }
                    if (GsonUtil.doesGsonPOJOMatch(NonTradeActivity.class, arrayJsonObject)) {
                        accountActivities.add((AccountActivity)GsonUtil.GSON.fromJson((JsonElement)arrayJsonObject, NonTradeActivity.class));
                        continue;
                    }
                    LOGGER.warn("Received unknown JSON Object in response!");
                    continue;
                }
                throw new IllegalStateException("All array elements must be objects!");
            }
            return accountActivities;
        }
        throw new IllegalStateException("The response must be an array!");
    }

    public AccountConfiguration getAccountConfiguration() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "account", "configurations");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (AccountConfiguration)this.alpacaRequest.getResponseObject(response, (Type)((Object)AccountConfiguration.class));
    }

    public AccountConfiguration setAccountConfiguration(AccountConfiguration accountConfiguration) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)accountConfiguration);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "account", "configurations");
        urlBuilder.setCustomBody(GsonUtil.GSON.toJson((Object)accountConfiguration));
        HttpResponse<InputStream> response = this.alpacaRequest.invokePatch(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (AccountConfiguration)this.alpacaRequest.getResponseObject(response, (Type)((Object)AccountConfiguration.class));
    }

    public ArrayList<Order> getOrders(OrderStatus status, Integer limit, ZonedDateTime after, ZonedDateTime until, Direction direction, Boolean nested) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders");
        if (status != null) {
            urlBuilder.appendURLParameter("status", status.getAPIName());
        }
        if (limit != null) {
            urlBuilder.appendURLParameter("limit", limit.toString());
        }
        if (after != null) {
            urlBuilder.appendURLParameter("after", after.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (until != null) {
            urlBuilder.appendURLParameter("until", until.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (direction != null) {
            urlBuilder.appendURLParameter("direction", direction.getAPIName());
        }
        if (nested != null) {
            urlBuilder.appendURLParameter("nested", nested.toString());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<Order>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public Order requestNewOrder(String symbol, Integer quantity, OrderSide side, OrderType type, OrderTimeInForce timeInForce, Double limitPrice, Double stopPrice, Boolean extendedHours, String clientOrderId, OrderClass orderClass, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)symbol);
        Preconditions.checkNotNull((Object)quantity);
        Preconditions.checkNotNull((Object)side);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)timeInForce);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders");
        urlBuilder.appendJSONBodyProperty("symbol", symbol);
        urlBuilder.appendJSONBodyProperty("qty", quantity.toString());
        urlBuilder.appendJSONBodyProperty("side", side.getAPIName());
        urlBuilder.appendJSONBodyProperty("type", type.getAPIName());
        urlBuilder.appendJSONBodyProperty("time_in_force", timeInForce.getAPIName());
        if (limitPrice != null) {
            urlBuilder.appendJSONBodyProperty("limit_price", TimeUtil.toDecimalFormat(limitPrice));
        }
        if (stopPrice != null) {
            urlBuilder.appendJSONBodyProperty("stop_price", TimeUtil.toDecimalFormat(stopPrice));
        }
        if (extendedHours != null) {
            urlBuilder.appendJSONBodyJSONProperty("extended_hours", (JsonElement)new JsonPrimitive(extendedHours));
        }
        if (clientOrderId != null) {
            urlBuilder.appendJSONBodyProperty("client_order_id", clientOrderId);
        }
        if (orderClass != null) {
            urlBuilder.appendJSONBodyProperty("order_class", orderClass.getAPIName());
        }
        if (takeProfitLimitPrice != null) {
            JsonObject takeProfit = new JsonObject();
            takeProfit.addProperty("limit_price", (Number)takeProfitLimitPrice);
            urlBuilder.appendJSONBodyJSONProperty("take_profit", (JsonElement)takeProfit);
        }
        if (stopLossStopPrice != null || stopLossLimitPrice != null) {
            JsonObject stopLoss = new JsonObject();
            if (stopLossStopPrice != null) {
                stopLoss.addProperty("stop_price", (Number)stopLossStopPrice);
            }
            if (stopLossLimitPrice != null) {
                stopLoss.addProperty("limit_price", (Number)stopLossLimitPrice);
            }
            urlBuilder.appendJSONBodyJSONProperty("stop_loss", (JsonElement)stopLoss);
        }
        if ((response = this.alpacaRequest.invokePost(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Order)this.alpacaRequest.getResponseObject(response, (Type)((Object)Order.class));
    }

    public Order requestNewMarketOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Boolean extendedHours) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.MARKET, timeInForce, null, null, extendedHours, null, OrderClass.SIMPLE, null, null, null);
    }

    public Order requestNewLimitOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double limitPrice, Boolean extendedHours) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.LIMIT, timeInForce, limitPrice, null, extendedHours, null, OrderClass.SIMPLE, null, null, null);
    }

    public Order requestNewStopOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double stopPrice, Boolean extendedHours) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.STOP, timeInForce, null, stopPrice, extendedHours, null, OrderClass.SIMPLE, null, null, null);
    }

    public Order requestNewStopLimitOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double limitPrice, Double stopPrice, Boolean extendedHours) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.STOP_LIMIT, timeInForce, limitPrice, stopPrice, extendedHours, null, OrderClass.SIMPLE, null, null, null);
    }

    public Order requestNewMarketBracketOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.MARKET, timeInForce, null, null, extendedHours, null, OrderClass.BRACKET, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order requestNewLimitBracketOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double limitPrice, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.LIMIT, timeInForce, limitPrice, null, extendedHours, null, OrderClass.BRACKET, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order requestNewOCOOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.LIMIT, timeInForce, null, null, extendedHours, null, OrderClass.OCO, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order requestNewOTOMarketOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.MARKET, timeInForce, null, null, extendedHours, null, OrderClass.OTO, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order requestNewOTOLimitOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double limitPrice, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.LIMIT, timeInForce, limitPrice, null, extendedHours, null, OrderClass.OTO, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order requestNewOTOStopOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double stopPrice, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.STOP, timeInForce, null, stopPrice, extendedHours, null, OrderClass.OTO, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order requestNewOTOStopLimitOrder(String symbol, Integer quantity, OrderSide side, OrderTimeInForce timeInForce, Double limitPrice, Double stopPrice, Boolean extendedHours, Double takeProfitLimitPrice, Double stopLossStopPrice, Double stopLossLimitPrice) throws AlpacaAPIRequestException {
        return this.requestNewOrder(symbol, quantity, side, OrderType.STOP_LIMIT, timeInForce, limitPrice, stopPrice, extendedHours, null, OrderClass.OTO, takeProfitLimitPrice, stopLossStopPrice, stopLossLimitPrice);
    }

    public Order getOrder(String orderID, Boolean nested) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)orderID);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders", orderID);
        if (nested != null) {
            urlBuilder.appendURLParameter("nested", nested.toString());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Order)this.alpacaRequest.getResponseObject(response, (Type)((Object)Order.class));
    }

    public Order getOrderByClientID(String clientOrderId) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)clientOrderId);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders:by_client_order_id");
        urlBuilder.appendURLParameter("client_order_id", clientOrderId);
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Order)this.alpacaRequest.getResponseObject(response, (Type)((Object)Order.class));
    }

    public Order replaceOrder(String orderID, Integer quantity, OrderTimeInForce timeInForce, Double limitPrice, Double stopPrice, String clientOrderId) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)orderID);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders", orderID);
        if (quantity != null) {
            urlBuilder.appendJSONBodyProperty("qty", quantity.toString());
        }
        if (timeInForce != null) {
            urlBuilder.appendJSONBodyProperty("time_in_force", timeInForce.getAPIName());
        }
        if (limitPrice != null) {
            urlBuilder.appendJSONBodyProperty("limit_price", TimeUtil.toDecimalFormat(limitPrice));
        }
        if (stopPrice != null) {
            urlBuilder.appendJSONBodyProperty("stop_price", TimeUtil.toDecimalFormat(stopPrice));
        }
        if (clientOrderId != null) {
            urlBuilder.appendJSONBodyProperty("client_order_id", clientOrderId);
        }
        if ((response = this.alpacaRequest.invokePatch(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Order)this.alpacaRequest.getResponseObject(response, (Type)((Object)Order.class));
    }

    public ArrayList<CancelledOrder> cancelAllOrders() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 207) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<CancelledOrder>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public boolean cancelOrder(String orderId) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)orderId);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "orders", orderId);
        HttpResponse<InputStream> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            throw new AlpacaAPIRequestException(response);
        }
        return response.getStatus() == 200 || response.getStatus() == 204;
    }

    public ArrayList<Position> getOpenPositions() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "positions");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<Position>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public Position getOpenPositionBySymbol(String symbol) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "positions", symbol.trim());
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Position)this.alpacaRequest.getResponseObject(response, (Type)((Object)Position.class));
    }

    public ArrayList<ClosePositionOrder> closeAllPositions() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "positions");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 207) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<ClosePositionOrder>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public Order closePosition(String symbol) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "positions", symbol);
        HttpResponse<InputStream> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Order)this.alpacaRequest.getResponseObject(response, (Type)((Object)Order.class));
    }

    public ArrayList<Asset> getAssets(AssetStatus assetStatus, String assetClass) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "assets");
        if (assetStatus != null) {
            urlBuilder.appendURLParameter("status", assetStatus.getAPIName());
        }
        if (assetClass != null) {
            urlBuilder.appendURLParameter("asset_class", assetClass.trim());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<Asset>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public Asset getAssetBySymbol(String symbolOrAssetID) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)symbolOrAssetID);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "assets", symbolOrAssetID.trim());
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Asset)this.alpacaRequest.getResponseObject(response, (Type)((Object)Asset.class));
    }

    public ArrayList<Watchlist> getWatchlists() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<Watchlist>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public Watchlist createWatchlist(String name, String ... symbols) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkState((name.length() <= 64 ? 1 : 0) != 0);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists");
        urlBuilder.appendJSONBodyProperty("name", name);
        if (symbols != null) {
            JsonArray symbolsArray = new JsonArray();
            Arrays.stream(symbols).forEach(arg_0 -> ((JsonArray)symbolsArray).add(arg_0));
            urlBuilder.appendJSONBodyJSONProperty("symbols", (JsonElement)symbolsArray);
        }
        if ((response = this.alpacaRequest.invokePost(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Watchlist)this.alpacaRequest.getResponseObject(response, (Type)((Object)Watchlist.class));
    }

    public Watchlist getWatchlist(String watchlistID) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)watchlistID);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists", watchlistID);
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Watchlist)this.alpacaRequest.getResponseObject(response, (Type)((Object)Watchlist.class));
    }

    public Watchlist updateWatchlist(String watchlistID, String name, String ... symbols) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)watchlistID);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists", watchlistID);
        if (name != null) {
            urlBuilder.appendJSONBodyProperty("name", name);
        }
        if (symbols != null) {
            JsonArray symbolsArray = new JsonArray();
            Arrays.stream(symbols).forEach(arg_0 -> ((JsonArray)symbolsArray).add(arg_0));
            urlBuilder.appendJSONBodyJSONProperty("symbols", (JsonElement)symbolsArray);
        }
        if ((response = this.alpacaRequest.invokePut(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Watchlist)this.alpacaRequest.getResponseObject(response, (Type)((Object)Watchlist.class));
    }

    public Watchlist addWatchlistAsset(String watchlistID, String symbol) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)watchlistID);
        Preconditions.checkNotNull((Object)symbol);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists", watchlistID);
        urlBuilder.appendJSONBodyProperty("symbol", symbol);
        HttpResponse<InputStream> response = this.alpacaRequest.invokePost(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Watchlist)this.alpacaRequest.getResponseObject(response, (Type)((Object)Watchlist.class));
    }

    public boolean deleteWatchlist(String watchlistID) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)watchlistID);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists", watchlistID);
        HttpResponse<InputStream> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            throw new AlpacaAPIRequestException(response);
        }
        return response.getStatus() == 200 || response.getStatus() == 204;
    }

    public Watchlist removeSymbolFromWatchlist(String watchlistID, String symbol) throws AlpacaAPIRequestException {
        Preconditions.checkNotNull((Object)watchlistID);
        Preconditions.checkNotNull((Object)symbol);
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "watchlists", watchlistID, symbol);
        HttpResponse<InputStream> response = this.alpacaRequest.invokeDelete(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Watchlist)this.alpacaRequest.getResponseObject(response, (Type)((Object)Watchlist.class));
    }

    public PortfolioHistory getPortfolioHistory(Integer periodLength, PortfolioPeriodUnit periodUnit, PortfolioTimeFrame timeFrame, LocalDate dateEnd, Boolean extendedHours) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "account", "portfolio", "history");
        if (periodLength != null && periodUnit != null) {
            urlBuilder.appendURLParameter("period", periodLength + periodUnit.getAPIName());
        }
        if (timeFrame != null) {
            urlBuilder.appendURLParameter("timeframe", timeFrame.getAPIName());
        }
        if (dateEnd != null) {
            urlBuilder.appendURLParameter("date_end", TimeUtil.toDateString(dateEnd));
        }
        if (extendedHours != null) {
            urlBuilder.appendURLParameter("extended_hours", extendedHours.toString());
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (PortfolioHistory)this.alpacaRequest.getResponseObject(response, (Type)((Object)PortfolioHistory.class));
    }

    public ArrayList<Calendar> getCalendar() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "calendar");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<Calendar>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public ArrayList<Calendar> getCalendar(LocalDate start, LocalDate end) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "calendar");
        if (start != null) {
            urlBuilder.appendURLParameter("start", TimeUtil.toDateString(start));
        }
        if (end != null) {
            urlBuilder.appendURLParameter("end", TimeUtil.toDateString(end));
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type arrayListType = new TypeToken<ArrayList<Calendar>>(){}.getType();
        return (ArrayList)this.alpacaRequest.getResponseObject(response, arrayListType);
    }

    public Clock getClock() throws AlpacaAPIRequestException {
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseAPIURL, this.apiVersion, "clock");
        HttpResponse<InputStream> response = this.alpacaRequest.invokeGet(urlBuilder);
        if (response.getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        return (Clock)this.alpacaRequest.getResponseObject(response, (Type)((Object)Clock.class));
    }

    public Map<String, ArrayList<Bar>> getBars(BarsTimeFrame timeframe, String symbol, Integer limit, ZonedDateTime start, ZonedDateTime end, ZonedDateTime after, ZonedDateTime until) throws AlpacaAPIRequestException {
        return this.getBars(timeframe, new String[]{symbol}, limit, start, end, after, until);
    }

    public Map<String, ArrayList<Bar>> getBars(BarsTimeFrame timeframe, String[] symbols, Integer limit, ZonedDateTime start, ZonedDateTime end, ZonedDateTime after, ZonedDateTime until) throws AlpacaAPIRequestException {
        HttpResponse<InputStream> response;
        AlpacaRequestBuilder urlBuilder = new AlpacaRequestBuilder(this.baseDataUrl, "v1", "bars");
        if (timeframe != null) {
            urlBuilder.appendEndpoint(timeframe.getAPIName());
        }
        if (symbols != null) {
            urlBuilder.appendURLParameter("symbols", String.join((CharSequence)",", symbols));
        }
        if (limit != null) {
            urlBuilder.appendURLParameter("limit", limit.toString());
        }
        if (start != null) {
            urlBuilder.appendURLParameter("start", start.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (end != null) {
            urlBuilder.appendURLParameter("end", end.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (after != null) {
            urlBuilder.appendURLParameter("after", after.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (until != null) {
            urlBuilder.appendURLParameter("until", until.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if ((response = this.alpacaRequest.invokeGet(urlBuilder)).getStatus() != 200) {
            throw new AlpacaAPIRequestException(response);
        }
        Type mapType = new TypeToken<Map<String, ArrayList<Bar>>>(){}.getType();
        return (Map)this.alpacaRequest.getResponseObject(response, mapType);
    }

    public void addAlpacaStreamListener(AlpacaStreamListener streamListener) {
        this.alpacaWebSocketClient.addListener(streamListener);
    }

    public void removeAlpacaStreamListener(AlpacaStreamListener streamListener) {
        this.alpacaWebSocketClient.removeListener(streamListener);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("apiVersion = " + this.apiVersion).add("baseAPIURL = " + this.baseAPIURL).add("baseDataUrl = " + this.baseDataUrl).add("keyId = " + this.keyId).toString();
    }
}

