/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.websocket.listener;

import io.github.mainstringargs.domain.polygon.websocket.PolygonStreamMessage;
import io.github.mainstringargs.polygon.websocket.listener.PolygonStreamListener;
import io.github.mainstringargs.polygon.websocket.message.PolygonStreamMessageType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PolygonStreamListenerAdapter
implements PolygonStreamListener {
    private Map<String, Set<PolygonStreamMessageType>> stockChannels = new HashMap<String, Set<PolygonStreamMessageType>>();

    public PolygonStreamListenerAdapter(String ticker, PolygonStreamMessageType ... channelTypes) {
        if (channelTypes != null && channelTypes.length > 0) {
            this.stockChannels.put(ticker, new HashSet<PolygonStreamMessageType>(Arrays.asList(channelTypes)));
        } else {
            this.stockChannels.put(ticker, new HashSet<PolygonStreamMessageType>(Arrays.asList(PolygonStreamMessageType.values())));
        }
    }

    public PolygonStreamListenerAdapter(Set<String> tickers, PolygonStreamMessageType ... channelTypes) {
        for (String ticker : tickers) {
            if (channelTypes != null && channelTypes.length > 0) {
                this.stockChannels.put(ticker, new HashSet<PolygonStreamMessageType>(Arrays.asList(channelTypes)));
                continue;
            }
            this.stockChannels.put(ticker, new HashSet<PolygonStreamMessageType>(Arrays.asList(PolygonStreamMessageType.values())));
        }
    }

    public PolygonStreamListenerAdapter(Map<String, Set<PolygonStreamMessageType>> stockChannels) {
        for (Map.Entry<String, Set<PolygonStreamMessageType>> entry : stockChannels.entrySet()) {
            this.stockChannels.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    @Override
    public Map<String, Set<PolygonStreamMessageType>> getStockChannels() {
        return this.stockChannels;
    }

    @Override
    public void onStreamUpdate(PolygonStreamMessageType streamMessageType, PolygonStreamMessage streamMessage) {
    }
}

