/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.util.doc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Documentation2JSONSchema {
    public static void printAlpacaHTMLWebDocAsJSONSchema(String alpacaDocXML) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        String nameXPath = "//span[" + Documentation2JSONSchema.xPathClassName("spec-name") + "]";
        String typeXPath = "//div[" + Documentation2JSONSchema.xPathClassName("spec-type") + "]";
        String descriptionXPath = "//div[" + Documentation2JSONSchema.xPathClassName("spec-desc") + "]";
        System.out.println(Documentation2JSONSchema.getSchemaFromDoc(alpacaDocXML, nameXPath, typeXPath, descriptionXPath));
    }

    public static void printPolygonHTMLWebDocAsJSONSchema(String polygonDocXML) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        String nameXPath = "//span[" + Documentation2JSONSchema.xPathClassName("propName") + "]";
        String typeXPath = "//span[" + Documentation2JSONSchema.xPathClassName("propType") + "]";
        String descriptionXPath = "//span[" + Documentation2JSONSchema.xPathClassName("propDesc") + "]";
        System.out.println(Documentation2JSONSchema.getSchemaFromDoc(polygonDocXML, nameXPath, typeXPath, descriptionXPath));
    }

    private static String getSchemaFromDoc(String docHTML, String nameXPath, String typeXPath, String descriptionXPath) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        String schemaJSON = "";
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(docHTML.getBytes()));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression propertyNamesXPath = xPath.compile(nameXPath);
        XPathExpression propertyTypesXPath = xPath.compile(typeXPath);
        XPathExpression propertyDescriptionsXPath = xPath.compile(descriptionXPath);
        NodeList propertyNameNodes = (NodeList)propertyNamesXPath.evaluate(document, XPathConstants.NODESET);
        NodeList propertyTypesNodes = (NodeList)propertyTypesXPath.evaluate(document, XPathConstants.NODESET);
        NodeList propertyDescriptionsNodes = (NodeList)propertyDescriptionsXPath.evaluate(document, XPathConstants.NODESET);
        for (int propertyIndex = 0; propertyIndex < propertyNameNodes.getLength(); ++propertyIndex) {
            String propertyName = propertyNameNodes.item(propertyIndex).getTextContent();
            String propertyType = propertyTypesNodes.item(propertyIndex).getTextContent();
            String propertyDescription = propertyDescriptionsNodes.item(propertyIndex).getTextContent();
            if (propertyDescription == null || propertyDescription.isEmpty()) {
                propertyDescription = propertyName;
            }
            schemaJSON = schemaJSON + "\"" + propertyName + "\": {\n";
            schemaJSON = schemaJSON + "\"existingJavaType\": \"" + Documentation2JSONSchema.parseDocTypeToSchemaJavaType(propertyType) + "\",\n";
            schemaJSON = schemaJSON + "\"title\": \"" + propertyDescription + "\"\n";
            schemaJSON = schemaJSON + "},\n";
        }
        return schemaJSON;
    }

    private static String parseDocTypeToSchemaJavaType(String docType) {
        if ((docType = docType.toLowerCase()).contains("string") || docType.contains("timestamp")) {
            return "java.lang.String";
        }
        if (docType.contains("boolean") || docType.contains("bool")) {
            return "java.lang.Boolean";
        }
        if (docType.contains("int") || docType.contains("integer")) {
            return "java.lang.Integer";
        }
        if (docType.contains("double") || docType.contains("float") || docType.contains("number")) {
            return "java.lang.Double";
        }
        return "UNKNOWN DOC DATA TYPE";
    }

    private static String xPathClassName(String className) {
        return String.format("contains(concat(' ',normalize-space(@class),' '),' %s ')", className);
    }
}

