/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file;

import com.queue.file.controller.ManualController;
import com.queue.file.sample.BulkReadSample;
import com.queue.file.sample.BulkWriterSample;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class TestMain {
    public static void main(String[] args) throws IOException {
        String fileName = "/Users/mz01-kibumkim/Desktop/DATA/queue/TestMain.fq";
        Path path = Paths.get(fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>(5);
        configMap.put("queue", fileName);
        configMap.put("manualCommitMode", 1);
        configMap.put("encryptMode", 1);
        configMap.put("compress", 1);
        ManualController controller = new ManualController(configMap);
        controller.open();
        Thread w1 = new Thread((Runnable)new BulkWriterSample(controller), "W1");
        Thread w2 = new Thread((Runnable)new BulkWriterSample(controller), "W2");
        Thread w3 = new Thread((Runnable)new BulkWriterSample(controller), "W3");
        Thread r1 = new Thread((Runnable)new BulkReadSample(controller), "R1");
        Thread r2 = new Thread((Runnable)new BulkReadSample(controller), "R2");
        Thread r3 = new Thread((Runnable)new BulkReadSample(controller), "R3");
        w1.start();
        w2.start();
        r1.start();
        r2.start();
    }
}

