/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.manager;

import com.google.gson.Gson;
import com.queue.file.processor.FileQueueHelper;
import com.queue.file.vo.FileQueueData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileQueueHelperManager {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Map<String, FileQueueHelper> HELPER_MAP = new HashMap<String, FileQueueHelper>();
    private static final FileQueueHelperManager instance = new FileQueueHelperManager();
    private final Gson gson = new Gson();

    public static FileQueueHelperManager getInstance() {
        return instance;
    }

    public synchronized void enrollHelper(String key, FileQueueHelper helper) {
        this.HELPER_MAP.put(key, helper);
    }

    public synchronized boolean openQueue(String queue) {
        FileQueueHelper helper = new FileQueueHelper(queue);
        if (this.getFileQueue(helper.getQUEUE()) != null) {
            this.logger.info("\ud050 \uc0dd\uc131 \uc2e4\ud328 - {} \ud050\uac00 \uc874\uc7ac \ud568", (Object)helper.getQUEUE());
            return false;
        }
        boolean isOk = helper.open();
        if (isOk) {
            this.HELPER_MAP.put(helper.getQUEUE(), helper);
        }
        return isOk;
    }

    public synchronized boolean openQueue(String queuePath, String queueName) {
        FileQueueHelper helper = new FileQueueHelper(queuePath, queueName);
        if (this.getFileQueue(helper.getQUEUE()) != null) {
            this.logger.info("\ud050 \uc0dd\uc131 \uc2e4\ud328 - {} \ud050\uac00 \uc874\uc7ac \ud568", (Object)helper.getQUEUE());
            return false;
        }
        boolean isOk = helper.open();
        if (isOk) {
            this.HELPER_MAP.put(helper.getQUEUE(), helper);
        }
        return isOk;
    }

    public synchronized boolean openQueue(Map<String, Object> config) {
        FileQueueHelper helper = new FileQueueHelper(config);
        if (this.getFileQueue(helper.getQUEUE()) != null) {
            this.logger.info("\ud050 \uc0dd\uc131 \uc2e4\ud328 - {} \ud050\uac00 \uc874\uc7ac \ud568", (Object)helper.getQUEUE());
            return false;
        }
        boolean isOk = helper.open();
        if (isOk) {
            this.HELPER_MAP.put(helper.getQUEUE(), helper);
        }
        return isOk;
    }

    private FileQueueHelper getFileQueue(String queuePath) {
        FileQueueHelper helper = this.HELPER_MAP.get(queuePath);
        if (helper != null && helper.isOk()) {
            return helper;
        }
        return null;
    }

    public synchronized void closeQueue(String queue) {
        FileQueueHelper helper = this.HELPER_MAP.remove(queue);
        if (helper != null) {
            helper.close();
        }
    }

    public synchronized boolean putData(String queue, Object object) {
        FileQueueHelper helper = this.getFileQueue(queue);
        if (helper == null) {
            this.logger.error("{} \uc9c0\uc815\ud55c \ud050\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc74c - \ub370\uc774\ud130 \uc785\ub825 \uc2e4\ud328", (Object)queue);
            return false;
        }
        return helper.putData(object);
    }

    public synchronized int putDataList(String queue, List<Object> dataList) {
        int insertCnt = 0;
        FileQueueHelper helper = this.getFileQueue(queue);
        if (helper == null) {
            this.logger.error("{} \uc9c0\uc815\ud55c \ud050\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc74c - \ub370\uc774\ud130 \uc785\ub825 \uc2e4\ud328", (Object)queue);
            return -1;
        }
        insertCnt = helper.putDataList(dataList);
        return insertCnt;
    }

    public synchronized FileQueueData getData(String queuePath) {
        FileQueueData data = null;
        FileQueueHelper helper = this.getFileQueue(queuePath);
        if (helper == null) {
            return null;
        }
        data = helper.getData();
        return data;
    }

    public synchronized List<FileQueueData> getDataList(String queuePath, int count) {
        ArrayList<FileQueueData> dataList = new ArrayList();
        FileQueueHelper helper = this.getFileQueue(queuePath);
        if (helper == null) {
            return null;
        }
        dataList = helper.getDataList(count);
        return dataList;
    }

    public int getAllDataCount() {
        int totalCnt = 0;
        for (Map.Entry<String, FileQueueHelper> entry : this.HELPER_MAP.entrySet()) {
            FileQueueHelper h = entry.getValue();
            totalCnt += h.getDataCount();
        }
        return totalCnt;
    }

    public String getAllDataCountDetail() {
        HashMap<String, Map<String, String>> dataMap = new HashMap<String, Map<String, String>>(this.HELPER_MAP.size());
        for (Map.Entry<String, FileQueueHelper> entry : this.HELPER_MAP.entrySet()) {
            FileQueueHelper helper = entry.getValue();
            dataMap.put(helper.getQUEUE_NAME(), helper.getSummaryMapData());
        }
        return this.gson.toJson(dataMap);
    }

    public Map<String, Map<String, String>> getAllDataDetail() {
        HashMap<String, Map<String, String>> summaryMap = new HashMap<String, Map<String, String>>(this.HELPER_MAP.size());
        for (Map.Entry<String, FileQueueHelper> entry : this.HELPER_MAP.entrySet()) {
            FileQueueHelper helper = entry.getValue();
            summaryMap.put(helper.getQUEUE_NAME(), helper.getSummaryMapData());
        }
        return summaryMap;
    }

    public int getDataCount(String queuePath) {
        int dataCnt = 0;
        FileQueueHelper helper = this.getFileQueue(queuePath);
        if (helper == null) {
            return -1;
        }
        dataCnt = helper.getDataCount();
        return dataCnt;
    }

    public List<FileQueueData> closeCheckSum(String queuePath) {
        FileQueueHelper helper = this.getFileQueue(queuePath);
        if (helper == null) {
            return null;
        }
        return helper.closeCheckSum();
    }

    public List<String> removePoorData(String queuePath) {
        FileQueueHelper helper = this.getFileQueue(queuePath);
        if (helper == null) {
            return null;
        }
        return helper.removePoorData();
    }

    public int clearQueue(String queuePath) {
        FileQueueHelper helper = this.getFileQueue(queuePath);
        if (helper == null) {
            return -1;
        }
        return helper.clear();
    }
}

