/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.processor;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.queue.file.vo.FileQueueData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileQueueHelper {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Gson gson = new Gson();
    private MVStore store = null;
    private boolean manualCommitMode = false;
    private boolean encryptMode = false;
    private boolean readOnlyMode = false;
    private boolean compressMode = false;
    private boolean restoreMode = false;
    private MVMap<Long, String> dataMap = null;
    private final List<Long> keyList = new ArrayList<Long>();
    private final Map<String, List<Long>> KEY_MAP = new HashMap<String, List<Long>>();
    private final AtomicLong atomicIndex = new AtomicLong(1L);
    private final String QUEUE;
    private final String QUEUE_PATH;
    private final String QUEUE_NAME;
    private final String ENCRYPT_KEY = "ENCRYPT_KEY";
    private final int HINT_INDEX = 0;
    private final int TIME_INDEX = 1;
    private final int DATA_INDEX = 2;
    private final String HINT_FIELD = "FROM_ENV";
    private long openTime = 0L;
    private long lastInTime = 0L;
    private long lastOutTime = 0L;
    private long inputCnt = 0L;
    private long outputCnt = 0L;

    public FileQueueHelper(String queue) {
        this.QUEUE = queue;
        int index = 0;
        if (StringUtils.isNotBlank((CharSequence)queue)) {
            index = queue.lastIndexOf(File.separator);
        }
        this.QUEUE_PATH = index > 0 ? queue.substring(0, index) : "";
        this.QUEUE_NAME = index > 0 ? queue.substring(index + 1) : "";
    }

    public FileQueueHelper(String queuePath, String queueName) {
        this.QUEUE = queuePath + (queuePath.endsWith(File.separator) ? "" : File.separator) + queueName;
        this.QUEUE_PATH = queuePath;
        this.QUEUE_NAME = queueName;
    }

    public FileQueueHelper(Map<String, Object> config) {
        String name;
        String queue = config.get("queue") != null ? (String)config.get("queue") : "";
        String path = config.get("path") != null ? (String)config.get("path") : "";
        String string = name = config.get("name") != null ? (String)config.get("name") : "";
        if (StringUtils.isBlank((CharSequence)queue)) {
            queue = path + (path.endsWith(File.separator) ? "" : File.separator) + name;
        } else {
            int index = queue.lastIndexOf(File.separator);
            path = index > 0 ? queue.substring(0, index) : "";
            name = index > 0 ? queue.substring(index + 1) : "";
        }
        this.QUEUE = queue;
        this.QUEUE_PATH = path;
        this.QUEUE_NAME = name;
        if (config.get("manualCommitMode") != null) {
            this.manualCommitMode = true;
        }
        if (config.get("encryptMode") != null) {
            this.encryptMode = true;
        }
        if (config.get("readOnly") != null) {
            this.readOnlyMode = true;
        }
        if (config.get("compress") != null) {
            this.compressMode = true;
        }
    }

    public synchronized boolean open() {
        this.keyList.clear();
        if (StringUtils.isBlank((CharSequence)this.QUEUE_PATH)) {
            this.logger.error("\uc785\ub825\ub41c \ud344\uc77c \ud050 \uc704\uce58 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.QUEUE_NAME)) {
            this.logger.error("\uc785\ub825\ub41c \ud344\uc77c \ud050 \uc774\ub984 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return false;
        }
        Path p = Paths.get(this.QUEUE_PATH, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            try {
                Files.createFile(p, new FileAttribute[0]);
                this.logger.info("\ud344\uc77c \ud050 \uc800\uc7a5 \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 - {}", (Object)this.QUEUE_PATH);
            }
            catch (IOException e) {
                this.logger.error("\ud344\uc77c \ud050 \uc800\uc7a5 \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131({}) \uc911 \uc5d0\ub7ec \ubc1c\uc0dd:{}", (Object)this.QUEUE_PATH, (Object)e);
                return false;
            }
        }
        if (Files.exists(Paths.get(this.QUEUE, new String[0]), new LinkOption[0])) {
            this.restoreMode = true;
        }
        try {
            this.store = this.openQueue();
            if (this.store == null || this.store.isClosed()) {
                return false;
            }
            if (this.restoreMode) {
                for (String mapName : this.store.getMapNames()) {
                    this.reStoreKey(mapName, (MVMap<Long, String>)this.store.openMap(mapName));
                }
            }
            this.dataMap = this.store.openMap(this.QUEUE_NAME);
            this.openTime = System.currentTimeMillis();
            this.reStoreKey(this.dataMap);
        }
        catch (Exception e) {
            this.logger.error(this.QUEUE_PATH + " \uc624\ud508 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd:" + e);
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.store != null) {
            this.store.close();
        }
        if (this.keyList != null) {
            this.keyList.clear();
        }
    }

    public synchronized void closeImmediately() {
        if (this.store != null) {
            this.store.closeImmediately();
        }
        if (this.keyList != null) {
            this.keyList.clear();
        }
    }

    public synchronized boolean putData(Object object) {
        if (object == null) {
            return true;
        }
        this.reStoreKey(this.dataMap);
        long index = this.getIndex();
        String hint = this.extractHint(object);
        String data = this.gson.toJson(object);
        long now = System.currentTimeMillis();
        this.keyList.add(index);
        ++this.inputCnt;
        this.lastInTime = now;
        return true;
    }

    public synchronized int putDataList(List<Object> dataList) {
        this.reStoreKey(this.dataMap);
        int insertCnt = 0;
        long now = System.currentTimeMillis();
        for (Object object : dataList) {
            long index = this.getIndex();
            String hint = this.extractHint(object);
            String data = this.gson.toJson(object);
            this.keyList.add(index);
            ++insertCnt;
        }
        if (!this.manualCommitMode) {
            this.store.commit();
        }
        this.lastInTime = now;
        this.inputCnt += (long)insertCnt;
        return insertCnt;
    }

    public synchronized FileQueueData getData() {
        FileQueueData fData = null;
        if (this.dataMap.size() <= 0) {
            return null;
        }
        this.reStoreKey(this.dataMap);
        String data = null;
        Long key = this.keyList.remove(0);
        data = (String)this.dataMap.remove((Object)key);
        if (data == null) {
            return null;
        }
        this.lastOutTime = System.currentTimeMillis();
        ++this.outputCnt;
        return fData;
    }

    public synchronized List<FileQueueData> getDataList(int count) {
        ArrayList<FileQueueData> dataList = new ArrayList<FileQueueData>();
        if (this.dataMap.size() <= 0) {
            return dataList;
        }
        this.reStoreKey(this.dataMap);
        int loopCnt = count > this.keyList.size() ? this.keyList.size() : count;
        Object fData = null;
        for (int i = 0; i < loopCnt; ++i) {
            Long key = this.keyList.remove(0);
            String data = (String)this.dataMap.remove((Object)key);
            if (!StringUtils.isNotBlank((CharSequence)data)) continue;
            dataList.add((FileQueueData)fData);
            ++this.outputCnt;
        }
        if (!this.manualCommitMode) {
            this.store.commit();
        }
        this.lastOutTime = System.currentTimeMillis();
        return dataList;
    }

    public int getDataCount() {
        return this.dataMap.size();
    }

    public List<FileQueueData> closeCheckSum() {
        ArrayList<FileQueueData> dataList = new ArrayList<FileQueueData>();
        if (this.dataMap.size() <= 0) {
            return dataList;
        }
        Object fData = null;
        for (Map.Entry element : this.dataMap.entrySet()) {
            String string = (String)element.getValue();
        }
        return dataList;
    }

    public synchronized List<String> removePoorData() {
        ArrayList<String> dataList = new ArrayList<String>();
        Iterator iter = this.dataMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Long key = (Long)entry.getKey();
            String data = (String)entry.getValue();
            try {
                this.gson.fromJson(data, JsonObject.class);
            }
            catch (Exception e) {
                this.keyList.remove(key);
                iter.remove();
                dataList.add(data);
            }
        }
        if (!this.manualCommitMode) {
            this.store.commit();
        }
        return dataList;
    }

    public synchronized int clear() {
        int count = this.dataMap.size();
        this.dataMap.clear();
        this.keyList.clear();
        if (!this.manualCommitMode) {
            this.store.commit();
        }
        return count;
    }

    public boolean isOk() {
        return this.store != null && !this.store.isClosed() && this.dataMap != null;
    }

    private MVStore openQueue() {
        if (this.store == null || this.store.isClosed()) {
            HashMap<String, Object> configMap = new HashMap<String, Object>(5);
            configMap.put("fileName", this.QUEUE);
            if (this.manualCommitMode) {
                configMap.put("autoCommitDelay", 0);
            }
            if (this.readOnlyMode) {
                configMap.put("readOnly", 1);
            }
            if (this.compressMode) {
                configMap.put("compress", 1);
            }
            try {
                String configInfo = DataUtils.appendMap((StringBuilder)new StringBuilder(), configMap).toString();
                new MVStore.Builder();
                MVStore.Builder builder = MVStore.Builder.fromString((String)configInfo);
                if (this.encryptMode) {
                    builder.encryptionKey("ENCRYPT_KEY".toCharArray());
                }
                this.logger.debug("\ud30c\uc77c \ud050 \uc124\uc815 \uc815\ubcf4 : {}", (Object)builder.toString());
                this.store = builder.open();
            }
            catch (Exception e) {
                this.logger.error("{} \ud30c\uc77c \ud050 \uc624\ud508 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd:{}", (Object)this.QUEUE, (Object)e);
                return null;
            }
        }
        return this.store;
    }

    private long getIndex() {
        long index = this.atomicIndex.getAndIncrement();
        if (index >= Long.MAX_VALUE) {
            index = 1L;
            this.atomicIndex.set(index);
        }
        return index;
    }

    private void reStoreKey(String keyName, MVMap<Long, String> map) {
        ArrayList<Long> keyList = new ArrayList<Long>(map.size());
        this.KEY_MAP.put(keyName, keyList);
        int mapSize = map.size();
        int listSize = keyList.size();
        int diffCnt = mapSize - listSize;
        if (diffCnt == 0) {
            return;
        }
        for (Long k : map.keySet()) {
            keyList.add(k);
        }
        Collections.sort(keyList, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o1 > o2 ? 1 : -1;
            }
        });
        if (diffCnt < 0) {
            diffCnt *= -1;
        }
        this.logger.warn("KEY DATA:" + listSize + ", QUEUE DATA:" + mapSize + ", \ub370\uc774\ud130 \ub3d9\uae30\ud654(" + diffCnt + "\uac74)\ub85c \uc9c4\ud589");
    }

    private void reStoreKey(MVMap<Long, String> map) {
        int listSize;
        int mapSize = map.size();
        int diffCnt = mapSize - (listSize = this.keyList.size());
        if (diffCnt == 0) {
            return;
        }
        for (Long k : map.keySet()) {
            this.keyList.add(k);
        }
        Collections.sort(this.keyList, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o1 > o2 ? 1 : -1;
            }
        });
        if (diffCnt < 0) {
            diffCnt *= -1;
        }
        this.logger.warn("KEY DATA:" + listSize + ", QUEUE DATA:" + mapSize + ", \ub370\uc774\ud130 \ub3d9\uae30\ud654(" + diffCnt + "\uac74)\ub85c \uc9c4\ud589");
    }

    public String extractHint(Object object) {
        String hint = "";
        Class<?> classObject = object.getClass();
        List<Field> fields = this.getAllFields(classObject);
        for (Field f : fields) {
            f.setAccessible(true);
            String name = f.getName();
            try {
                if (!name.equals("FROM_ENV")) continue;
                hint = f.get(object) == null ? "" : f.get(object).toString();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hint;
    }

    public synchronized void commit() {
        try {
            if (this.store == null) {
                this.logger.error("{} \uc9c0\uc815\ub41c \ud050\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc74c - \ud050 Commit \uc2e4\ud328", (Object)this.QUEUE);
                return;
            }
            this.store.commit();
            this.logger.info("{} \ubc1c\uc1a1\ud30c\uc77c\ud050 commit", (Object)this.QUEUE);
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    public synchronized void rollback() {
        try {
            if (this.store == null) {
                this.logger.error("{} \uc9c0\uc815\ub41c \ud050\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc74c - \ud050 Rollback \uc2e4\ud328", (Object)this.QUEUE);
                return;
            }
            this.store.rollback();
            this.logger.info("{} \ubc1c\uc1a1\ud30c\uc77c\ud050 rollback", (Object)this.QUEUE);
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    public Map<String, String> getSummaryMapData() {
        HashMap<String, String> summaryMap = new HashMap<String, String>();
        summaryMap.put("QUEUE_NAME", "" + this.getQUEUE_NAME());
        summaryMap.put("QUEUE_PATH", "" + this.getQUEUE_PATH());
        summaryMap.put("CREATE_TIME", "" + this.getOpenTime());
        summaryMap.put("INPUT", "" + this.getInputCnt());
        summaryMap.put("OUTPUT", "" + this.getOutputCnt());
        summaryMap.put("LAST_INPUT_TIME", "" + this.getLastInTime());
        summaryMap.put("LAST_OUTPUT_TIME", "" + this.getLastOutTime());
        return summaryMap;
    }

    private List<Field> getAllFields(Class clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(this.getAllFields(clazz.getSuperclass()));
        List filteredFields = Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toList());
        result.addAll(filteredFields);
        return result;
    }

    public String getQUEUE() {
        return this.QUEUE;
    }

    public String getQUEUE_NAME() {
        return this.QUEUE_NAME;
    }

    public String getQUEUE_PATH() {
        return this.QUEUE_PATH;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public long getLastInTime() {
        return this.lastInTime;
    }

    public long getLastOutTime() {
        return this.lastOutTime;
    }

    public long getInputCnt() {
        return this.inputCnt;
    }

    public long getOutputCnt() {
        return this.outputCnt;
    }
}

