/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.vo;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FileQueueData
implements Serializable {
    private static final Gson gson = new Gson();
    private String partition = "";
    private String tag = "";
    private long groupTransactionKey;
    private long transactionKey;
    private long createTime;
    private Map<String, Object> data;

    public FileQueueData(Map<String, Object> data) {
        this.data = data;
        this.createTime = System.currentTimeMillis();
    }

    public FileQueueData(long transactionKey, long createTime) {
        this.transactionKey = transactionKey;
        this.createTime = createTime;
    }

    public FileQueueData(long transactionKey, Map<String, Object> data) {
        this.transactionKey = transactionKey;
        this.data = data;
        this.createTime = System.currentTimeMillis();
    }

    public FileQueueData(String tag, Map<String, Object> data) {
        this.tag = tag;
        this.data = data;
        this.createTime = System.currentTimeMillis();
    }

    public FileQueueData(String partition, String tag, Map<String, Object> data) {
        this.partition = partition;
        this.tag = tag;
        this.data = data;
        this.createTime = System.currentTimeMillis();
    }

    public FileQueueData(String partition, String tag, Map<String, Object> data, String time) {
        this.partition = partition;
        this.tag = tag;
        this.data = data;
        this.createTime = StringUtils.isBlank((CharSequence)time) ? System.currentTimeMillis() : Long.parseLong(time.replaceAll("\\D", "0"));
    }

    public String getPartition() {
        return this.partition;
    }

    public String getTag() {
        return this.tag;
    }

    public Long getTransactionKey() {
        return this.transactionKey;
    }

    public void setTransactionKey(Long transactionKey) {
        this.transactionKey = transactionKey;
    }

    public Long getGroupTransactionKey() {
        return this.groupTransactionKey;
    }

    public void setGroupTransactionKey(Long groupTransactionKey) {
        this.groupTransactionKey = groupTransactionKey;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static boolean isValid(String lowData) {
        return !StringUtils.isBlank((CharSequence)lowData) && lowData.startsWith("@{") && lowData.endsWith("}@");
    }

    public String toString() {
        return "@" + gson.toJson((Object)this) + "@";
    }

    public static FileQueueData fromString(String lowData) {
        if (!FileQueueData.isValid(lowData)) {
            return null;
        }
        String data = lowData.substring(1, lowData.length() - 1);
        return (FileQueueData)gson.fromJson(data, FileQueueData.class);
    }
}

