/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.manager;

import com.queue.file.controller.Controller;
import com.queue.file.controller.ManualController;
import com.queue.file.vo.FileQueueBuilder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlManager {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Map<String, Controller> CONTROL_MAP = new HashMap<String, Controller>();

    public synchronized Controller openQueue(FileQueueBuilder builder) {
        if (builder == null || builder.getConfig() == null) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \uc0ac\uc720: \ud050 \uc124\uc815 \uc815\ubcf4 NULL");
            return null;
        }
        return this.openQueue(builder.getConfig());
    }

    public synchronized Controller openQueue(Map<String, Object> config) {
        ManualController controller = new ManualController(config);
        if (!controller.validate()) {
            return null;
        }
        String queueName = controller.getQueueName();
        if (this.getController(queueName) != null) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050 \uc774\ub984: [{}], \uc0ac\uc720: \ud050 \uc774\ub984 \uc911\ubcf5", (Object)queueName);
            return null;
        }
        if (!controller.open()) {
            return null;
        }
        this.CONTROL_MAP.put(queueName, controller);
        return controller;
    }

    public Controller getController(String queueName) {
        Controller helper = this.CONTROL_MAP.get(queueName);
        if (helper != null && helper.isOk()) {
            return helper;
        }
        return null;
    }

    public void closeAll() {
        for (String queueName : this.CONTROL_MAP.keySet()) {
            this.close(queueName);
        }
    }

    public void close(String queueName) {
        Controller controller = this.CONTROL_MAP.get(queueName);
        if (controller != null) {
            controller.close();
        }
    }
}

