/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.sample;

import com.queue.file.controller.Controller;
import com.queue.file.exception.QueueReadException;
import com.queue.file.vo.FileQueueData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadThrowSample
implements Runnable {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Controller controller;
    private boolean isRun = true;

    public ReadThrowSample(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void run() {
        boolean loopCnt = true;
        String name = Thread.currentThread().getName();
        while (this.controller.isOk() && this.isRun) {
            try {
                List<FileQueueData> fDataList = this.controller.read(name);
                Thread.sleep(500L);
                if (fDataList == null) continue;
                for (FileQueueData fData : fDataList) {
                    this.logger.info("<\ub370\uc774\ud130 \ud655\uc778> - \ub370\uc774\ud130: [{}]", (Object)fData);
                }
                this.controller.readCommit(name);
            }
            catch (InterruptedException e) {
                this.isRun = false;
            }
            catch (QueueReadException e) {
                this.isRun = false;
                throw new RuntimeException(e);
            }
        }
    }
}

