/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller;

import com.queue.file.controller.Controller;
import com.queue.file.exception.InitializeException;
import com.queue.file.exception.QueueReadException;
import com.queue.file.exception.QueueWriteException;
import com.queue.file.vo.FileQueueData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualController
implements Controller {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private MVStore store = null;
    private boolean manualCommitMode = true;
    private boolean encryptMode = false;
    private boolean readOnlyMode = false;
    private boolean compressMode = false;
    private boolean restoreMode = false;
    private final int MAX_READER;
    private final int LIMIT_SIZE;
    private final Semaphore readSema;
    private final Semaphore dataSema = new Semaphore(1, true);
    private MVMap<Long, String> dataMap = null;
    private MVMap<String, List<FileQueueData>> readBufferMap = null;
    private final List<Long> dataKeyList = new ArrayList<Long>();
    private final AtomicLong transactionIndex = new AtomicLong(1L);
    private final AtomicLong groupIndex = new AtomicLong(1L);
    private final String QUEUE;
    private final String QUEUE_PATH;
    private final String QUEUE_NAME;
    private final String ENCRYPT_KEY = "ENCRYPT_KEY";
    private final String READ_BUFFER = "READ_BUFFER_";
    private long openTime = 0L;
    private long lastInTime = 0L;
    private long lastOutTime = 0L;
    private final AtomicLong INPUT_COUNT = new AtomicLong(0L);
    private final AtomicLong OUTPUT_COUNT = new AtomicLong(0L);

    public ManualController(String queue) {
        this.QUEUE = queue;
        int index = 0;
        if (StringUtils.isNotBlank((CharSequence)queue)) {
            index = queue.lastIndexOf(File.separator);
        }
        this.QUEUE_PATH = index > 0 ? queue.substring(0, index) : "";
        this.QUEUE_NAME = index > 0 ? queue.substring(index + 1) : "";
        this.MAX_READER = 1;
        this.LIMIT_SIZE = 0;
        this.readSema = new Semaphore(this.MAX_READER, true);
    }

    public ManualController(String queuePath, String queueName) {
        this.QUEUE = queuePath + (queuePath.endsWith(File.separator) ? "" : File.separator) + queueName;
        this.QUEUE_PATH = queuePath;
        this.QUEUE_NAME = queueName;
        this.MAX_READER = 1;
        this.LIMIT_SIZE = 0;
        this.readSema = new Semaphore(this.MAX_READER, true);
    }

    public ManualController(Map<String, Object> config) {
        int var;
        String name;
        String queue = config.get("queue") != null ? (String)config.get("queue") : "";
        String path = config.get("path") != null ? (String)config.get("path") : "";
        String string = name = config.get("name") != null ? (String)config.get("name") : "";
        if (StringUtils.isBlank((CharSequence)queue)) {
            queue = path + (path.endsWith(File.separator) ? "" : File.separator) + name;
        } else {
            int index = queue.lastIndexOf(File.separator);
            path = index > 0 ? queue.substring(0, index) : "";
            name = index > 0 ? queue.substring(index + 1) : "";
        }
        this.QUEUE = queue;
        this.QUEUE_PATH = path;
        this.QUEUE_NAME = name;
        if (config.get("manualCommitMode") != null) {
            this.manualCommitMode = true;
        }
        if (config.get("encryptMode") != null) {
            this.encryptMode = true;
        }
        if (config.get("readOnly") != null) {
            this.readOnlyMode = true;
        }
        if (config.get("compress") != null) {
            this.compressMode = true;
        }
        int limit = 0;
        int multiRead = 1;
        if (config.get("limit") != null && (var = ((Integer)config.get("limit")).intValue()) > 0) {
            limit = var;
        }
        if (config.get("multiRead") != null && (var = ((Integer)config.get("multiRead")).intValue()) > 1) {
            multiRead = var;
        }
        this.LIMIT_SIZE = limit;
        this.MAX_READER = multiRead;
        this.readSema = new Semaphore(this.MAX_READER, true);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isBlank((CharSequence)this.QUEUE_PATH)) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050 \uc815\ubcf4:[{}], \ud050 \uc704\uce58 \uc815\ubcf4 \uc5c6\uc74c", (Object)this.QUEUE);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.QUEUE_NAME)) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050 \uc815\ubcf4:[{}], \ud050 \uc774\ub984 \uc815\ubcf4 \uc5c6\uc74c", (Object)this.QUEUE);
            return false;
        }
        if (this.QUEUE_NAME.startsWith("READ_BUFFER_")) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = [{}] \uc811\ub450\uc5b4\ub294 \uc0ac\uc6a9 \ubd88\uac00", (Object)"READ_BUFFER_");
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean open() {
        if (!this.validate()) {
            return false;
        }
        Path p = Paths.get(this.QUEUE_PATH, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            try {
                Files.createFile(p, new FileAttribute[0]);
                this.logger.info("<\ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 : \uc131\uacf5> = \uacbd\ub85c \uc815\ubcf4:[{}]", (Object)this.QUEUE_PATH);
            }
            catch (IOException e) {
                this.logger.error("<\ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 : \uc2e4\ud328> = \uacbd\ub85c \uc815\ubcf4:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_PATH, (Object)e);
                return false;
            }
        }
        if (Files.exists(Paths.get(this.QUEUE, new String[0]), new LinkOption[0])) {
            this.restoreMode = true;
            this.logger.debug("<\ud050 \ud65c\uc131\ud654 : \uc815\ubcf4> = \ud050 \uc774\ub984:[{}], \ubcf5\uad6c \ubaa8\ub4dc \ud65c\uc131\ud654", (Object)this.QUEUE_NAME);
        }
        try {
            this.store = this.openQueue();
            if (this.store == null || this.store.isClosed()) {
                return false;
            }
            this.readBufferMap = this.store.openMap("READ_BUFFER_" + this.QUEUE_NAME);
            this.dataMap = this.store.openMap(this.QUEUE_NAME);
            if (!this.isOk()) {
                this.logger.info("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050:[{}]", (Object)this.QUEUE_NAME);
            }
            this.openTime = System.currentTimeMillis();
            if (this.restoreMode) {
                this.realignData();
                long dataMaxKey = this.realignKey(this.dataKeyList, this.dataMap);
                if (dataMaxKey > 0L) {
                    this.transactionIndex.set(dataMaxKey + 1001L);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_NAME, (Object)e.toString());
            return false;
        }
        return true;
    }

    private MVStore openQueue() {
        if (this.store == null || this.store.isClosed()) {
            HashMap<String, Object> configMap = new HashMap<String, Object>(5);
            configMap.put("fileName", this.QUEUE);
            if (this.manualCommitMode) {
                configMap.put("autoCommitDelay", 0);
            }
            if (this.readOnlyMode) {
                configMap.put("readOnly", 1);
            }
            if (this.compressMode) {
                configMap.put("compress", 1);
            }
            try {
                String configInfo = DataUtils.appendMap((StringBuilder)new StringBuilder(), configMap).toString();
                new MVStore.Builder();
                MVStore.Builder builder = MVStore.Builder.fromString((String)configInfo);
                if (this.encryptMode) {
                    builder.encryptionKey("ENCRYPT_KEY".toCharArray());
                }
                this.store = builder.open();
                this.logger.info("<\ud050 \uc624\ud508 : \uc131\uacf5> = \ud050:[{}], \ud050 \uc124\uc815 \uc815\ubcf4 :[{}]", (Object)this.QUEUE_NAME, (Object)builder.toString());
            }
            catch (Exception e) {
                this.logger.error("<\ud050 \uc624\ud508 : \uc2e4\ud328> = \ud050:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_NAME, (Object)e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
        return this.store;
    }

    @Override
    public void realignData() throws InitializeException {
        try {
            this.dataSema.acquire();
            this.readSema.acquire(this.MAX_READER);
            int targetDataSize = this.readBufferMap.size();
            if (targetDataSize > 0) {
                for (String threadName : this.readBufferMap.keySet()) {
                    List fileQueueDataList = (List)this.readBufferMap.remove((Object)threadName);
                    for (FileQueueData fData : fileQueueDataList) {
                        this.dataKeyList.add(fData.getTransactionKey());
                        this.dataMap.put((Object)fData.getTransactionKey(), (Object)fData.toString());
                    }
                }
                this.logger.info("<\ud050 \ub370\uc774\ud130 \uc774\uad00 : \uc131\uacf5> = \ud050:[{}], \uc774\uad00 \uc77d\uae30 \ubc84\ud37c \ub370\uc774\ud130 \uac2f\uc218:[{}]", (Object)this.QUEUE_NAME, (Object)targetDataSize);
                this.store.commit();
            }
        }
        catch (Exception e) {
            this.store.rollback();
            throw new InitializeException("<\ud050 \ub370\uc774\ud130 \uc815\ub82c : \uc2e4\ud328> = \ud050 \ub864\ubc31 \uc218\ud589, \ud050:[" + this.QUEUE_NAME + "]", e);
        }
        finally {
            this.dataSema.release();
            this.readSema.release(this.MAX_READER);
        }
    }

    @Override
    public long realignKey(List<Long> keyList, MVMap<Long, String> dataMap) {
        int mapSize = dataMap.size();
        int listSize = keyList.size();
        int diffCnt = mapSize - listSize;
        long maxKey = 0L;
        if (diffCnt != 0) {
            keyList.clear();
            for (Long k : dataMap.keySet()) {
                keyList.add(k);
            }
            Collections.sort(keyList, (a, b) -> a.compareTo((Long)b));
            if (diffCnt < 0) {
                diffCnt *= -1;
            }
            if (keyList.size() > 0) {
                maxKey = keyList.get(keyList.size() - 1);
            }
            this.logger.info("<\ud050 \uc815\ubcf4 \ub3d9\uae30\ud654 : \uc131\uacf5> = \ud050\uba85:[{}], \ucd08\uae30 KEY \uac2f\uc218:[{}], \ucd08\uae30 DATA \ud654\uac2f\uc218:[{}], \ub3d9\uae30\ud654 \uac74\uc218:[{}]", new Object[]{this.QUEUE_NAME, listSize, mapSize, diffCnt});
        }
        return maxKey;
    }

    @Override
    public void write(Map<String, Object> dataMap) throws QueueWriteException {
        if (ObjectUtils.isEmpty(dataMap)) {
            return;
        }
        long transactionKey = this.getTransactionKey();
        FileQueueData fData = new FileQueueData(transactionKey, dataMap);
        this.write(fData);
    }

    @Override
    public void write(FileQueueData fData) throws QueueWriteException {
        if (ObjectUtils.isEmpty((Object)fData)) {
            return;
        }
        if (fData.getTransactionKey() <= 0L) {
            fData.setTransactionKey(this.getTransactionKey());
        }
        this.writeQueueData(Arrays.asList(fData));
    }

    @Override
    public void write(List<Map<String, Object>> dataList) throws QueueWriteException {
        long groupKey = 0L;
        if (ObjectUtils.isEmpty(dataList)) {
            return;
        }
        int size = dataList.size();
        ArrayList<FileQueueData> fileQueueDataList = new ArrayList<FileQueueData>(dataList.size());
        if (size > 1) {
            groupKey = this.getGroupKey();
        }
        for (Map<String, Object> dataMap : dataList) {
            FileQueueData fData = new FileQueueData(this.getTransactionKey(), dataMap);
            if (size > 1) {
                fData.setGroupTransactionKey(groupKey);
            }
            fileQueueDataList.add(fData);
        }
        this.writeQueueData(fileQueueDataList);
    }

    @Override
    public void writeQueueData(List<FileQueueData> fileQueueDataList) throws QueueWriteException {
        if (ObjectUtils.isEmpty(fileQueueDataList)) {
            return;
        }
        long groupKey = -1L;
        for (FileQueueData fData : fileQueueDataList) {
            if (fData.getTransactionKey() <= 0L) {
                fData.setTransactionKey(this.getTransactionKey());
            }
            if (fileQueueDataList.size() <= 1 || groupKey >= 0L || fData.getGroupTransactionKey() > 0L) continue;
            groupKey = this.getGroupKey();
        }
        if (groupKey > 0L) {
            for (FileQueueData fData : fileQueueDataList) {
                fData.setGroupTransactionKey(groupKey);
            }
        }
        boolean isReadLock = false;
        boolean isBulk = fileQueueDataList.size() > 1;
        try {
            this.dataSema.acquire();
            if (isBulk) {
                this.readSema.acquire(this.MAX_READER);
                isReadLock = true;
            }
            for (FileQueueData fData : fileQueueDataList) {
                long innerKey = fData.getTransactionKey();
                this.dataMap.put((Object)innerKey, (Object)fData.toString());
                this.dataKeyList.add(innerKey);
            }
            this.store.commit();
            this.addCount(fileQueueDataList.size(), this.INPUT_COUNT);
            this.lastInTime = System.currentTimeMillis();
            this.logger.debug("<\ud050 \uc4f0\uae30 : \uc131\uacf5> = \ud050 \uc815\ubcf4:[{}], \uc4f0\ub808\ub4dc \uba85:[{}],\ub370\uc774\ud0c0 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, Thread.currentThread().getName(), fileQueueDataList.size()});
        }
        catch (Exception e) {
            if (isBulk) {
                this.store.rollback();
            }
            throw new QueueWriteException("<\ud050 \uc4f0\uae30 \ucee4\ubc0b : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "], \ud050 \ub864\ubc31 \uc218\ud589:[" + isBulk + "]", e);
        }
        finally {
            this.dataSema.release();
            if (isReadLock) {
                this.readSema.release(this.MAX_READER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTransactionKey() {
        AtomicLong atomicLong = this.transactionIndex;
        synchronized (atomicLong) {
            this.transactionIndex.compareAndSet(Long.MAX_VALUE, 1L);
            return this.transactionIndex.getAndIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getGroupKey() {
        AtomicLong atomicLong = this.groupIndex;
        synchronized (atomicLong) {
            this.groupIndex.compareAndSet(Long.MAX_VALUE, 1L);
            return this.groupIndex.getAndIncrement();
        }
    }

    @Override
    public List<FileQueueData> read(String threadName) throws QueueReadException {
        List<FileQueueData> queueDataList = null;
        queueDataList = (List<FileQueueData>)this.readBufferMap.get((Object)threadName);
        if (ObjectUtils.isNotEmpty((Object)queueDataList)) {
            this.logger.debug("<\ub2e8\uac74 (\ubc84\ud37c)\uc77d\uae30 : \uc131\uacf5> = \ud050:[{}], \ud0a4 \uc815\ubcf4{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, queueDataList.size()});
            return queueDataList;
        }
        try {
            this.dataSema.acquire();
            if (this.dataMap.size() < 1) {
                this.logger.debug("<\ub2e8\uac74 \uc77d\uae30 : \ubb34\uc2dc> = \ud050:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME, (Object)threadName);
                List<FileQueueData> list = null;
                return list;
            }
            this.realignKey(this.dataKeyList, this.dataMap);
            Long key = this.dataKeyList.get(0);
            String data = (String)this.dataMap.get((Object)key);
            FileQueueData fData = FileQueueData.fromString(data);
            if (ObjectUtils.isNotEmpty((Object)fData)) {
                queueDataList = Arrays.asList(fData);
                this.readBufferMap.put((Object)threadName, queueDataList);
            }
            this.dataKeyList.remove(key);
            this.dataMap.remove((Object)key);
            this.store.commit();
        }
        catch (Exception e) {
            throw new QueueReadException("<\ub2e8\uac74 \uc77d\uae30 : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "]", e);
        }
        finally {
            this.dataSema.release();
        }
        this.logger.debug("<\ub2e8\uac74 \uc77d\uae30 : \uc131\uacf5> = \ud050 \uc815\ubcf4:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, queueDataList.size()});
        return queueDataList;
    }

    @Override
    public List<FileQueueData> read(String threadName, int readCount) throws QueueReadException {
        ArrayList<FileQueueData> queueDataList = null;
        boolean isReadLock = false;
        queueDataList = (ArrayList<FileQueueData>)this.readBufferMap.get((Object)threadName);
        if (ObjectUtils.isNotEmpty((Object)queueDataList)) {
            this.logger.debug("<\ub300\ub7c9 (\ubc84\ud37c)\uc77d\uae30 : \uc131\uacf5> = \ud050 \uc815\ubcf4:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, queueDataList.size()});
            return queueDataList;
        }
        try {
            this.dataSema.acquire();
            int mapSize = this.dataMap.size();
            if (mapSize < 1) {
                this.logger.debug("<\ub300\ub7c9 \uc77d\uae30 : \ubb34\uc2dc> = \ud050 \uc815\ubcf4:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME, (Object)threadName);
                List<FileQueueData> list = null;
                return list;
            }
            this.realignKey(this.dataKeyList, this.dataMap);
            int selectCount = readCount > mapSize ? mapSize : readCount;
            queueDataList = new ArrayList<FileQueueData>(selectCount);
            this.readSema.acquire(this.MAX_READER);
            isReadLock = true;
            for (int i = 1; i <= selectCount; ++i) {
                long transKey = this.dataKeyList.remove(0);
                String data = (String)this.dataMap.remove((Object)transKey);
                FileQueueData fData = FileQueueData.fromString(data);
                queueDataList.add(fData);
            }
            this.readBufferMap.put((Object)threadName, queueDataList);
            this.store.commit();
            this.logger.debug("<\ub300\ub7c9 \uc77d\uae30 : \uc131\uacf5> = \ud050:[{}], \ud0a4 \uc815\ubcf4{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, queueDataList.size()});
        }
        catch (Exception e) {
            this.store.rollback();
            throw new QueueReadException("<\ub300\ub7c9 \uc77d\uae30 : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "], \ub864\ubc31 \uc218\ud589", e);
        }
        finally {
            this.dataSema.release();
            if (isReadLock) {
                this.readSema.release(this.MAX_READER);
            }
        }
        return queueDataList;
    }

    @Override
    public List<String> readAll() {
        return new ArrayList<String>(this.dataMap.values());
    }

    @Override
    public void removeOne() throws QueueReadException {
        boolean isReadLock = false;
        try {
            this.dataSema.acquire();
            int mapSize = this.dataMap.size();
            if (mapSize < 1) {
                this.logger.info("<\ud050 \ucd5c\uc2e0 \ub370\uc774\ud130 \uc81c\uac70 : \ubb34\uc2dc> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME);
                return;
            }
            this.realignKey(this.dataKeyList, this.dataMap);
            this.readSema.acquire(this.MAX_READER);
            isReadLock = true;
            long transKey = this.dataKeyList.remove(0);
            String data = (String)this.dataMap.remove((Object)transKey);
            this.store.commit();
            this.logger.info("<\ud050 \ucd5c\uc2e0 \ub370\uc774\ud130 \uc81c\uac70 : \uc131\uacf5> = \ud050:[{}], \ub370\uc774\ud130\ub0b4\uc6a9:[{}]", (Object)this.QUEUE_NAME, (Object)data);
        }
        catch (Exception e) {
            this.store.rollback();
            throw new QueueReadException("<\ub300\ub7c9 \uc77d\uae30 : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "], \ub864\ubc31 \uc218\ud589", e);
        }
        finally {
            this.dataSema.release();
            if (isReadLock) {
                this.readSema.release(this.MAX_READER);
            }
        }
    }

    @Override
    public void removeReadBufferOne(String threadName) throws QueueReadException {
        try {
            this.readSema.acquire();
            List fileQueueDataList = (List)this.readBufferMap.remove((Object)threadName);
            if (ObjectUtils.isEmpty((Object)fileQueueDataList)) {
                this.logger.warn("<\uc77d\uae30 \ubc84\ud37c \uc81c\uac70 : \ubb34\uc2dc> = \ud050:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME);
                return;
            }
            this.store.commit();
            this.logger.info("<\uc77d\uae30 \ubc84\ud37c \uc81c\uac70 : \uc131\uacf5> = \ud050:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", (Object)this.QUEUE_NAME, (Object)fileQueueDataList.size());
            for (FileQueueData queueData : fileQueueDataList) {
                this.logger.info("\uc0ad\uc81c \ub370\uc774\ud130:{[]}", (Object)queueData.toString());
            }
            this.addCount(fileQueueDataList.size(), this.OUTPUT_COUNT);
            this.lastOutTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new QueueReadException("<\uc77d\uae30 \ucee4\ubc0b : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "], \ub864\ubc31 \uc218\ud589", e);
        }
        finally {
            this.readSema.release();
        }
    }

    @Override
    public void readCommit(String threadName) throws QueueReadException {
        try {
            this.readSema.acquire();
            List fileQueueDataList = (List)this.readBufferMap.remove((Object)threadName);
            if (ObjectUtils.isEmpty((Object)fileQueueDataList)) {
                this.logger.warn("<\uc77d\uae30 \ucee4\ubc0b : \ubb34\uc2dc> = \ud050:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME, (Object)threadName);
                return;
            }
            this.store.commit();
            this.logger.debug("<\uc77d\uae30 \ucee4\ubc0b : \uc131\uacf5> = \ud050:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, fileQueueDataList.size()});
            this.addCount(fileQueueDataList.size(), this.OUTPUT_COUNT);
            this.lastOutTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new QueueReadException("<\uc77d\uae30 \ucee4\ubc0b : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "], \ub864\ubc31 \uc218\ud589", e);
        }
        finally {
            this.readSema.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRollBack(String threadName) {
        List fileQueueDataList = (List)this.readBufferMap.get((Object)threadName);
        if (ObjectUtils.isEmpty((Object)fileQueueDataList)) {
            this.logger.warn("<\uc77d\uae30 \ub864\ubc31 : \ubb34\uc2dc> = \ud050 \uc815\ubcf4:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME, (Object)threadName);
            return;
        }
        try {
            this.dataSema.acquire();
            this.readSema.acquire(this.MAX_READER);
            for (FileQueueData fdata : fileQueueDataList) {
                long transactionKey = fdata.getTransactionKey();
                this.dataMap.put((Object)fdata.getTransactionKey(), (Object)fdata.toString());
                this.dataKeyList.add(transactionKey);
            }
            this.readBufferMap.remove((Object)threadName);
            Collections.sort(this.dataKeyList, (a, b) -> a.compareTo((Long)b));
            this.store.commit();
            this.logger.debug("<\uc77d\uae30 \ub864\ubc31 : \uc131\uacf5> = \ud050:[{}], \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, fileQueueDataList.size()});
        }
        catch (Exception e) {
            this.logger.error("<\uc77d\uae30 \ub864\ubc31 : \uc2e4\ud328> = \ud050:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_NAME, (Object)e.toString());
            if (this.logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            this.readSema.release(this.MAX_READER);
            this.dataSema.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCount(long count, AtomicLong atomicLong) {
        AtomicLong atomicLong2 = atomicLong;
        synchronized (atomicLong2) {
            long currentValue = atomicLong.get();
            long newValue = currentValue + count > Long.MAX_VALUE ? count : currentValue + count;
            atomicLong.set(newValue);
        }
    }

    public long getInputCount() {
        return this.INPUT_COUNT.get();
    }

    public long getOutputCount() {
        return this.OUTPUT_COUNT.get();
    }

    public long getLastInTime() {
        return this.lastInTime;
    }

    public long getLastOutTime() {
        return this.lastOutTime;
    }

    @Override
    public boolean isOk() {
        if (this.store == null || this.dataMap == null || this.store.isClosed() || this.dataMap.isClosed()) {
            this.logger.error("{} \ud30c\uc77c\ud050 \uc2a4\ud1a0\uc5b4\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc");
            return false;
        }
        if (this.readBufferMap == null || this.readBufferMap.isClosed()) {
            this.logger.error("{} \uc77d\uae30 \ubc84\ud37c\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc");
            return false;
        }
        if (!Files.exists(Paths.get(this.QUEUE, new String[0]), new LinkOption[0])) {
            this.logger.error("{} \ud30c\uc77c\ud050\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c - \uc0ad\uc81c \ub428");
            return false;
        }
        return true;
    }

    @Override
    public int getQueueSize() {
        return this.dataMap == null ? 0 : this.dataMap.size();
    }

    @Override
    public int getMaxSize() {
        return this.LIMIT_SIZE;
    }

    @Override
    public void close() {
        if (this.store != null) {
            this.store.close();
        }
        if (this.dataKeyList != null) {
            this.dataKeyList.clear();
        }
    }

    @Override
    public String getQueue() {
        return this.QUEUE;
    }

    @Override
    public String getQueueName() {
        return this.QUEUE_NAME;
    }

    @Override
    public String getQueuePath() {
        return this.QUEUE_PATH;
    }
}

