/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.sample;

import com.queue.file.controller.Controller;
import com.queue.file.exception.QueueReadException;
import com.queue.file.vo.FileQueueData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkReadSample
implements Runnable {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Controller controller;
    private static final int MAX = 10000;
    private boolean isRun = true;
    private Map<Long, FileQueueData> cache = new LinkedHashMap<Long, FileQueueData>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, FileQueueData> eldest) {
            return this.size() > 10000;
        }
    };

    public BulkReadSample(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        long startTime = System.currentTimeMillis();
        int prcsCnt = 0;
        int sleepCnt = 0;
        while (this.controller.isOk() && this.isRun) {
            try {
                List<FileQueueData> fDataList = this.controller.read(name, 200);
                if (fDataList != null) {
                    for (FileQueueData fData : fDataList) {
                        if (this.cache.get(fData.getTransactionKey()) != null) {
                            this.logger.info("<\ub370\uc774\ud130 \uc911\ubcf5> - \ud0a4 \uc815\ubcf4: [{}], \ub370\uc774\ud130: [{}]", (Object)fData.getTransactionKey(), fData.getData());
                            continue;
                        }
                        this.cache.put(fData.getTransactionKey(), fData);
                    }
                    this.controller.readCommit(name);
                    prcsCnt += fDataList.size();
                    continue;
                }
                this.logger.info("<\uc2dc\uac04 \uce21\uc815> - \ub204\uc801 \ub370\uc774\ud130 \uac2f\uc218: [{}], \uc18c\uc694\uc2dc\uac04: [{}]", (Object)prcsCnt, (Object)(System.currentTimeMillis() - startTime - (long)(1000 * sleepCnt)));
                Thread.sleep(1000L);
                ++sleepCnt;
            }
            catch (InterruptedException e) {
                this.isRun = false;
            }
            catch (QueueReadException e) {
                this.isRun = false;
                throw new RuntimeException(e);
            }
        }
    }
}

