/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.sample;

import com.queue.file.controller.Controller;
import com.queue.file.exception.QueueWriteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkWriterSample
implements Runnable {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Controller controller;
    private boolean isRun = true;

    public BulkWriterSample(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void run() {
        HashMap<String, String> dataMap = new HashMap<String, String>(2);
        int loopCnt = 50;
        String name = Thread.currentThread().getName();
        StringBuilder sb = new StringBuilder();
        for (int j = 1; j <= 1000; ++j) {
            sb.append("1234567890");
        }
        String data = sb.toString();
        long startTime = System.currentTimeMillis();
        for (int i = 1; i <= loopCnt; ++i) {
            try {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(200);
                for (int x = 1; x <= 200; ++x) {
                    dataMap.put("DATA", i + data + x);
                    dataList.add(dataMap);
                }
                this.controller.write(dataList);
                continue;
            }
            catch (QueueWriteException e) {
                this.isRun = false;
                throw new RuntimeException(e);
            }
        }
        this.logger.info("<\ub370\uc774\ud130 \uc785\ub825 - \uc644\ub8cc> - \ub370\uc774\ud130 \uac2f\uc218: [{}], \uc18c\uc694\uc2dc\uac04: [{}]", (Object)loopCnt, (Object)(System.currentTimeMillis() - startTime));
    }
}

