/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller.extention;

import com.queue.file.controller.extention.ControllerEx;
import com.queue.file.exception.QueueReadException;
import com.queue.file.exception.QueueWriteException;
import com.queue.file.vo.extention.FileQueueCustomConfigVo;
import com.queue.file.vo.extention.FileQueueDataEx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractController
implements ControllerEx {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final int TRANSACTION_INDEX = 0;
    private final int GROUP_INDEX = 1;
    private final int PARTITION_INDEX = 2;
    private final int TAG_INDEX = 3;
    private final int BODY_INDEX = 4;
    private final int TIME_INDEX = 5;
    private MVStore store = null;
    private boolean bulkCommit = false;
    private boolean manualCommitMode = false;
    private boolean encryptMode = false;
    private boolean readOnlyMode = false;
    private boolean compressMode = false;
    private boolean restoreMode = false;
    private final int LIMIT_SIZE;
    private int autoCommitDelay = 1000;
    private int autoCommitMemory = 19456;
    private int cacheSize = 16;
    private int bulkSize = 10;
    private MVMap<Long, String> dataMap = null;
    private MVMap<String, List<FileQueueDataEx>> readBufferMap = null;
    private final List<Long> dataKeyList = new ArrayList<Long>();
    private final AtomicLong transactionIndex = new AtomicLong(1L);
    private final AtomicLong groupIndex = new AtomicLong(1L);
    private final String QUEUE;
    private final String QUEUE_PATH;
    private final String QUEUE_NAME;
    private final String ENCRYPT_KEY = "ENCRYPT_KEY";
    private final String READ_BUFFER = "READ_BUFFER_";
    private long openTime = 0L;
    private long lastInTime = 0L;
    private long lastOutTime = 0L;
    private long waitTime = 2000L;
    private final AtomicLong INPUT_COUNT = new AtomicLong(0L);
    private final AtomicLong OUTPUT_COUNT = new AtomicLong(0L);

    public AbstractController(String queue) {
        this.QUEUE = queue;
        int index = 0;
        if (StringUtils.isNotBlank((CharSequence)queue)) {
            index = queue.lastIndexOf(File.separator);
        }
        this.QUEUE_PATH = index > 0 ? queue.substring(0, index) : "";
        this.QUEUE_NAME = index > 0 ? queue.substring(index + 1) : "";
        this.LIMIT_SIZE = 0;
    }

    public AbstractController(String queuePath, String queueName) {
        this.QUEUE = queuePath + (queuePath.endsWith(File.separator) ? "" : File.separator) + queueName;
        this.QUEUE_PATH = queuePath;
        this.QUEUE_NAME = queueName;
        this.LIMIT_SIZE = 0;
    }

    public AbstractController(Map<String, Object> config) {
        int var;
        String name;
        String queue = config.get("queue") != null ? (String)config.get("queue") : "";
        String path = config.get("path") != null ? (String)config.get("path") : "";
        String string = name = config.get("name") != null ? (String)config.get("name") : "";
        if (StringUtils.isBlank((CharSequence)queue)) {
            queue = path + (path.endsWith(File.separator) ? "" : File.separator) + name;
        } else {
            int index = queue.lastIndexOf(File.separator);
            path = index > 0 ? queue.substring(0, index) : "";
            name = index > 0 ? queue.substring(index + 1) : "";
        }
        this.QUEUE = queue;
        this.QUEUE_PATH = path;
        this.QUEUE_NAME = name;
        if (config.get("encryptMode") != null) {
            this.encryptMode = true;
        }
        if (config.get("readOnly") != null) {
            this.readOnlyMode = true;
        }
        if (config.get("compress") != null) {
            this.compressMode = true;
        }
        int limit = 0;
        if (config.get("limit") != null && (var = ((Integer)config.get("limit")).intValue()) > 0) {
            limit = var;
        }
        this.LIMIT_SIZE = limit;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isBlank((CharSequence)this.QUEUE_PATH)) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050 \uc815\ubcf4:[{}], \ud050 \uc704\uce58 \uc815\ubcf4 \uc5c6\uc74c", (Object)this.QUEUE);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.QUEUE_NAME)) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050 \uc815\ubcf4:[{}], \ud050 \uc774\ub984 \uc815\ubcf4 \uc5c6\uc74c", (Object)this.QUEUE);
            return false;
        }
        if (this.QUEUE_NAME.startsWith("READ_BUFFER_")) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050 \uc815\ubcf4:[{}], [{}] \uc811\ub450\uc5b4\ub294 \uc0ac\uc6a9 \ubd88\uac00", (Object)this.QUEUE, (Object)"READ_BUFFER_");
            return false;
        }
        Path p = Paths.get(this.QUEUE_PATH, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            try {
                Files.createFile(p, new FileAttribute[0]);
                this.logger.info("<\ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 : \uc131\uacf5> = \uacbd\ub85c \uc815\ubcf4:[{}]", (Object)this.QUEUE_PATH);
            }
            catch (IOException e) {
                this.logger.error("<\ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 : \uc2e4\ud328> = \uacbd\ub85c \uc815\ubcf4:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_PATH, (Object)e.getMessage());
                this.logger.error("<\ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 : \uc2e4\ud328> = \uc5d0\ub7ec \uc0c1\uc138", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean open() {
        if (!this.validate()) {
            return false;
        }
        if (Files.exists(Paths.get(this.QUEUE, new String[0]), new LinkOption[0])) {
            this.restoreMode = true;
            this.logger.info("<\ud050 \ud65c\uc131\ud654 : \uc815\ubcf4> = \ud050 \uc774\ub984:[{}], \ubcf5\uad6c \ubaa8\ub4dc", (Object)this.QUEUE_NAME);
        }
        try {
            long dataMaxKey;
            this.store = this.openQueue();
            if (this.store == null || this.store.isClosed()) {
                return false;
            }
            if (this.manualCommitMode) {
                this.logger.info("<\ud050 \ud65c\uc131\ud654 : \uc815\ubcf4> = \ubc84\ud37c \ud050 \uc774\ub984:[{}], \uc548\uc815\uc131 \ubaa8\ub4dc", (Object)"READ_BUFFER_");
                this.readBufferMap = this.store.openMap("READ_BUFFER_" + this.QUEUE_NAME);
            }
            this.dataMap = this.store.openMap(this.QUEUE_NAME);
            if (!this.isOk()) {
                this.logger.info("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050:[{}]", (Object)this.QUEUE_NAME);
            }
            this.openTime = System.currentTimeMillis();
            if (this.restoreMode && (dataMaxKey = this.realignKey(this.dataKeyList, this.dataMap)) > 0L) {
                this.transactionIndex.set(dataMaxKey + 1001L);
            }
        }
        catch (Exception e) {
            this.logger.error("<\ud050 \ud65c\uc131\ud654 : \uc2e4\ud328> = \ud050:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_NAME, (Object)e.toString());
            return false;
        }
        this.openTime = System.currentTimeMillis();
        return true;
    }

    public abstract FileQueueCustomConfigVo setConfig();

    private MVStore openQueue() {
        if (this.store == null || this.store.isClosed()) {
            FileQueueCustomConfigVo configVo;
            HashMap<String, Object> configMap = new HashMap<String, Object>(5);
            configMap.put("fileName", this.QUEUE);
            if (this.readOnlyMode) {
                configMap.put("readOnly", 1);
            }
            if (this.compressMode) {
                configMap.put("compress", 1);
            }
            if ((configVo = this.setConfig()) == null) {
                configVo = new FileQueueCustomConfigVo();
            }
            this.waitTime = configVo.getWaitTime();
            this.autoCommitDelay = configVo.getAutoCommitDelay();
            this.autoCommitMemory = configVo.getAutoCommitMemory();
            this.manualCommitMode = configVo.isManualCommitMode();
            this.bulkSize = configVo.getBulkSize();
            this.bulkCommit = configVo.isBulkCommit();
            this.cacheSize = configVo.getCacheSize();
            if (this.manualCommitMode) {
                this.autoCommitDelay = 0;
            }
            configMap.put("autoCommitBufferSize", this.autoCommitMemory);
            try {
                String configInfo = DataUtils.appendMap((StringBuilder)new StringBuilder(), configMap).toString();
                MVStore.Builder builder = MVStore.Builder.fromString((String)configInfo);
                if (this.encryptMode) {
                    builder.encryptionKey("ENCRYPT_KEY".toCharArray());
                }
                this.store.setAutoCommitDelay(this.autoCommitDelay);
                this.store.setCacheSize(this.cacheSize);
                this.logger.info("<\ud050 \uc624\ud508 : \uc131\uacf5> = \ud050:[{}], \ud050 \uc124\uc815 \uc815\ubcf4 :[{}]", (Object)this.QUEUE_NAME, (Object)builder);
                this.logger.info("<\ud050 \uc624\ud508 : \uc131\uacf5> = \ud050:[{}], AutoCommitDelay :[{}], AutoCommitMemory :[{}], CacheSize :[{}]", new Object[]{this.QUEUE_NAME, this.store.getAutoCommitDelay(), this.store.getAutoCommitMemory(), this.store.getCacheSize()});
            }
            catch (Exception e) {
                this.logger.error("<\ud050 \uc624\ud508 : \uc2e4\ud328> = \ud050:[{}], \uc5d0\ub7ec \ubc1c\uc0dd:[{}]", (Object)this.QUEUE_NAME, (Object)e.getMessage());
                this.logger.error("<\ud050 \uc624\ud508 : \uc2e4\ud328> = \uc5d0\ub7ec \uc0c1\uc138", (Throwable)e);
                return null;
            }
        }
        return this.store;
    }

    @Override
    public long realignKey(List<Long> keyList, MVMap<Long, String> dataMap) {
        int mapSize = dataMap.size();
        int listSize = keyList.size();
        int diffCnt = mapSize - listSize;
        long maxKey = 0L;
        if (diffCnt != 0) {
            keyList.clear();
            keyList.addAll(dataMap.keySet());
            keyList.sort(Comparator.naturalOrder());
            if (diffCnt < 0) {
                diffCnt *= -1;
            }
            if (!keyList.isEmpty()) {
                maxKey = keyList.get(keyList.size() - 1);
            }
            this.logger.info("<\ud050 \uc815\ubcf4 \ub3d9\uae30\ud654 : \uc131\uacf5> = \ud050\uba85:[{}], \ucd08\uae30 KEY \uac2f\uc218:[{}], \ucd08\uae30 DATA \ud654\uac2f\uc218:[{}], \ub3d9\uae30\ud654 \uac74\uc218:[{}]", new Object[]{this.QUEUE_NAME, listSize, mapSize, diffCnt});
        }
        return maxKey;
    }

    @Override
    public boolean isOk() {
        if (this.store == null || this.dataMap == null || this.store.isClosed() || this.dataMap.isClosed()) {
            this.logger.error("{} \ud30c\uc77c\ud050 \uc2a4\ud1a0\uc5b4 \ub610\ub294 \ub370\uc774\ud130 \uc601\uc5ed\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc", (Object)this.QUEUE_NAME);
            return false;
        }
        if (!Files.exists(Paths.get(this.QUEUE, new String[0]), new LinkOption[0])) {
            this.logger.error("{} \ud30c\uc77c\ud050\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c - \uc0ad\uc81c \ub428", (Object)this.QUEUE);
            return false;
        }
        if (this.manualCommitMode && this.readBufferMap.isClosed()) {
            this.logger.error("{} \ud30c\uc77c\ud050 Read Buffer \uc601\uc5ed\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc", (Object)this.QUEUE_NAME);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void writeQueueData(List<String> storeDataList) throws QueueWriteException {
        if (ObjectUtils.isEmpty(storeDataList)) {
            return;
        }
        boolean isBulk = storeDataList.size() >= this.bulkSize;
        long groupKey = this.getGroupKey();
        try {
            for (String storeData : storeDataList) {
                long innerKey = this.getTransactionKey();
                this.dataMap.put((Object)innerKey, (Object)(innerKey + "1K2K3B4K5D6I7P8Y9N0" + groupKey + "1K2K3B4K5D6I7P8Y9N0" + storeData));
                this.dataKeyList.add(innerKey);
            }
            if (isBulk && this.bulkCommit || this.manualCommitMode) {
                this.store.commit();
            }
            this.lastInTime = System.currentTimeMillis();
            this.addCount(storeDataList.size(), this.INPUT_COUNT);
            this.logger.debug("<\ud050 \uc4f0\uae30 : \uc131\uacf5> = \ud050 \uc815\ubcf4:[{}], \uc4f0\ub808\ub4dc \uba85:[{}],\ub370\uc774\ud0c0 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, Thread.currentThread().getName(), storeDataList.size()});
            if (isBulk) {
                this.notifyAll();
            } else {
                this.notify();
            }
        }
        catch (Exception e) {
            if (this.manualCommitMode) {
                this.logger.error("<\uc4f0\uae30 : \uc2e4\ud328> = \ud050:[{}], \ub864\ubc31 \uc218\ud589", (Object)this.QUEUE_NAME);
                this.store.rollback();
            }
            throw new QueueWriteException("<\ud050 \uc4f0\uae30 \ucee4\ubc0b : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "], \uc2e4\ud328 \uadf8\ub8f9\ud0a4:[" + groupKey + "]", e);
        }
    }

    @Override
    public synchronized List<FileQueueDataEx> read(String threadName, int requestCount) throws QueueReadException {
        ArrayList<FileQueueDataEx> queueDataList = null;
        try {
            if (this.manualCommitMode && ObjectUtils.isNotEmpty((Object)(queueDataList = (ArrayList<FileQueueDataEx>)this.readBufferMap.get((Object)threadName)))) {
                this.logger.debug("<(\ubc84\ud37c)\uc77d\uae30 : \uc131\uacf5> = \ud050:[{}], \ud0a4 \uc815\ubcf4{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", new Object[]{this.QUEUE_NAME, threadName, queueDataList.size()});
                return queueDataList;
            }
            int mapSize = this.dataMap.size();
            if (mapSize < 1) {
                this.logger.debug("<\ub300\ub7c9 \uc77d\uae30 : \ubb34\uc2dc> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME);
                this.wait(this.waitTime);
                return null;
            }
            int selectCount = Math.min(requestCount, mapSize);
            boolean isBulk = selectCount >= this.bulkSize;
            queueDataList = new ArrayList<FileQueueDataEx>(selectCount);
            this.realignKey(this.dataKeyList, this.dataMap);
            for (int i = 1; i <= selectCount; ++i) {
                Long transKey = this.dataKeyList.remove(0);
                String data = (String)this.dataMap.remove((Object)transKey);
                if (transKey == null || data == null) {
                    this.logger.warn("<\uc77d\uae30 : \uc774\uc0c1> = \ud050 \uc815\ubcf4:[{}], NULL \uac10\uc9c0, \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc815\ubcf4:[{}]", new Object[]{this.QUEUE_NAME, transKey, data});
                    continue;
                }
                String[] dataArray = data.split("1K2K3B4K5D6I7P8Y9N0");
                if (dataArray.length < 6) {
                    this.logger.warn("<\uc77d\uae30 : \uc774\uc0c1> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc774\uc0c1 \uac10\uc9c0, \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc815\ubcf4:[{}]", new Object[]{this.QUEUE_NAME, transKey, data});
                    continue;
                }
                long innerkey = Long.parseLong(dataArray[0]);
                long groupKey = Long.parseLong(dataArray[1]);
                long time = Long.parseLong(dataArray[5]);
                if (innerkey != transKey) {
                    this.logger.warn("<\uc77d\uae30 : \uc774\uc0c1> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc774\uc0c1 \uac10\uc9c0, \ud0a4 \ubd88\uc77c\uce58 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc815\ubcf4:[{}]", new Object[]{this.QUEUE_NAME, transKey, data});
                }
                FileQueueDataEx fData = new FileQueueDataEx(transKey, groupKey, dataArray[2], dataArray[3], dataArray[4], time);
                queueDataList.add(fData);
            }
            if (isBulk && this.bulkCommit || this.manualCommitMode) {
                if (this.manualCommitMode) {
                    this.readBufferMap.put((Object)threadName, queueDataList);
                }
                this.store.commit();
            }
            this.lastOutTime = System.currentTimeMillis();
            this.logger.debug("<\uc77d\uae30 : \uc131\uacf5> = \ud050:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", (Object)this.QUEUE_NAME, (Object)queueDataList.size());
        }
        catch (Exception e) {
            if (this.manualCommitMode) {
                this.logger.error("<\uc77d\uae30 : \uc2e4\ud328> = \ud050:[{}], \ub864\ubc31 \uc218\ud589", (Object)this.QUEUE_NAME);
                this.store.rollback();
            }
            throw new QueueReadException("<\uc77d\uae30 : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "]", e);
        }
        return queueDataList;
    }

    private long getTransactionKey() {
        this.transactionIndex.compareAndSet(Long.MAX_VALUE, 1L);
        return this.transactionIndex.getAndIncrement();
    }

    private long getGroupKey() {
        this.groupIndex.compareAndSet(Long.MAX_VALUE, 1L);
        return this.groupIndex.getAndIncrement();
    }

    private void addCount(long count, AtomicLong atomicLong) {
        atomicLong.updateAndGet(currentValue -> {
            if (currentValue >= Long.MAX_VALUE - count) {
                return count;
            }
            return currentValue + count;
        });
    }

    @Override
    public List<String> allData() {
        return new ArrayList<String>(this.dataMap.values());
    }

    @Override
    public List<List<FileQueueDataEx>> allReadBuffer() {
        if (this.readBufferMap == null || !this.manualCommitMode) {
            return null;
        }
        return new ArrayList<List<FileQueueDataEx>>(this.readBufferMap.values());
    }

    @Override
    public synchronized FileQueueDataEx removeOne() throws QueueReadException {
        FileQueueDataEx fData = null;
        try {
            int mapSize = this.dataMap.size();
            if (mapSize < 1) {
                this.logger.info("<\ud050 \ucd5c\uc2e0 \ub370\uc774\ud130 \uc81c\uac70 : \ubb34\uc2dc> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME);
                return null;
            }
            this.realignKey(this.dataKeyList, this.dataMap);
            Long transKey = this.dataKeyList.remove(0);
            String data = (String)this.dataMap.remove((Object)transKey);
            if (transKey == null || data == null) {
                this.logger.warn("<\uc81c\uac70 : \uc774\uc0c1> = \ud050 \uc815\ubcf4:[{}], NULL \uac10\uc9c0, \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc815\ubcf4:[{}]", new Object[]{this.QUEUE_NAME, transKey, data});
                return null;
            }
            String[] dataArray = data.split("1K2K3B4K5D6I7P8Y9N0");
            if (dataArray.length < 6) {
                this.logger.warn("<\uc81c\uac70 : \uc774\uc0c1> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc774\uc0c1 \uac10\uc9c0, \ud0a4 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc815\ubcf4:[{}]", new Object[]{this.QUEUE_NAME, transKey, data});
                return null;
            }
            long innerkey = Long.parseLong(dataArray[0]);
            long groupKey = Long.parseLong(dataArray[1]);
            long time = Long.parseLong(dataArray[5]);
            if (innerkey != transKey) {
                this.logger.warn("<\uc81c\uac70 : \uc774\uc0c1> = \ud050 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc774\uc0c1 \uac10\uc9c0, \ud0a4 \ubd88\uc77c\uce58 \uc815\ubcf4:[{}], \ub370\uc774\ud130 \uc815\ubcf4:[{}]", new Object[]{this.QUEUE_NAME, transKey, data});
            }
            fData = new FileQueueDataEx(transKey, groupKey, dataArray[2], dataArray[3], dataArray[4], time);
            this.store.commit();
            this.logger.info("<\ud050 \ucd5c\uc2e0 \ub370\uc774\ud130 \uc81c\uac70 : \uc131\uacf5> = \ud050:[{}], \ub370\uc774\ud130\ub0b4\uc6a9:[{}]", (Object)this.QUEUE_NAME, (Object)data);
        }
        catch (Exception e) {
            throw new QueueReadException("<\ud050\ub370\uc774\ud130 \ub2e8\uac74 \uc81c\uac70 : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "]", e);
        }
        return fData;
    }

    @Override
    public synchronized List<FileQueueDataEx> removeReadBufferOne(String threadName) throws QueueReadException {
        List fileQueueDataList = null;
        if (this.readBufferMap == null || !this.manualCommitMode) {
            return null;
        }
        try {
            fileQueueDataList = (List)this.readBufferMap.remove((Object)threadName);
            if (ObjectUtils.isEmpty((Object)fileQueueDataList)) {
                this.logger.warn("<\uc77d\uae30 \ubc84\ud37c \uc81c\uac70 : \ubb34\uc2dc> = \ud050:[{}], \ub370\uc774\ud130 \uc5c6\uc74c", (Object)this.QUEUE_NAME);
                this.store.commit();
                List<FileQueueDataEx> list = null;
                return list;
            }
            this.logger.info("<\uc77d\uae30 \ubc84\ud37c \uc81c\uac70 : \uc131\uacf5> = \ud050:[{}], \ub370\uc774\ud130 \uac2f\uc218:[{}]", (Object)this.QUEUE_NAME, (Object)fileQueueDataList.size());
            for (FileQueueDataEx queueData : fileQueueDataList) {
                this.logger.info("\uc0ad\uc81c \ub370\uc774\ud130:{[]}", (Object)queueData.toString());
            }
            this.addCount(fileQueueDataList.size(), this.OUTPUT_COUNT);
            this.lastOutTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new QueueReadException("<\uc77d\uae30 \ubc84\ud37c \uc81c\uac70: \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "]", e);
        }
        finally {
            this.store.commit();
        }
        return fileQueueDataList;
    }

    @Override
    public synchronized void clear() throws QueueReadException {
        try {
            this.dataMap.clear();
            this.dataKeyList.clear();
            if (this.manualCommitMode && this.readBufferMap != null) {
                this.readBufferMap.clear();
            }
            this.store.commit();
        }
        catch (Exception e) {
            throw new QueueReadException("<\ub370\uc774\ud130 \uc601\uc5ed \ud074\ub80c\uc9d5 : \uc2e4\ud328> = \ud050:[" + this.QUEUE_NAME + "]", e);
        }
    }

    @Override
    public void close() {
        if (this.store != null && !this.store.isClosed()) {
            this.store.commit();
            this.store.close();
        }
        this.dataKeyList.clear();
    }

    public int getQueueSize() {
        int queueSize;
        int n = queueSize = this.dataMap == null ? 0 : this.dataMap.size();
        if (this.manualCommitMode && this.readBufferMap != null) {
            queueSize += this.readBufferMap.size();
        }
        return queueSize;
    }

    public long getInputCount() {
        return this.INPUT_COUNT.get();
    }

    public long getOutputCount() {
        return this.OUTPUT_COUNT.get();
    }

    public long getLastInTime() {
        return this.lastInTime;
    }

    public long getLastOutTime() {
        return this.lastOutTime;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public int getLIMIT_SIZE() {
        return this.LIMIT_SIZE;
    }

    public String getQUEUE() {
        return this.QUEUE;
    }

    public String getQUEUE_NAME() {
        return this.QUEUE_NAME;
    }

    public String getQUEUE_PATH() {
        return this.QUEUE_PATH;
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getBulkSize() {
        return this.bulkSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public boolean isBulkCommit() {
        return this.bulkCommit;
    }

    public boolean isManualCommitMode() {
        return this.manualCommitMode;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }
}

