/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.vo.extention;

import com.google.gson.Gson;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class FileQueueDataEx
implements Serializable {
    public static final String DELIMITER = "1K2K3B4K5D6I7P8Y9N0";
    private static final Gson gson = new Gson();
    private String partition = "";
    private String tag = "";
    private Long groupTransactionKey;
    private Long transactionKey;
    private final long createTime;
    private String data;

    public FileQueueDataEx(String data) {
        this(0L, 0L, data);
    }

    public FileQueueDataEx(long transactionKey, long createTime) {
        this(transactionKey, 0L, "", "", "", createTime);
    }

    public FileQueueDataEx(long transactionKey, String data) {
        this(transactionKey, 0L, "", "", data, System.currentTimeMillis());
    }

    public FileQueueDataEx(long transactionKey, long groupTransactionKey, String data) {
        this(transactionKey, groupTransactionKey, "", "", data, System.currentTimeMillis());
    }

    public FileQueueDataEx(String tag, String data) {
        this("", tag, data);
    }

    public FileQueueDataEx(String partition, String tag, String data) {
        this(0L, 0L, partition, tag, data, System.currentTimeMillis());
    }

    public FileQueueDataEx(long transactionKey, String partition, String tag, String data) {
        this(transactionKey, 0L, partition, tag, data, System.currentTimeMillis());
    }

    public FileQueueDataEx(String partition, String tag, String data, Long time) {
        this(0L, 0L, partition, tag, data, time);
    }

    public FileQueueDataEx(long transactionKey, long groupTransactionKey, String partition, String tag, String data, Long time) {
        this.transactionKey = transactionKey;
        this.groupTransactionKey = groupTransactionKey;
        this.partition = partition;
        this.tag = tag;
        this.data = data;
        this.createTime = time == null || time <= 0L ? System.currentTimeMillis() : time;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Long getTransactionKey() {
        return this.transactionKey;
    }

    public void setTransactionKey(Long transactionKey) {
        this.transactionKey = transactionKey;
    }

    public Long getGroupTransactionKey() {
        return this.groupTransactionKey;
    }

    public void setGroupTransactionKey(Long groupTransactionKey) {
        this.groupTransactionKey = groupTransactionKey;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public static boolean isValid(String lowData) {
        return !StringUtils.isBlank((CharSequence)lowData) && lowData.startsWith("@{") && lowData.endsWith("}@");
    }

    public String toString() {
        return "@" + gson.toJson((Object)this) + "@";
    }

    public static FileQueueDataEx fromString(String lowData) {
        if (!FileQueueDataEx.isValid(lowData)) {
            return null;
        }
        String data = lowData.substring(1, lowData.length() - 1);
        return (FileQueueDataEx)gson.fromJson(data, FileQueueDataEx.class);
    }
}

