/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller.extention;

import com.google.gson.Gson;
import com.queue.file.exception.QueueReadException;
import com.queue.file.exception.QueueWriteException;
import com.queue.file.vo.extention.FileQueueDataEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.h2.mvstore.MVMap;

public interface ControllerEx {
    public static final Gson gson = new Gson();

    public boolean validate();

    public boolean open();

    public long realignKey(List<Long> var1, MVMap<Long, String> var2);

    public boolean isOk();

    default public void write(Object dataObject) throws QueueWriteException {
        this.write("", dataObject);
    }

    default public void write(String tag, Object dataObject) throws QueueWriteException {
        this.write(tag, "", dataObject);
    }

    default public void write(String tag, String partition, Object dataObject) throws QueueWriteException {
        if (ObjectUtils.isEmpty((Object)dataObject)) {
            return;
        }
        String bodyData = gson.toJson(dataObject);
        String storeData = partition + "1K2K3B4K5D6I7P8Y9N0" + tag + "1K2K3B4K5D6I7P8Y9N0" + bodyData + "1K2K3B4K5D6I7P8Y9N0" + System.currentTimeMillis() + "1K2K3B4K5D6I7P8Y9N0";
        this.writeQueueData(Collections.singletonList(storeData));
    }

    default public void write(List<Object> dataList) throws QueueWriteException {
        this.write("", dataList);
    }

    default public void write(String tag, List<Object> dataList) throws QueueWriteException {
        this.write(tag, "", dataList);
    }

    default public void write(String tag, String partition, List<Object> dataList) throws QueueWriteException {
        if (ObjectUtils.isEmpty(dataList)) {
            return;
        }
        ArrayList<String> storeDataList = new ArrayList<String>(dataList.size());
        long now = System.currentTimeMillis();
        for (Object object : dataList) {
            String bodyData = gson.toJson(object);
            String storeData = partition + "1K2K3B4K5D6I7P8Y9N0" + tag + "1K2K3B4K5D6I7P8Y9N0" + bodyData + "1K2K3B4K5D6I7P8Y9N0" + now + "1K2K3B4K5D6I7P8Y9N0";
            storeDataList.add(storeData);
        }
        this.writeQueueData(storeDataList);
    }

    public void writeQueueData(List<String> var1) throws QueueWriteException;

    default public List<FileQueueDataEx> read() throws QueueReadException {
        return this.read(Thread.currentThread().getName(), 1);
    }

    default public List<FileQueueDataEx> read(String threadName) throws QueueReadException {
        return this.read(threadName, 1);
    }

    public List<FileQueueDataEx> read(String var1, int var2) throws QueueReadException;

    public void readCommit(String var1) throws QueueReadException;

    public List<String> allData();

    public List<List<FileQueueDataEx>> allReadBuffer();

    public FileQueueDataEx removeOne() throws QueueReadException;

    public List<FileQueueDataEx> removeReadBufferOne(String var1) throws QueueReadException;

    public void clear() throws QueueReadException;

    public void close();
}

