/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller;

import com.queue.file.controller.DataAccess;
import com.queue.file.controller.PartitionManager;
import com.queue.file.exception.QueueException;
import com.queue.file.exception.QueueReadException;
import com.queue.file.exception.QueueWriteException;
import com.queue.file.exception.UnsteadyStateException;
import com.queue.file.vo.FileQueueData;
import com.queue.file.vo.PartitionContext;
import com.queue.file.vo.PartitionSummaryVo;
import com.queue.file.vo.StoreInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseController
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(BaseController.class);
    private final StoreInfo storeInfo;
    private final PartitionManager partitionManager;
    private final DataAccess dataAccess;

    BaseController(StoreInfo storeInfo) {
        this.storeInfo = storeInfo;
        this.partitionManager = new PartitionManager(storeInfo);
        this.dataAccess = new DataAccess(storeInfo, this.partitionManager);
    }

    public StoreInfo getStoreInfo() {
        return this.storeInfo;
    }

    public void write(String data) throws QueueWriteException {
        logger.debug("write default partition data: {}", (Object)data);
        try {
            this.dataAccess.write("", "DP201019", Thread.currentThread().getName(), data);
        }
        catch (QueueException e) {
            logger.error("Write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void write(String partition, String data) throws QueueWriteException {
        logger.debug("write data: partition={}, data={}", (Object)partition, (Object)data);
        try {
            this.dataAccess.write("", partition, Thread.currentThread().getName(), data);
        }
        catch (QueueException e) {
            logger.error("Write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void write(String partition, String executorName, String data) throws QueueWriteException {
        logger.debug("write data: partition={}, executor={}, data={}", new Object[]{partition, executorName, data});
        try {
            this.dataAccess.write("", partition, executorName, data);
        }
        catch (QueueException e) {
            logger.error("Write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void write(String tag, String partition, String executorName, String data) throws QueueWriteException {
        logger.debug("write data: tag={}, partition={}, executor={}", new Object[]{tag, partition, executorName});
        try {
            this.dataAccess.write(tag, partition, executorName, data);
        }
        catch (QueueException e) {
            logger.error("Write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void writeBulk(List<String> dataList) throws QueueWriteException {
        logger.debug("write bulk default partition size={}", (Object)(dataList == null ? 0 : dataList.size()));
        try {
            this.dataAccess.writeBulk("", "DP201019", Thread.currentThread().getName(), dataList);
        }
        catch (QueueException e) {
            logger.error("Bulk write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void writeBulk(String partition, List<String> dataList) throws QueueWriteException {
        logger.debug("write bulk: partition={}, size={}", (Object)partition, (Object)(dataList == null ? 0 : dataList.size()));
        try {
            this.dataAccess.writeBulk("", partition, Thread.currentThread().getName(), dataList);
        }
        catch (QueueException e) {
            logger.error("Bulk write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void writeBulk(String partition, String executorName, List<String> dataList) throws QueueWriteException {
        logger.debug("write bulk: partition={}, executor={}, size={}", new Object[]{partition, executorName, dataList == null ? 0 : dataList.size()});
        try {
            this.dataAccess.writeBulk("", partition, executorName, dataList);
        }
        catch (QueueException e) {
            logger.error("Bulk write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void writeBulk(String tag, String partition, String executorName, List<String> dataList) throws QueueWriteException {
        logger.debug("write bulk: tag={}, partition={}, executor={}, size={}", new Object[]{tag, partition, executorName, dataList == null ? 0 : dataList.size()});
        try {
            this.dataAccess.writeBulk(tag, partition, executorName, dataList);
        }
        catch (QueueException e) {
            logger.error("Bulk write failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public void writeQueueData(String executorName, List<FileQueueData> dataList) throws QueueWriteException {
        logger.debug("write queue data: executor={}, size={}", (Object)executorName, (Object)(dataList == null ? 0 : dataList.size()));
        try {
            this.dataAccess.writeQueueData(executorName, dataList);
        }
        catch (QueueException e) {
            logger.error("Write queue data failed", (Throwable)e);
            throw new QueueWriteException(e);
        }
    }

    public FileQueueData read() throws QueueReadException {
        logger.debug("read default partition");
        try {
            return this.dataAccess.read("DP201019", Thread.currentThread().getName());
        }
        catch (QueueException e) {
            logger.error("Read failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public FileQueueData read(String executorName) throws QueueReadException {
        logger.debug("read default partition executor={}", (Object)executorName);
        try {
            return this.dataAccess.read("DP201019", executorName);
        }
        catch (QueueException e) {
            logger.error("Read failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public FileQueueData read(String partitionName, String executorName) throws QueueReadException {
        logger.debug("read partition={}, executor={}", (Object)partitionName, (Object)executorName);
        try {
            return this.dataAccess.read(partitionName, executorName);
        }
        catch (QueueException e) {
            logger.error("Read failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public List<FileQueueData> read(String executorName, int requestCount) throws QueueReadException {
        logger.debug("read executor={} count={}", (Object)executorName, (Object)requestCount);
        try {
            return this.dataAccess.read("DP201019", executorName, requestCount);
        }
        catch (QueueException e) {
            logger.error("Read failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public List<FileQueueData> read(String partitionName, String executorName, int requestCount) throws QueueReadException {
        logger.debug("read partition={}, executor={}, count={}", new Object[]{partitionName, executorName, requestCount});
        try {
            return this.dataAccess.read(partitionName, executorName, requestCount);
        }
        catch (QueueException e) {
            logger.error("Read failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public void readCommit(String executorName) throws QueueReadException {
        logger.debug("readCommit executor={} default partition", (Object)executorName);
        try {
            this.dataAccess.readCommit("DP201019", executorName);
        }
        catch (QueueException e) {
            logger.error("ReadCommit failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public void readCommit(String partitionName, String executorName) throws QueueReadException {
        logger.debug("readCommit partition={}, executor={}", (Object)partitionName, (Object)executorName);
        try {
            this.dataAccess.readCommit(partitionName, executorName);
        }
        catch (QueueException e) {
            logger.error("ReadCommit failed", (Throwable)e);
            throw new QueueReadException(e);
        }
    }

    public void checkAllState() throws UnsteadyStateException {
        logger.debug("check all state");
        this.partitionManager.checkAllState();
    }

    public void checkState() throws UnsteadyStateException {
        logger.debug("check state default partition");
        this.checkState("DP201019");
    }

    public void checkState(String partitionName) throws UnsteadyStateException {
        logger.debug("check state partition={}", (Object)partitionName);
        this.partitionManager.checkState(partitionName, true);
    }

    public Set<String> getAllPartitionNameSet() {
        return this.partitionManager.getPartitionContextMap().keySet();
    }

    public Map<String, PartitionSummaryVo> getSummaryInfo() {
        return this.dataAccess.getSummaryInfo();
    }

    public Map<String, List<FileQueueData>> getAllDataList() {
        return this.dataAccess.getAllDataList();
    }

    public List<FileQueueData> getPartitionDataList(String partitionName) {
        return this.dataAccess.getPartitionDataList(partitionName);
    }

    public FileQueueData getData(String partitionName, Long transactionKey) {
        return this.dataAccess.getData(partitionName, transactionKey);
    }

    public Map<String, List<FileQueueData>> getPartitionBufferList(String partitionName) {
        return this.dataAccess.getPartitionBufferList(partitionName);
    }

    public List<FileQueueData> getBuffer(String partitionName, String executorName) {
        return this.dataAccess.getBuffer(partitionName, executorName);
    }

    public Map<String, Object> getPartitionCacheList(String partitionName) {
        return this.dataAccess.getPartitionCacheList(partitionName);
    }

    public Object getCache(String partitionName, String cacheKey) {
        return this.dataAccess.getCache(partitionName, cacheKey);
    }

    public void clearAllData() {
        logger.debug("clear all data");
        this.dataAccess.clearAllData();
    }

    public void clearData(String partitionName) {
        logger.debug("clear data partition={}", (Object)partitionName);
        this.dataAccess.clearData(partitionName);
    }

    public void removeData(String partitionName, Long transactionKey) {
        this.dataAccess.removeData(partitionName, transactionKey);
    }

    public void clearAllBuffer() {
        logger.debug("clear all buffer");
        this.dataAccess.clearAllBuffer();
    }

    public void clearBuffer(String partitionName) {
        logger.debug("clear buffer partition={}", (Object)partitionName);
        this.dataAccess.clearBuffer(partitionName);
    }

    public void clearBuffer(String partitionName, String executorName) {
        logger.debug("clear buffer partition={} executor={}", (Object)partitionName, (Object)executorName);
        this.dataAccess.clearBuffer(partitionName, executorName);
    }

    public void clearAllCache() {
        logger.debug("clear all cache");
        this.dataAccess.clearAllCache();
    }

    public void clearCache(String partitionName) {
        logger.debug("clear cache partition={}", (Object)partitionName);
        this.dataAccess.clearCache(partitionName);
    }

    public void clearCache(String partitionName, String cacheKey) {
        logger.debug("clear cache partition={} key={}", (Object)partitionName, (Object)cacheKey);
        this.dataAccess.clearCache(partitionName, cacheKey);
    }

    public void removeOne(String partitionName, String executorName) {
        logger.debug("remove one partition={} executor={}", (Object)partitionName, (Object)executorName);
        this.dataAccess.removeOne(partitionName, executorName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        logger.info("AutoCloseable#close: Graceful shutdown start");
        ArrayList<ReentrantReadWriteLock.WriteLock> acquiredLocks = new ArrayList<ReentrantReadWriteLock.WriteLock>();
        try {
            ArrayList<String> partitions = new ArrayList<String>(this.partitionManager.getPartitionContextMap().keySet());
            Collections.sort(partitions);
            for (String partition : partitions) {
                PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partition);
                ReentrantReadWriteLock.WriteLock wl = ctx.getLock().writeLock();
                boolean locked = false;
                int maxRetry = 3;
                long timeoutPerTryMillis = 5000L;
                for (int i = 0; i < 3; ++i) {
                    try {
                        if (!wl.tryLock(5000L, TimeUnit.MILLISECONDS)) continue;
                        acquiredLocks.add(wl);
                        logger.debug("Lock acquired for partition {} (attempt {})", (Object)partition, (Object)(i + 1));
                        locked = true;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("Interrupted while locking {}", (Object)partition);
                    }
                    break;
                }
                if (locked) continue;
                logger.error("Failed to lock partition {} after retries", (Object)partition);
            }
            if (this.storeInfo.getStore() != null && !this.storeInfo.getStore().isClosed()) {
                this.storeInfo.getStore().commit();
                this.storeInfo.getStore().close();
                this.storeInfo.setStoreOpenTime(null);
                logger.info("store committed and closed");
            }
        }
        catch (Exception e) {
            logger.error("Error during graceful close", (Throwable)e);
        }
        finally {
            for (int i = acquiredLocks.size() - 1; i >= 0; --i) {
                try {
                    ((ReentrantReadWriteLock.WriteLock)acquiredLocks.get(i)).unlock();
                    continue;
                }
                catch (Exception exception) {}
            }
        }
    }
}

