/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller;

import com.queue.file.controller.BaseController;
import com.queue.file.exception.InitializeException;
import com.queue.file.vo.FileQueueConfigVo;
import com.queue.file.vo.FileQueueCustomConfigVo;
import com.queue.file.vo.StoreInfo;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ControllerFactory.class);
    private static final int MAX_CHUNK_ID = 0x3FFFFFF;
    private static final double CHUNK_ID_THRESHOLD_RATIO = 0.9;

    public static BaseController create(String queue) throws InitializeException {
        logger.debug("create controller queue={}", (Object)queue);
        StoreInfo storeInfo = new StoreInfo(new FileQueueConfigVo(queue));
        ControllerFactory.initialize(storeInfo);
        return new BaseController(storeInfo);
    }

    public static BaseController create(String queuePath, String queueName) throws InitializeException {
        logger.debug("create controller path={} name={}", (Object)queuePath, (Object)queueName);
        StoreInfo storeInfo = new StoreInfo(new FileQueueConfigVo(queuePath, queueName));
        ControllerFactory.initialize(storeInfo);
        return new BaseController(storeInfo);
    }

    public static BaseController createStable(String queue) throws InitializeException {
        FileQueueConfigVo configVo = new FileQueueConfigVo(queue);
        FileQueueCustomConfigVo fileQueueCustomConfigVo = new FileQueueCustomConfigVo();
        fileQueueCustomConfigVo.setStableMode(true);
        configVo.setCustomConfig(fileQueueCustomConfigVo);
        return ControllerFactory.createCustomController(configVo);
    }

    public static BaseController createBulk(String queue, int bulkSize) throws InitializeException {
        logger.debug("create bulk controller queue={} bulkSize={}", (Object)queue, (Object)bulkSize);
        FileQueueConfigVo configVo = new FileQueueConfigVo(queue);
        FileQueueCustomConfigVo fileQueueCustomConfigVo = new FileQueueCustomConfigVo();
        fileQueueCustomConfigVo.setBulkCommit(true);
        fileQueueCustomConfigVo.setBulkSize(bulkSize);
        configVo.setCustomConfig(fileQueueCustomConfigVo);
        return ControllerFactory.createCustomController(configVo);
    }

    public static BaseController createCustomController(FileQueueConfigVo configVo) throws InitializeException {
        logger.debug("create custom controller with config={}", (Object)configVo.getQueue());
        StoreInfo storeInfo = new StoreInfo(configVo);
        ControllerFactory.initialize(storeInfo);
        return new BaseController(storeInfo);
    }

    private static void initialize(StoreInfo storeInfo) throws InitializeException {
        FileQueueConfigVo configVo = storeInfo.getCONFIG();
        logger.debug("openStore queue={}", (Object)configVo.getQueue());
        ControllerFactory.checkFile(storeInfo);
        ControllerFactory.checkStore(configVo.getQueue());
        if (storeInfo.getStore() == null || storeInfo.getStore().isClosed()) {
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            configMap.put("fileName", configVo.getQueue());
            if (configVo.isReadOnlyMode()) {
                configMap.put("readOnly", 1);
            }
            if (configVo.isCompressMode()) {
                configMap.put("compress", 1);
            }
            FileQueueCustomConfigVo customConfigVo = configVo.getCustomConfig() == null ? new FileQueueCustomConfigVo() : configVo.getCustomConfig();
            configMap.put("autoCommitBufferSize", customConfigVo.getAutoCommitMemory());
            try {
                String configInfo = DataUtils.appendMap((StringBuilder)new StringBuilder(), configMap).toString();
                MVStore.Builder builder = MVStore.Builder.fromString((String)configInfo);
                if (configVo.isEncryptMode()) {
                    builder.encryptionKey("123ENCRYPT_KEY321".toCharArray());
                }
                MVStore store = builder.open();
                store.setAutoCommitDelay(customConfigVo.getAutoCommitDelay());
                store.setCacheSize(customConfigVo.getCacheSize());
                store.compact(1, 50);
                storeInfo.setStore(store);
                storeInfo.setStoreOpenTime(LocalDateTime.now());
            }
            catch (Exception e) {
                logger.error("openStore failed", (Throwable)e);
                throw new InitializeException("\ud050 \uc624\ud508 \uc2e4\ud328: \ud050=[" + configVo.getQueueName() + "], \uc5d0\ub7ec=[" + e.getMessage() + "]", e);
            }
        }
    }

    private static void checkFile(StoreInfo storeInfo) throws InitializeException {
        logger.debug("validate queue={}", (Object)storeInfo.getCONFIG().getQueue());
        FileQueueConfigVo config = storeInfo.getCONFIG();
        String queue = config.getQueue();
        if (queue == null || queue.trim().isEmpty()) {
            throw new InitializeException("\ud050 \ud65c\uc131\ud654 \uc2e4\ud328: \ud050 \uc815\ubcf4 \ub204\ub77d = \ud050:[" + queue + "]");
        }
        String queueName = config.getQueueName();
        if (queueName == null || queueName.trim().isEmpty()) {
            throw new InitializeException("\ud050 \ud65c\uc131\ud654 \uc2e4\ud328: \ud050 \uc774\ub984 \uc815\ubcf4 \ub204\ub77d = \ud050:[" + queue + "]");
        }
        String queuePath = config.getQueuePath();
        if (queuePath == null || queuePath.trim().isEmpty()) {
            throw new InitializeException("\ud050 \ud65c\uc131\ud654 \uc2e4\ud328: \ud050 \uacbd\ub85c \uc815\ubcf4 \ub204\ub77d = \ud050:[" + queue + "]");
        }
        Path p = Paths.get(queuePath, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new InitializeException("\ud050 \ud65c\uc131\ud654 \uc2e4\ud328: \uc874\uc7ac\ud558\uc9c0 \uc54a\uc740 \uacbd\ub85c = \uacbd\ub85c \uc815\ubcf4:[" + queuePath + "]");
        }
        if (!Files.isWritable(p)) {
            throw new InitializeException("\ud050 \ud65c\uc131\ud654 \uc2e4\ud328: \uc9c0\uc815 \ud30c\uc77c\uc774 \uc4f0\uae30 \uac00\ub2a5 \uc0c1\ud0dc\uac00 \uc544\ub2d8 = \uacbd\ub85c \uc815\ubcf4:[" + queuePath + "]");
        }
        if (Files.exists(Paths.get(queue, new String[0]), new LinkOption[0])) {
            config.setRestoreMode(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkStore(String filePath) throws InitializeException {
        MVStore store = null;
        try {
            store = new MVStore.Builder().fileName(filePath).open();
            int writeFormatVersion = ControllerFactory.getWriteFormatVersion(store);
            int lastChunkId = ControllerFactory.getLastChunkIdFromFileStore(store);
            int threshold = 0x3999998;
            if (lastChunkId >= threshold) {
                String msg = String.format("lastChunkId [%d] approaching MAX_ID [%d].", lastChunkId, 0x3FFFFFF);
                logger.warn("\u26a0 {}", (Object)msg);
                if (writeFormatVersion < 3) {
                    throw new InitializeException(msg);
                }
            } else {
                logger.info("\u2713 lastChunkId OK: {}", (Object)lastChunkId);
            }
            if (store.hasUnsavedChanges()) {
                logger.warn("\u26a0 Store has unsaved changes. Consider rollback or recovery. Executing rollback...");
                store.rollback();
                if (store.hasUnsavedChanges()) {
                    throw new InitializeException("Rollback failed. Store remains dirty.");
                }
                logger.info("\u2713 Rollback completed. Store is now clean.");
            } else {
                logger.info("\u2713 Store has no unsaved changes.");
            }
            Map meta = store.getStoreHeader();
            for (Map.Entry entry : meta.entrySet()) {
                logger.info("[HEADER INFO] {} = {}", entry.getKey(), entry.getValue());
            }
        }
        catch (MVStoreException e) {
            logger.error("\u274c Failed to open MVStore. Possibly due to unsupported format or file corruption: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u274c Unexpected error during MVStore health check", (Throwable)e);
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static int getWriteFormatVersion(MVStore store) {
        Map header = store.getStoreHeader();
        return header.get("format") == null ? 3 : Integer.parseInt(header.get("format").toString());
    }

    private static int getLastChunkIdFromFileStore(MVStore store) throws InitializeException {
        try {
            Field fileStoreField = MVStore.class.getDeclaredField("fileStore");
            fileStoreField.setAccessible(true);
            Object fileStore = fileStoreField.get(store);
            try {
                Field lastChunkIdField = fileStore.getClass().getSuperclass().getSuperclass().getDeclaredField("lastChunkId");
                lastChunkIdField.setAccessible(true);
                return lastChunkIdField.getInt(fileStore);
            }
            catch (NoSuchFieldException e) {
                logger.warn("\u26a0 Field 'lastChunkId' not found in FileStore. Trying MVStore...");
            }
        }
        catch (Exception e) {
            logger.warn("\u26a0 Failed to access FileStore from MVStore. Possibly older version. Trying MVStore directly...");
        }
        try {
            Field legacyField = MVStore.class.getDeclaredField("lastChunkId");
            legacyField.setAccessible(true);
            return legacyField.getInt(store);
        }
        catch (Exception e) {
            throw new InitializeException("Unable to access lastChunkId. Unsupported or unknown MVStore structure.", e);
        }
    }
}

