/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller;

import com.queue.file.controller.PartitionManager;
import com.queue.file.controller.StatsTracker;
import com.queue.file.exception.InitializeException;
import com.queue.file.exception.QueueException;
import com.queue.file.exception.QueueReadException;
import com.queue.file.exception.QueueWriteException;
import com.queue.file.exception.UnsteadyStateException;
import com.queue.file.vo.ActionType;
import com.queue.file.vo.FileQueueConfigVo;
import com.queue.file.vo.FileQueueCustomConfigVo;
import com.queue.file.vo.FileQueueData;
import com.queue.file.vo.PartitionContext;
import com.queue.file.vo.PartitionSummaryVo;
import com.queue.file.vo.StoreInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccess {
    private static final Logger logger = LoggerFactory.getLogger(DataAccess.class);
    private final StatsTracker statsTracker = new StatsTracker();
    private final StoreInfo storeInfo;
    private final PartitionManager partitionManager;

    public DataAccess(StoreInfo storeInfo, PartitionManager partitionManager) {
        this.storeInfo = storeInfo;
        this.partitionManager = partitionManager;
    }

    public void write(String tag, String partition, String executorName, String data) throws QueueException {
        if (data == null || data.isEmpty()) {
            return;
        }
        logger.debug("write tag={} partition={} executor={}", new Object[]{tag, partition, executorName});
        this.writeQueueData(executorName, Collections.singletonList(new FileQueueData(partition, tag, data)));
    }

    public void writeBulk(String tag, String partition, String executorName, List<String> dataList) throws QueueException {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        logger.debug("writeBulk tag={} partition={} executor={} size={}", new Object[]{tag, partition, executorName, dataList.size()});
        ArrayList<FileQueueData> storeDataList = new ArrayList<FileQueueData>(dataList.size());
        for (String data : dataList) {
            storeDataList.add(new FileQueueData(partition, tag, data));
        }
        this.writeQueueData(executorName, storeDataList);
    }

    public void writeQueueData(String executorName, List<FileQueueData> storeDataList) throws QueueException {
        try {
            this.partitionManager.checkStore();
        }
        catch (UnsteadyStateException e) {
            throw new QueueException(e);
        }
        logger.debug("writeQueueData executor={} size={}", (Object)executorName, (Object)(storeDataList == null ? 0 : storeDataList.size()));
        if (storeDataList == null || storeDataList.isEmpty()) {
            return;
        }
        FileQueueConfigVo configVo = this.storeInfo.getCONFIG();
        FileQueueCustomConfigVo customConfigVo = configVo.getCustomConfig();
        Map<String, List<FileQueueData>> groupedByPartition = storeDataList.stream().collect(Collectors.groupingBy(FileQueueData::getPartition));
        List<String> acquiredPartitions = this.acquireAllPartitionLocks(groupedByPartition.keySet());
        boolean needsRollback = false;
        try {
            boolean isBulk;
            for (Map.Entry<String, List<FileQueueData>> entry : groupedByPartition.entrySet()) {
                String partitionName = entry.getKey();
                List<FileQueueData> partitionDataList = entry.getValue();
                this.processPartitionData(partitionName, partitionDataList, executorName);
            }
            int totalDataCount = storeDataList.size();
            boolean bl = isBulk = totalDataCount >= customConfigVo.getBulkSize();
            if (isBulk && customConfigVo.isBulkCommit()) {
                this.storeInfo.getStore().commit();
                needsRollback = true;
            }
        }
        catch (Exception e) {
            if (needsRollback) {
                try {
                    this.storeInfo.getStore().rollback();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            logger.error("writeQueueData failed", (Throwable)e);
            throw new QueueWriteException("\ud050 \uc785\ub825 \uc911 \uc608\uc678 \ubc1c\uc0dd = \ud050:[" + configVo.getQueueName() + "]", e);
        }
        finally {
            this.releaseAllLocks(acquiredPartitions);
        }
    }

    private List<String> acquireAllPartitionLocks(Set<String> partitionNames) throws QueueException {
        ArrayList<String> sortedPartitions = new ArrayList<String>(partitionNames);
        Collections.sort(sortedPartitions);
        logger.debug("acquire locks for partitions={}", sortedPartitions);
        try {
            for (String partitionName : sortedPartitions) {
                PartitionContext partitionContext;
                try {
                    partitionContext = this.partitionManager.getPartitionContext(partitionName);
                }
                catch (InitializeException e) {
                    throw new QueueException("\uc2e0\uaddc \ud30c\ud2f0\uc158 \uc785\ub825 - \ud30c\uc77c \uc4f0\uae30 \uc911 " + partitionName + " \ud30c\ud2f0\uc158 Context \uc0dd\uc131 \uc911 \uc608\uc678 \ubc1c\uc0dd", e);
                }
                ReentrantReadWriteLock lock = partitionContext.getLock();
                lock.writeLock().lock();
            }
            return sortedPartitions;
        }
        catch (Exception e) {
            this.releaseAllLocks(sortedPartitions);
            logger.error("acquireAllPartitionLocks failed", (Throwable)e);
            throw new QueueException(e);
        }
    }

    private void processPartitionData(String partitionName, List<FileQueueData> partitionDataList, String executorName) throws QueueException {
        PartitionContext partitionContext = null;
        logger.debug("process partition data partition={} executor={} size={}", new Object[]{partitionName, executorName, partitionDataList == null ? 0 : partitionDataList.size()});
        try {
            partitionContext = this.partitionManager.getPartitionContext(partitionName);
        }
        catch (InitializeException e) {
            throw new QueueWriteException(partitionName + " \uc2e0\uaddc \ud30c\ud2f0\uc158 Context \uc0dd\uc131 \uc911 \uc608\uc678 \ubc1c\uc0dd", e);
        }
        try {
            long groupKey = partitionContext.getGroupKey();
            ConcurrentSkipListSet<Long> dataKeyList = partitionContext.getTransactionKeyList();
            MVMap<Long, FileQueueData> dataMap = partitionContext.getDataMap();
            if (dataMap == null || dataMap.isClosed()) {
                throw new QueueWriteException(partitionContext.getPartitionName() + " \ud30c\ud2f0\uc158 \ub370\uc774\ud130 \uac1d\uccb4\uac00 \ube44\uc815\uc0c1\uc801\uc778 \uc0c1\ud0dc");
            }
            for (FileQueueData queueData : partitionDataList) {
                long innerKey = partitionContext.getTransactionKey();
                queueData.setTransactionKey(innerKey);
                queueData.setGroupTransactionKey(groupKey);
                dataMap.put((Object)innerKey, (Object)queueData);
                dataKeyList.add(innerKey);
            }
            this.statsTracker.keepRecord(partitionName, executorName, partitionDataList.size(), ActionType.INPUT);
        }
        catch (Exception e) {
            logger.error("processPartitionData failed partition={}", (Object)partitionContext.getPartitionName(), (Object)e);
            throw new QueueWriteException("\ud30c\ud2f0\uc158 \ub370\uc774\ud130 \ucc98\ub9ac \uc911 \uc608\uc678 \ubc1c\uc0dd - \ud30c\ud2f0\uc158: " + partitionContext.getPartitionName(), e);
        }
    }

    private void releaseAllLocks(List<String> acquiredLockPartitions) {
        logger.debug("release locks for partitions={}", acquiredLockPartitions);
        for (int i = acquiredLockPartitions.size() - 1; i >= 0; --i) {
            PartitionContext partitionContext;
            try {
                partitionContext = this.partitionManager.getPartitionContext(acquiredLockPartitions.get(i));
            }
            catch (InitializeException e) {
                continue;
            }
            try {
                partitionContext.getLock().writeLock().unlock();
                continue;
            }
            catch (Exception e) {
                logger.warn("\ub77d \ud574\uc81c \uc911 \uc608\uc678 \ubc1c\uc0dd: {}", (Object)e.getMessage());
            }
        }
    }

    public FileQueueData read(String partitionName, String executorName) throws QueueException {
        logger.debug("read single partition={} executor={}", (Object)partitionName, (Object)executorName);
        List<FileQueueData> fileQueueDataList = this.read(partitionName, executorName, 1);
        return fileQueueDataList == null || fileQueueDataList.isEmpty() ? null : fileQueueDataList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileQueueData> read(String partitionName, String executorName, int requestCount) throws QueueException {
        List<FileQueueData> bufferDataList;
        logger.debug("read partition={} executor={} count={}", new Object[]{partitionName, executorName, requestCount});
        if (this.storeInfo.getStoreOpenTime() == null) {
            throw new QueueReadException("open \ub418\uc9c0 \uc54a\uc74c - open() \ud638\ucd9c \ud544\uc694");
        }
        FileQueueConfigVo configVo = this.storeInfo.getCONFIG();
        FileQueueCustomConfigVo customConfigVo = configVo.getCustomConfig();
        this.statsTracker.keepRecord(partitionName, executorName, ActionType.OUTPUT_INVOKE);
        boolean isCommited = false;
        if (customConfigVo.isStableMode() && (bufferDataList = this.readBuffer(partitionName, executorName)) != null && !bufferDataList.isEmpty()) {
            return bufferDataList;
        }
        PartitionContext partitionContext = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (partitionContext == null) {
            return null;
        }
        ReentrantReadWriteLock lock = partitionContext.getLock();
        ConcurrentSkipListSet<Long> dataKeyList = partitionContext.getTransactionKeyList();
        MVMap<Long, FileQueueData> dataMap = partitionContext.getDataMap();
        if (dataMap == null || dataMap.isClosed()) {
            throw new QueueReadException(partitionName + "\ud30c\ud2f0\uc158 \ub370\uc774\ud130 \uc601\uc5ed\uc774 \ube44\uc815\uc0c1\uc801\uc778 \uc0c1\ud0dc");
        }
        lock.readLock().lock();
        try {
            if (dataMap.isEmpty()) {
                List<FileQueueData> list = null;
                return list;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            MVMap<String, List<FileQueueData>> readBufferMap;
            int selectCount = Math.min(requestCount, dataMap.size());
            if (selectCount < 1) {
                List<FileQueueData> list = null;
                return list;
            }
            boolean isBulk = selectCount >= customConfigVo.getBulkSize();
            List<FileQueueData> queueDataList = this.extractData(partitionName, dataKeyList, dataMap, selectCount);
            if (customConfigVo.isStableMode() && (readBufferMap = partitionContext.getReadBufferMap()) != null && !readBufferMap.isClosed()) {
                readBufferMap.put((Object)executorName, queueDataList);
                this.statsTracker.keepRecord(partitionName, executorName, ActionType.BUFFER_INPUT);
            }
            if (isBulk && customConfigVo.isBulkCommit()) {
                this.storeInfo.getStore().commit();
                isCommited = true;
            }
            this.statsTracker.keepRecord(partitionName, executorName, queueDataList.size(), ActionType.OUTPUT);
            List<FileQueueData> list = queueDataList;
            return list;
        }
        catch (QueueReadException e) {
            logger.error("read failed: {}", (Object)e.getMessage());
            throw new QueueReadException("\ud050:[" + configVo.getQueueName() + "] " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (isCommited) {
                this.storeInfo.getStore().rollback();
            }
            logger.error("read failed", (Throwable)e);
            throw new QueueReadException("<\uc77d\uae30 : \uc2e4\ud328> = \ud050:[" + configVo.getQueueName() + "]", e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private List<FileQueueData> extractData(String partitionName, ConcurrentSkipListSet<Long> dataKeyList, MVMap<Long, FileQueueData> dataMap, int selectCount) throws QueueException {
        logger.debug("extractData partition={} count={}", (Object)partitionName, (Object)selectCount);
        ArrayList<FileQueueData> queueDataList = new ArrayList<FileQueueData>(selectCount);
        try {
            this.partitionManager.realignDataKey(partitionName);
            for (int i = 1; i <= selectCount; ++i) {
                FileQueueData data;
                Long transKey = dataKeyList.pollFirst();
                if (transKey == null || (data = (FileQueueData)dataMap.remove((Object)transKey)) == null) continue;
                queueDataList.add(data);
            }
            return queueDataList;
        }
        catch (Exception e) {
            logger.error("extractData failed partition={}", (Object)partitionName, (Object)e);
            throw new QueueReadException("\ub370\uc774\ud130 \ucd94\ucd9c \uc911 \uc608\uc678 \ubc1c\uc0dd = \ud30c\ud2f0\uc158:" + partitionName, e);
        }
    }

    private List<FileQueueData> readBuffer(String partitionName, String executorName) throws QueueException {
        this.statsTracker.keepRecord(partitionName, executorName, ActionType.BUFFER_OUTPUT_INVOKE);
        logger.debug("readBuffer partition={} executor={}", (Object)partitionName, (Object)executorName);
        List queueDataList = null;
        PartitionContext partitionContext = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (partitionContext == null) {
            return null;
        }
        MVMap<String, List<FileQueueData>> readBufferMap = partitionContext.getReadBufferMap();
        if (readBufferMap == null || readBufferMap.isClosed()) {
            return null;
        }
        ReentrantReadWriteLock lock = partitionContext.getLock();
        lock.readLock().lock();
        try {
            List list = queueDataList = (List)readBufferMap.get((Object)executorName);
            return list;
        }
        catch (Exception e) {
            logger.error("readBuffer failed partition={} executor={}", new Object[]{partitionName, executorName, e});
            throw new QueueReadException(partitionName + "\ud30c\ud2f0\uc158\uc758 " + executorName + "\ubc84\ud37c \uc601\uc5ed \ub370\uc774\ud130 \ud30c\uc2f1 \uc911 \uc608\uc678 \ubc1c\uc0dd - \uc6d0\ubcf8 \ub370\uc774\ud130 \uc815\ubcf4:" + queueDataList, e);
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public void readCommit(String partitionName, String executorName) throws QueueException {
        if (this.storeInfo.getStoreOpenTime() == null) {
            throw new QueueReadException("open \ub418\uc9c0 \uc54a\uc74c - open() \ud638\ucd9c \ud544\uc694");
        }
        PartitionContext partitionContext = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (partitionContext == null) {
            return;
        }
        MVMap<String, List<FileQueueData>> readBufferMap = partitionContext.getReadBufferMap();
        if (readBufferMap == null || readBufferMap.isClosed()) {
            return;
        }
        ReentrantReadWriteLock lock = partitionContext.getLock();
        lock.writeLock().lock();
        try {
            logger.debug("readCommit partition={} executor={}", (Object)partitionName, (Object)executorName);
            readBufferMap.remove((Object)executorName);
            this.statsTracker.keepRecord(partitionName, executorName, ActionType.BUFFER_OUTPUT);
        }
        catch (Exception e) {
            logger.error("readCommit failed", (Throwable)e);
            throw new QueueReadException("[" + this.storeInfo.getCONFIG().getQueueName() + "] \ud050, \ubc84\ud37c COMMIT \uc2e4\ud328 - \ud30c\ud2f0\uc158:" + partitionName, e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PartitionSummaryVo> getSummaryInfo() {
        HashMap<String, PartitionSummaryVo> result = new HashMap<String, PartitionSummaryVo>();
        for (Map.Entry<String, PartitionContext> entry : this.partitionManager.getPartitionContextMap().entrySet()) {
            String partitionName = entry.getKey();
            PartitionContext ctx = entry.getValue();
            ctx.getLock().readLock().lock();
            try {
                int dataCnt = ctx.getDataMap() == null ? 0 : ctx.getDataMap().size();
                int bufferCnt = ctx.getReadBufferMap() == null ? 0 : ctx.getReadBufferMap().size();
                int cacheCnt = ctx.getCacheMap() == null ? 0 : ctx.getCacheMap().size();
                result.put(partitionName, new PartitionSummaryVo(partitionName, dataCnt, bufferCnt, cacheCnt));
            }
            finally {
                ctx.getLock().readLock().unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileQueueData> getPartitionDataList(String partitionName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return Collections.emptyList();
        }
        ctx.getLock().readLock().lock();
        try {
            if (ctx.getDataMap() == null) {
                List<FileQueueData> list = Collections.emptyList();
                return list;
            }
            ArrayList<FileQueueData> arrayList = new ArrayList<FileQueueData>(ctx.getDataMap().values());
            return arrayList;
        }
        finally {
            ctx.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<FileQueueData>> getPartitionBufferList(String partitionName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return Collections.emptyMap();
        }
        ctx.getLock().readLock().lock();
        try {
            if (ctx.getReadBufferMap() == null) {
                Map<String, List<FileQueueData>> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, List<FileQueueData>> hashMap = new HashMap<String, List<FileQueueData>>((Map<String, List<FileQueueData>>)ctx.getReadBufferMap());
            return hashMap;
        }
        finally {
            ctx.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getPartitionCacheList(String partitionName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return Collections.emptyMap();
        }
        ctx.getLock().readLock().lock();
        try {
            if (ctx.getCacheMap() == null) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>((Map<String, Object>)ctx.getCacheMap());
            return hashMap;
        }
        finally {
            ctx.getLock().readLock().unlock();
        }
    }

    public Map<String, List<FileQueueData>> getAllDataList() {
        HashMap<String, List<FileQueueData>> result = new HashMap<String, List<FileQueueData>>();
        for (String p : this.partitionManager.getPartitionContextMap().keySet()) {
            result.put(p, this.getPartitionDataList(p));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileQueueData getData(String partitionName, Long transactionKey) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return null;
        }
        ctx.getLock().readLock().lock();
        try {
            FileQueueData fileQueueData = ctx.getDataMap() == null ? null : (FileQueueData)ctx.getDataMap().get((Object)transactionKey);
            return fileQueueData;
        }
        finally {
            ctx.getLock().readLock().unlock();
        }
    }

    public void clearAllData() {
        for (String p : this.partitionManager.getPartitionContextMap().keySet()) {
            this.clearData(p);
        }
    }

    public void clearData(String partitionName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return;
        }
        ctx.getLock().writeLock().lock();
        try {
            if (ctx.getDataMap() != null) {
                ctx.getDataMap().clear();
            }
            if (ctx.getTransactionKeyList() != null) {
                ctx.getTransactionKeyList().clear();
            }
        }
        finally {
            ctx.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String partitionName, Long transactionKey) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return;
        }
        ctx.getLock().writeLock().lock();
        try {
            if (ctx.getDataMap() != null) {
                ctx.getDataMap().remove((Object)transactionKey);
            }
            if (ctx.getTransactionKeyList() != null) {
                ctx.getTransactionKeyList().remove(transactionKey);
            }
        }
        finally {
            ctx.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileQueueData> getBuffer(String partitionName, String executorName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return Collections.emptyList();
        }
        ctx.getLock().readLock().lock();
        try {
            MVMap<String, List<FileQueueData>> map = ctx.getReadBufferMap();
            if (map == null) {
                List<FileQueueData> list = Collections.emptyList();
                return list;
            }
            List list = (List)map.get(executorName);
            ArrayList<FileQueueData> arrayList = list == null ? Collections.emptyList() : new ArrayList<FileQueueData>(list);
            return arrayList;
        }
        finally {
            ctx.getLock().readLock().unlock();
        }
    }

    public void clearAllBuffer() {
        for (String p : this.partitionManager.getPartitionContextMap().keySet()) {
            this.clearBuffer(p);
        }
    }

    public void clearBuffer(String partitionName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return;
        }
        ctx.getLock().writeLock().lock();
        try {
            if (ctx.getReadBufferMap() != null) {
                ctx.getReadBufferMap().clear();
            }
        }
        finally {
            ctx.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer(String partitionName, String executorName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return;
        }
        ctx.getLock().writeLock().lock();
        try {
            if (ctx.getReadBufferMap() != null) {
                ctx.getReadBufferMap().remove((Object)executorName);
            }
        }
        finally {
            ctx.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCache(String partitionName, String cacheKey) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return null;
        }
        ctx.getLock().readLock().lock();
        try {
            Object object = ctx.getCacheMap() == null ? null : ctx.getCacheMap().get((Object)cacheKey);
            return object;
        }
        finally {
            ctx.getLock().readLock().unlock();
        }
    }

    public void clearAllCache() {
        for (String p : this.partitionManager.getPartitionContextMap().keySet()) {
            this.clearCache(p);
        }
    }

    public void clearCache(String partitionName) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return;
        }
        ctx.getLock().writeLock().lock();
        try {
            if (ctx.getCacheMap() != null) {
                ctx.getCacheMap().clear();
            }
        }
        finally {
            ctx.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String partitionName, String cacheKey) {
        PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
        if (ctx == null) {
            return;
        }
        ctx.getLock().writeLock().lock();
        try {
            if (ctx.getCacheMap() != null) {
                ctx.getCacheMap().remove((Object)cacheKey);
            }
        }
        finally {
            ctx.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOne(String partitionName, String executorName) {
        block11: {
            PartitionContext ctx = this.partitionManager.getPartitionContextMap().get(partitionName);
            if (ctx == null) {
                return;
            }
            ctx.getLock().writeLock().lock();
            try {
                MVMap<String, List<FileQueueData>> bufferMap = ctx.getReadBufferMap();
                if (bufferMap != null && bufferMap.containsKey((Object)executorName)) {
                    bufferMap.remove((Object)executorName);
                    return;
                }
                MVMap<Long, FileQueueData> dataMap = ctx.getDataMap();
                if (dataMap == null || dataMap.isEmpty()) {
                    return;
                }
                ConcurrentSkipListSet<Long> keyList = ctx.getTransactionKeyList();
                Long firstKey = null;
                if (keyList == null) break block11;
                try {
                    this.partitionManager.realignDataKey(partitionName);
                }
                catch (UnsteadyStateException unsteadyStateException) {
                    // empty catch block
                }
                firstKey = keyList.pollFirst();
                if (firstKey != null) {
                    dataMap.remove((Object)firstKey);
                    keyList.remove(firstKey);
                }
            }
            finally {
                ctx.getLock().writeLock().unlock();
            }
        }
    }
}

